/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.model.aif;

import java.util.Random;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAddress;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAggregate;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeBool;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeCharPointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeEnum;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeFunction;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeInt;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeNamed;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeString;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeUnion;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeVoid;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIF;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFType;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeAddress;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeAggregate;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeArray;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeBool;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeChar;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeCharPointer;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeEnum;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeFloat;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeFunction;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeIncomplete;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeInt;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeNamed;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypePointer;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeRange;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeReference;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeString;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeUnion;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeVoid;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueAddress;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueAggregate;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueArray;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueBool;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueChar;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueCharPointer;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueEnum;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueFloat;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueFunction;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueInt;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueNamed;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValuePointer;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueReference;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueString;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueUnion;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueUnknown;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValueVoid;

public class AIFFactory {
    public static final char FDS_ARRAY = '[';
    public static final char FDS_BOOL = 'b';
    public static final char FDS_CHAR = 'c';
    public static final char FDS_ENUM = '<';
    public static final char FDS_FLOAT = 'f';
    public static final char FDS_FUNCTION = '&';
    public static final char FDS_INT = 'i';
    public static final char FDS_POINTER = '^';
    public static final char FDS_STRING = 's';
    public static final char FDS_AGGREGATE = '{';
    public static final char FDS_UNION = '(';
    public static final char FDS_VOID = 'v';
    public static final char FDS_REFERENCE = '>';
    public static final char FDS_NAMED = '%';
    public static final char FDS_ADDRESS = 'a';
    public static final char FDS_RANGE = 'r';
    public static final char FDS_CHAR_POINTER = 'p';
    public static final int FDS_FLOAT_SIZE_POS = 1;
    public static final int FDS_VOID_SIZE_POS = 1;
    public static final int FDS_INTEGER_SIGN_POS = 1;
    public static final int FDS_INTEGER_SIZE_POS = 2;
    public static final char FDS_ARRAY_END = ']';
    public static final char FDS_TYPENAME_END = '|';
    public static final char FDS_AGGREGATE_FIELD_NAME_END = '=';
    public static final char FDS_AGGREGATE_FIELD_SEP = ',';
    public static final char FDS_AGGREGATE_ACCESS_SEP = ';';
    public static final char FDS_AGGREGATE_END = '}';
    public static final char FDS_UNION_FIELD_NAME_END = '=';
    public static final char FDS_UNION_FIELD_SEP = ',';
    public static final char FDS_UNION_END = ')';
    public static final char FDS_ENUM_CONST_SEP = ',';
    public static final char FDS_ENUM_SEP = '=';
    public static final char FDS_ENUM_END = '>';
    public static final char FDS_FUNCTION_END = '/';
    public static final char FDS_FUNCTION_ARG_SEP = ',';
    public static final char FDS_INTEGER_SIGNED = 's';
    public static final char FDS_INTEGER_UNSIGNED = 'u';
    public static final char FDS_REFERENCE_END = '/';
    public static final char FDS_NAMED_END = '/';
    public static final char FDS_RANGE_SEP = ',';
    public static final int NO_SIZE = 0;
    public static final int SIZE_BOOL = 1;
    public static final int SIZE_CHAR = 1;
    public static final int SIZE_FLOAT = 4;
    public static final int SIZE_DOUBLE = 8;
    public static final int SIZE_INVALID = 0;
    public static final IAIFType UNKNOWNTYPE = new AIFTypeIncomplete();
    public static final IAIFValue UNKNOWNVALUE = new AIFValueUnknown(UNKNOWNTYPE);
    private static IAIFType fLastType;

    public static IAIFType getAIFType(String fmt) throws AIFFormatException {
        AIFFactory.parseType(fmt);
        return fLastType;
    }

    public static IAIFValue getAIFValue(IValueParent parent, IAIFType type, byte[] data) {
        if (data == null || data.length < 0) {
            return new AIFValueUnknown(type);
        }
        return AIFFactory.getAIFValue(parent, type, new SimpleByteBuffer(data));
    }

    public static IAIFValue getAIFValue(IValueParent parent, IAIFType type, SimpleByteBuffer buffer) {
        if (buffer.end()) {
            return new AIFValueUnknown(type);
        }
        if (type instanceof IAIFTypeChar) {
            return new AIFValueChar((IAIFTypeChar)type, buffer);
        }
        if (type instanceof IAIFTypeFloat) {
            return new AIFValueFloat((IAIFTypeFloat)type, buffer);
        }
        if (type instanceof IAIFTypeInt) {
            return new AIFValueInt((IAIFTypeInt)type, buffer);
        }
        if (type instanceof IAIFTypeCharPointer) {
            return new AIFValueCharPointer((IAIFTypeCharPointer)type, buffer);
        }
        if (type instanceof IAIFTypeString) {
            return new AIFValueString((IAIFTypeString)type, buffer);
        }
        if (type instanceof IAIFTypeBool) {
            return new AIFValueBool((IAIFTypeBool)type, buffer);
        }
        if (type instanceof IAIFTypeArray) {
            return new AIFValueArray((IAIFTypeArray)type, buffer);
        }
        if (type instanceof IAIFTypeEnum) {
            return new AIFValueEnum((IAIFTypeEnum)type, buffer);
        }
        if (type instanceof IAIFTypeAddress) {
            return new AIFValueAddress((IAIFTypeAddress)type, buffer);
        }
        if (type instanceof IAIFTypePointer) {
            return new AIFValuePointer(parent, (IAIFTypePointer)type, buffer);
        }
        if (type instanceof IAIFTypeNamed) {
            return new AIFValueNamed(parent, (IAIFTypeNamed)type, buffer);
        }
        if (type instanceof IAIFTypeReference) {
            return new AIFValueReference(parent, (IAIFTypeReference)type, buffer);
        }
        if (type instanceof IAIFTypeUnion) {
            return new AIFValueUnion(parent, (IAIFTypeUnion)type, buffer);
        }
        if (type instanceof IAIFTypeAggregate) {
            return new AIFValueAggregate(parent, (IAIFTypeAggregate)type, buffer);
        }
        if (type instanceof IAIFTypeVoid) {
            return new AIFValueVoid(type, buffer);
        }
        if (type instanceof IAIFTypeFunction) {
            return new AIFValueFunction((IAIFTypeFunction)type, buffer);
        }
        return new AIFValueUnknown(type);
    }

    public static int getFirstNonDigitPos(String format, int start, boolean neg) {
        int len = format.length();
        if (format.charAt(start) == '-') {
            ++start;
        }
        while (start < len) {
            if (!Character.isDigit(format.charAt(start))) break;
            ++start;
        }
        return start;
    }

    public static IAIFType getType() {
        return fLastType;
    }

    public static IAIF newAIF(IAIFType aifType, IAIFValue aifValue) {
        return AIFFactory.newAIF(aifType, aifValue, "");
    }

    public static IAIF newAIF(IAIFType aifType, IAIFValue aifValue, String desc) {
        return new AIF(aifType, aifValue, desc);
    }

    public static IAIF newAIF(String fds, byte[] data) throws AIFFormatException {
        return AIFFactory.newAIF(fds, data, "");
    }

    public static IAIF newAIF(String fds, byte[] data, String description) throws AIFFormatException {
        IAIFType type = AIFFactory.getAIFType(fds);
        IAIFValue val = AIFFactory.getAIFValue(null, type, data);
        return AIFFactory.newAIF(type, val, description);
    }

    public static String parseType(String fmt) throws AIFFormatException {
        AIFType type;
        String debugStr = "";
        if (fmt == null || fmt.length() == 0) {
            PDebugUtils.println(String.valueOf(Messages.AIFFactory_0) + fmt);
            fLastType = UNKNOWNTYPE;
            return fmt;
        }
        char typeChar = fmt.charAt(0);
        fmt = fmt.substring(1);
        switch (typeChar) {
            case 'c': {
                debugStr = Messages.AIFFactory_1;
                type = new AIFTypeChar();
                break;
            }
            case 'f': {
                debugStr = Messages.AIFFactory_2;
                type = new AIFTypeFloat();
                break;
            }
            case 'i': {
                debugStr = Messages.AIFFactory_4;
                type = new AIFTypeInt();
                break;
            }
            case 'p': {
                debugStr = Messages.AIFFactory_6;
                type = new AIFTypeCharPointer();
                break;
            }
            case 's': {
                debugStr = Messages.AIFFactory_7;
                type = new AIFTypeString();
                break;
            }
            case 'b': {
                debugStr = Messages.AIFFactory_8;
                type = new AIFTypeBool();
                break;
            }
            case '<': {
                debugStr = Messages.AIFFactory_9;
                type = new AIFTypeEnum();
                break;
            }
            case '&': {
                debugStr = Messages.AIFFactory_10;
                type = new AIFTypeFunction();
                break;
            }
            case '{': {
                debugStr = Messages.AIFFactory_12;
                type = new AIFTypeAggregate();
                break;
            }
            case '(': {
                debugStr = Messages.AIFFactory_13;
                type = new AIFTypeUnion();
                break;
            }
            case '>': {
                debugStr = Messages.AIFFactory_14;
                type = new AIFTypeReference();
                break;
            }
            case 'a': {
                debugStr = Messages.AIFFactory_15;
                type = new AIFTypeAddress();
                break;
            }
            case '^': {
                debugStr = Messages.AIFFactory_16;
                type = new AIFTypePointer();
                break;
            }
            case 'v': {
                debugStr = Messages.AIFFactory_17;
                type = new AIFTypeVoid();
                break;
            }
            case '[': {
                debugStr = Messages.AIFFactory_18;
                type = new AIFTypeArray();
                break;
            }
            case 'r': {
                debugStr = Messages.AIFFactory_21;
                type = new AIFTypeRange();
                break;
            }
            case '%': {
                debugStr = Messages.AIFFactory_19;
                type = new AIFTypeNamed();
                break;
            }
            default: {
                PDebugUtils.println(String.valueOf(Messages.AIFFactory_20) + fmt);
                fLastType = new AIFTypeIncomplete();
                return "";
            }
        }
        fmt = type.parse(fmt);
        PDebugUtils.println(String.valueOf(debugStr) + type.toString());
        fLastType = type;
        return fmt;
    }

    public static int random_num(int min, int max) {
        Random generator = new Random();
        long range = (long)max - (long)min + 1L;
        long fraction = (long)((double)range * generator.nextDouble());
        return (int)(fraction + (long)min);
    }

    public static IAIF UNKNOWNAIF() {
        return AIFFactory.newAIF(UNKNOWNTYPE, UNKNOWNVALUE);
    }

    public static class SimpleByteBuffer {
        byte[] bytes;
        int pos = 0;

        SimpleByteBuffer(byte[] bytes) {
            if (bytes == null) {
                bytes = new byte[]{};
            }
            this.bytes = bytes;
        }

        public boolean end() {
            return this.pos == this.bytes.length;
        }

        public byte get() {
            return this.bytes[this.pos++];
        }

        public byte get(int pos) {
            return this.bytes[pos];
        }

        public byte[] getByte() {
            return this.bytes;
        }

        public int getCapacity() {
            return this.bytes.length;
        }

        public int getPosition() {
            return this.pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }
    }
}

