/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.typehierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.ptp.internal.rdt.ui.typehierarchy.RemoteTHViewPart;
import org.eclipse.ptp.internal.rdt.ui.typehierarchy.THHistoryAction;
import org.eclipse.ptp.internal.rdt.ui.typehierarchy.THHistoryListAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class THHistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private RemoteTHViewPart fHierarchyView;
    private Menu fMenu;

    public THHistoryDropDownAction(RemoteTHViewPart viewPart) {
        this.fHierarchyView = viewPart;
        this.fMenu = null;
        this.setToolTipText(Messages.THHistoryDropDownAction_tooltip);
        CPluginImages.setImageDescriptors((IAction)this, (String)"lcl16/", (String)"history_list.gif");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ICElement[] elements = this.fHierarchyView.getHistoryEntries();
        this.addEntries(this.fMenu, elements);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new THHistoryListAction(this.fHierarchyView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fHierarchyView));
        return this.fMenu;
    }

    private boolean addEntries(Menu menu, ICElement[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            THHistoryAction action = new THHistoryAction(this.fHierarchyView, elements[i]);
            action.setChecked(elements[i].equals(this.fHierarchyView.getInput()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new THHistoryListAction(this.fHierarchyView).run();
    }

    public static class ClearHistoryAction
    extends Action {
        private RemoteTHViewPart fView;

        public ClearHistoryAction(RemoteTHViewPart view) {
            super(Messages.THHistoryDropDownAction_ClearHistory);
            this.fView = view;
        }

        public void run() {
            this.fView.setHistoryEntries(new ICElement[0]);
            this.fView.setInput(null, null);
        }
    }
}

