/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.internal.ssh.CipherTypesMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CipherTypes {
    public static final String CIPHER_BLOWFISH = CipherTypesMessages.getString("KEY_BLOWFISH");
    public static final String CIPHER_3DES = CipherTypesMessages.getString("KEY_3DES");
    public static final String CIPHER_AES128 = CipherTypesMessages.getString("KEY_AES128");
    public static final String CIPHER_AES192 = CipherTypesMessages.getString("KEY_AES192");
    public static final String CIPHER_AES256 = CipherTypesMessages.getString("KEY_AES256");
    public static final String CIPHER_DEFAULT = CipherTypesMessages.getString("KEY_DEFAULT");
    public static final String NAME_CIPHER_BLOWFISH = CipherTypesMessages.getString("NAME_BLOWFISH");
    public static final String NAME_CIPHER_3DES = CipherTypesMessages.getString("NAME_3DES");
    public static final String NAME_CIPHER_AES128 = CipherTypesMessages.getString("NAME_AES128");
    public static final String NAME_CIPHER_AES192 = CipherTypesMessages.getString("NAME_AES192");
    public static final String NAME_CIPHER_AES256 = CipherTypesMessages.getString("NAME_AES256");
    public static final String NAME_CIPHER_DEFAULT = CipherTypesMessages.getString("NAME_DEFAULT");
    private static Map<String, String> cipherTypesMap = null;

    private static Map<String, String> createCipherTypesMap() {
        Field[] fields = CipherTypes.class.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
        HashMap<String, String> cipherMap = new HashMap<String, String>();
        for (Field f : fieldList) {
            if (!f.getName().startsWith("CIPHER_")) continue;
            Field ciphField = f;
            try {
                Field nameCiphField = CipherTypes.class.getField("NAME_" + ciphField.getName());
                try {
                    cipherMap.put((String)ciphField.get(null), (String)nameCiphField.get(null));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                throw new RuntimeException(NLS.bind((String)CipherTypesMessages.getString("CipherTypes.AttributeNameExceptionMsg2"), (Object)ciphField.getName()));
            }
        }
        return cipherMap;
    }

    public static Map<String, String> getCipherTypesMap() {
        if (cipherTypesMap == null) {
            cipherTypesMap = CipherTypes.createCipherTypesMap();
        }
        return cipherTypesMap;
    }

    protected CipherTypes() {
    }
}

