/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.generichost.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.environment.generichost.Activator;
import org.eclipse.ptp.remotetools.environment.generichost.conf.AttributeNames;
import org.eclipse.ptp.remotetools.environment.generichost.conf.DefaultValues;
import org.eclipse.ptp.remotetools.environment.generichost.core.TargetConfig;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;

public class ConfigFactory {
    private ControlAttributes attributes = null;
    private static final String PREFIX = "org.eclipse.ptp.remotetools.environment.generichost";
    public static final String ATTR_LOCALHOST_SELECTION = "org.eclipse.ptp.remotetools.environment.generichost.localhost-selection";
    public static final String ATTR_LOGIN_USERNAME = "org.eclipse.ptp.remotetools.environment.generichost.login-username";
    public static final String ATTR_LOGIN_PASSWORD = "org.eclipse.ptp.remotetools.environment.generichost.login-password";
    public static final String ATTR_CONNECTION_ADDRESS = "org.eclipse.ptp.remotetools.environment.generichost.connection-address";
    public static final String ATTR_CONNECTION_PORT = "org.eclipse.ptp.remotetools.environment.generichost.connection-port";
    public static final String ATTR_KEY_PATH = "org.eclipse.ptp.remotetools.environment.generichost.key-path";
    public static final String ATTR_KEY_PASSPHRASE = "org.eclipse.ptp.remotetools.environment.generichost.key-passphrase";
    public static final String ATTR_IS_PASSWORD_AUTH = "org.eclipse.ptp.remotetools.environment.generichost.is-passwd-auth";
    public static final String ATTR_CONNECTION_TIMEOUT = "org.eclipse.ptp.remotetools.environment.generichost.connection-timeout";
    public static final String ATTR_CIPHER_TYPE = "org.eclipse.ptp.remotetools.environment.generichost.cipher-type";
    public static final String[] KEY_ARRAY = new String[]{"org.eclipse.ptp.remotetools.environment.generichost.localhost-selection", "org.eclipse.ptp.remotetools.environment.generichost.login-username", "org.eclipse.ptp.remotetools.environment.generichost.connection-port", "org.eclipse.ptp.remotetools.environment.generichost.connection-address", "org.eclipse.ptp.remotetools.environment.generichost.key-path", "org.eclipse.ptp.remotetools.environment.generichost.is-passwd-auth", "org.eclipse.ptp.remotetools.environment.generichost.connection-timeout", "org.eclipse.ptp.remotetools.environment.generichost.cipher-type"};
    public static final String[] KEY_CIPHERED_ARRAY = new String[]{"org.eclipse.ptp.remotetools.environment.generichost.key-passphrase", "org.eclipse.ptp.remotetools.environment.generichost.login-password"};

    public ConfigFactory() {
        this(null);
    }

    public ConfigFactory(ControlAttributes attrs) {
        this.attributes = attrs != null ? attrs : new ControlAttributes();
        this.createDefaultMap();
        if (attrs == null) {
            this.createCurrentMapFromPreferences();
        }
    }

    public ControlAttributes getAttributes() {
        return this.attributes;
    }

    private void createDefaultMap() {
        this.attributes.setDefaultString(ATTR_LOCALHOST_SELECTION, DefaultValues.LOCALHOST_SELECTION);
        this.attributes.setDefaultString(ATTR_LOGIN_USERNAME, DefaultValues.LOGIN_USERNAME);
        this.attributes.setDefaultString(ATTR_LOGIN_PASSWORD, DefaultValues.LOGIN_PASSWORD);
        this.attributes.setDefaultString(ATTR_CONNECTION_PORT, DefaultValues.CONNECTION_PORT);
        this.attributes.setDefaultString(ATTR_CONNECTION_ADDRESS, DefaultValues.CONNECTION_ADDRESS);
        this.attributes.setDefaultString(ATTR_KEY_PATH, DefaultValues.KEY_PATH);
        this.attributes.setDefaultString(ATTR_KEY_PASSPHRASE, DefaultValues.KEY_PASSPHRASE);
        this.attributes.setDefaultString(ATTR_IS_PASSWORD_AUTH, DefaultValues.IS_PASSWORD_AUTH);
        this.attributes.setDefaultString(ATTR_CONNECTION_TIMEOUT, DefaultValues.CONNECTION_TIMEOUT);
        this.attributes.setDefaultString(ATTR_CIPHER_TYPE, RemotetoolsPlugin.CIPHER_DEFAULT);
    }

    private void createCurrentMapFromPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.attributes.setString(ATTR_LOGIN_USERNAME, store.getString(ATTR_LOGIN_USERNAME));
        this.attributes.setString(ATTR_CONNECTION_ADDRESS, store.getString(ATTR_CONNECTION_ADDRESS));
        this.attributes.setString(ATTR_CONNECTION_PORT, store.getString(ATTR_CONNECTION_PORT));
    }

    public TargetConfig createTargetConfig() throws CoreException {
        try {
            this.attributes.verifyInt(AttributeNames.CONNECTION_PORT, ATTR_CONNECTION_PORT);
            this.attributes.verifyInt(AttributeNames.CONNECTION_TIMEOUT, ATTR_CONNECTION_TIMEOUT);
            if (this.attributes.getBoolean(ATTR_LOCALHOST_SELECTION)) {
                this.attributes.setString(ATTR_CONNECTION_ADDRESS, "localhost");
            }
            return new TargetConfig(this.attributes);
        }
        catch (IllegalAttributeException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
    }
}

