/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.generic.core.rtsystem;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolResourceManager;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.generic.core.GenericRMCorePlugin;
import org.eclipse.ptp.rm.generic.core.messages.Messages;
import org.eclipse.ptp.rm.generic.core.rmsystem.EffectiveGenericRMConfiguration;
import org.eclipse.ptp.rm.generic.core.rmsystem.GenericResourceManager;
import org.eclipse.ptp.rm.generic.core.rtsystem.GenericRMRuntimeSystemJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRMRuntimeSystem
extends AbstractToolRuntimeSystem {
    private String fNodeID;

    public GenericRMRuntimeSystem(GenericResourceManager rm) {
        super((AbstractToolResourceManager)rm);
    }

    public Job createRuntimeSystemJob(String jobID, AttributeManager attrMgr) {
        return new GenericRMRuntimeSystemJob(jobID, Messages.GenericRMRuntimeSystem_JobName, this, attrMgr);
    }

    public List<IAttribute<?, ?, ?>> getAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        List attrs = super.getAttributes(configuration, mode);
        IPResourceManager rm = this.getPResourceManager();
        if (rm != null) {
            IPQueue[] queues = rm.getQueues();
            if (queues.length != 1) {
                throw new CoreException((IStatus)new Status(4, GenericRMCorePlugin.getUniqueIdentifier(), Messages.GenericRMRuntimeSystem_noDefaultQueue));
            }
            attrs.add(JobAttributes.getQueueIdAttributeDefinition().create(queues[0].getID()));
        }
        try {
            attrs.add(JobAttributes.getNumberOfProcessesAttributeDefinition().create(Integer.valueOf(1)));
        }
        catch (IllegalValueException illegalValueException) {}
        return attrs;
    }

    public AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration() {
        return new EffectiveGenericRMConfiguration(this.getRmConfiguration());
    }

    protected Job createContinuousMonitorJob() {
        return null;
    }

    protected Job createDiscoverJob() {
        return null;
    }

    protected Job createPeriodicMonitorJob() {
        return null;
    }

    protected void doFilterEvents(IPElement element, boolean filterChildren, AttributeManager filterAttributes) throws CoreException {
    }

    protected void doShutdown() throws CoreException {
    }

    protected void doStartEvents() throws CoreException {
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        String machineId = this.createMachine(this.connection.getName());
        this.fNodeID = this.createNode(machineId, this.connection.getAddress(), 0);
        this.createQueue(Messages.GenericRMRuntimeSystem_0);
    }

    protected void doStopEvents() throws CoreException {
    }

    protected String getNodeId() {
        return this.fNodeID;
    }
}

