/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml_jaxb.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.internal.core.model.Row;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.ptp.rm.lml_jaxb.actions.AbstractStatusAction;
import org.eclipse.ptp.rm.lml_jaxb.actions.ActionUtils;
import org.eclipse.ptp.rm.lml_jaxb.messages.Messages;
import org.eclipse.swt.widgets.Shell;

public class RemoveJob
extends AbstractStatusAction {
    public void run(IAction action) {
        if (MessageDialog.openQuestion((Shell)this.view.getSite().getShell(), (String)Messages.CannotUndoOperation, (String)Messages.RemoveJobWarning)) {
            ArrayList<JobStatusData> data = new ArrayList<JobStatusData>();
            for (Row row : this.selected) {
                JobStatusData status = row.status;
                data.add(status);
                String monitorId = MonitorControlManager.generateMonitorId((String)status.getRemoteId(), (String)status.getConnectionName(), (String)status.getMonitorType());
                LMLManager.getInstance().removeUserJob(monitorId, status.getJobId());
            }
            this.view.refresh();
            ActionUtils.removeFiles(data);
        }
    }

    protected void validate(IAction action) {
        for (Row row : this.selected) {
            JobStatusData status = row.status;
            if (status != null && status.getState().equals("COMPLETED")) continue;
            action.setEnabled(false);
            return;
        }
        action.setEnabled(true);
    }
}

