/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem;

import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.IOpenMPIResourceManagerConfiguration;

public class EffectiveOpenMPIResourceManagerConfiguration
extends AbstractEffectiveToolRMConfiguration {
    private static final String BINDIR = "bin";

    public EffectiveOpenMPIResourceManagerConfiguration(IToolRMConfiguration configuration) {
        super(configuration);
        IOpenMPIResourceManagerConfiguration conf = (IOpenMPIResourceManagerConfiguration)configuration;
        String launchCmd = null;
        String debugCmd = null;
        String discoverCmd = null;
        if (conf.getVersionId().equals("auto")) {
            String version = conf.getDetectedVersion();
            String prefix = "openmpi-auto-";
            if (version.equals("1.2")) {
                prefix = "openmpi-1.2-";
            } else if (version.equals("1.3")) {
                prefix = "openmpi-1.3-";
            } else if (version.equals("1.4")) {
                prefix = "openmpi-1.4-";
            }
            launchCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)(String.valueOf(prefix) + "launchCmd"));
            debugCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)(String.valueOf(prefix) + "debugCmd"));
            discoverCmd = Preferences.getString((String)OpenMPIPlugin.getUniqueIdentifier(), (String)(String.valueOf(prefix) + "discoverCmd"));
        } else {
            launchCmd = conf.getLaunchCmd();
            debugCmd = conf.getDebugCmd();
            discoverCmd = conf.getDiscoverCmd();
        }
        this.applyValues(launchCmd, debugCmd, discoverCmd, null, 0, null, conf.getRemoteInstallPath());
    }

    protected String completeCommand(String command) {
        String prefix = this.getConfiguration().getRemoteInstallPath();
        if (prefix == null || prefix.length() == 0) {
            return command;
        }
        return new Path(prefix).append(BINDIR).append(command.trim()).toString();
    }
}

