/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIHostMap;

public class OpenMPIHostMapParser {
    OpenMPIHostMap map = new OpenMPIHostMap();
    static Pattern pattern = Pattern.compile("\\s*(\\S+)((?:\\s+\\S+=\\d+)*)\\s*");
    static Pattern paramPattern = Pattern.compile("\\s*(\\S+)=(\\d+)");

    private OpenMPIHostMapParser() {
    }

    public static OpenMPIHostMap parse(BufferedReader reader) throws IOException {
        String line;
        OpenMPIHostMapParser parser = new OpenMPIHostMapParser();
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(35);
            if (index != -1) {
                line = line.substring(0, index);
            }
            if ((line = line.trim()).length() == 0) continue;
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) {
                parser.map.setHasParseErrors(true);
                DebugUtil.error((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Ignoring invalid line: '{0}'", (Object[])new Object[]{line});
                continue;
            }
            OpenMPIHostMap.Host host = new OpenMPIHostMap.Host(matcher.group(1));
            parser.map.addHost(host);
            host.setNumProcessors(0);
            host.setMaxNumProcessors(0);
            String parameters = matcher.group(2);
            matcher = paramPattern.matcher(parameters);
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                if (key.equalsIgnoreCase("slots") || key.equalsIgnoreCase("cpus") || key.equalsIgnoreCase("count")) {
                    try {
                        host.setNumProcessors(Integer.parseInt(value));
                        if (host.getNumProcessors() > 1) continue;
                        host.setNumProcessors(0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        host.addErrors(2);
                        host.setNumProcessors(1);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("max-slots")) {
                    try {
                        host.setMaxNumProcessors(Integer.parseInt(value));
                        if (host.getMaxNumProcessors() > 1) continue;
                        host.setMaxNumProcessors(0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        host.addErrors(4);
                        host.setMaxNumProcessors(0);
                    }
                    continue;
                }
                DebugUtil.error((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"Invalid attribute: '{0}'", (Object[])new Object[]{matcher.group()});
                host.addErrors(8);
            }
            if (host.getNumProcessors() == 0) {
                if (host.getMaxNumProcessors() == 0) {
                    host.setNumProcessors(1);
                } else {
                    host.setNumProcessors(host.getMaxNumProcessors());
                }
            } else if (host.getMaxNumProcessors() > 0 && host.getNumProcessors() > host.getMaxNumProcessors()) {
                host.addErrors(4);
                host.setNumProcessors(host.getMaxNumProcessors());
            }
            DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)"  {0} slots={1} max-slots={2}", (Object[])new Object[]{host.getName(), host.getNumProcessors(), host.getMaxNumProcessors()});
        }
        return parser.map;
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile("\\s*(\\S+)(?:\\s+(\\S+)\\s*=\\s*(\\d+))*");
        Matcher m = pattern.matcher("e slots=3 max-slots=4 r=5");
        if (!m.matches()) {
            System.out.println("no");
            return;
        }
        int i = 1;
        while (i <= m.groupCount()) {
            System.out.println(m.group(i));
            ++i;
        }
    }
}

