/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.Map;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.rdt.sync.core.IMissingConnectionHandler;
import org.eclipse.ptp.rdt.sync.core.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;

public class BuildScenario {
    private static final String ATTR_SYNC_PROVIDER = "sync-provider";
    private static final String ATTR_REMOTE_CONNECTION_ID = "remote-connection-id";
    private static final String ATTR_LOCATION = "location";
    private static final String ATTR_REMOTE_SERVICES_ID = "remote-services-id";
    final String syncProvider;
    final String remoteConnection;
    final IRemoteServices remoteServices;
    final String location;

    public BuildScenario(String sp, IRemoteConnection rc, String l) {
        this.syncProvider = sp;
        this.remoteConnection = rc.getName();
        this.remoteServices = rc.getRemoteServices();
        this.location = l;
    }

    public BuildScenario(String sp, String rc, String rs, String l) {
        this.syncProvider = sp;
        this.remoteConnection = rc;
        this.remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(rs);
        if (this.remoteServices == null) {
            throw new IllegalArgumentException(String.valueOf(Messages.BuildScenario_0) + rs);
        }
        this.location = l;
    }

    public String getSyncProvider() {
        return this.syncProvider;
    }

    public IRemoteConnection getRemoteConnection() throws MissingConnectionException {
        IMissingConnectionHandler mcHandler;
        IRemoteConnection conn = this.remoteServices.getConnectionManager().getConnection(this.remoteConnection);
        if (conn == null && (mcHandler = SyncManager.getDefaultMissingConnectionHandler()) != null) {
            mcHandler.handle(this.remoteServices, this.remoteConnection);
            conn = this.remoteServices.getConnectionManager().getConnection(this.remoteConnection);
        }
        if (conn == null) {
            throw new MissingConnectionException(this.remoteConnection);
        }
        return conn;
    }

    public IRemoteServices getRemoteProvider() {
        return this.remoteServices;
    }

    public String getLocation(IProject project) {
        return BuildScenario.resolveString(project, this.location);
    }

    public static String resolveString(IProject project, String path) {
        if (!path.startsWith("${") || !path.endsWith("}")) {
            return path;
        }
        String newPath = path.substring(2, path.length() - 1);
        String variable = newPath.split(":")[0];
        IPathVariableManager pvm = project.getPathVariableManager();
        String value = pvm.getURIValue(variable.toUpperCase()).toString();
        if (value == null) {
            return path;
        }
        if ((value = value.replaceFirst("file:", "")).endsWith("/") || value.endsWith("\\")) {
            value = value.substring(0, path.length() - 1);
        }
        return newPath.replaceFirst(String.valueOf(variable) + ":*", value);
    }

    public void saveScenario(Map<String, String> map) {
        if (this.syncProvider != null) {
            map.put(ATTR_SYNC_PROVIDER, this.syncProvider);
        }
        map.put(ATTR_REMOTE_CONNECTION_ID, this.remoteConnection);
        map.put(ATTR_LOCATION, this.location);
        map.put(ATTR_REMOTE_SERVICES_ID, this.remoteServices.getId());
    }

    public static BuildScenario loadScenario(Map<String, String> map) {
        String sp = map.get(ATTR_SYNC_PROVIDER);
        String rc = map.get(ATTR_REMOTE_CONNECTION_ID);
        String rs = map.get(ATTR_REMOTE_SERVICES_ID);
        String l = map.get(ATTR_LOCATION);
        if (rc == null || l == null || rs == null) {
            return null;
        }
        return new BuildScenario(sp, rc, rs, l);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.remoteConnection == null ? 0 : this.remoteConnection.hashCode());
        result = 31 * result + (this.remoteServices == null ? 0 : this.remoteServices.hashCode());
        result = 31 * result + (this.syncProvider == null ? 0 : this.syncProvider.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildScenario other = (BuildScenario)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.remoteConnection == null ? other.remoteConnection != null : !this.remoteConnection.equals(other.remoteConnection)) {
            return false;
        }
        if (this.remoteServices == null ? other.remoteServices != null : !this.remoteServices.equals(other.remoteServices)) {
            return false;
        }
        return !(this.syncProvider == null ? other.syncProvider != null : !this.syncProvider.equals(other.syncProvider));
    }
}

