/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.launch;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.osgi.framework.Bundle;

public class OpenMPILaunchConfigurationDefaults {
    public static int ATTR_NUMPROCS;
    public static boolean ATTR_BYNODE;
    public static boolean ATTR_BYSLOT;
    public static boolean ATTR_NOOVERSUBSCRIBE;
    public static boolean ATTR_NOLOCAL;
    public static String ATTR_PREFIX;
    public static boolean ATTR_USEPREFIX;
    public static String ATTR_HOSTFILE;
    public static boolean ATTR_USEHOSTFILE;
    public static String ATTR_HOSTLIST;
    public static boolean ATTR_USEHOSTLIST;
    public static String ATTR_ARGUMENTS;
    public static boolean ATTR_USEDEFAULTARGUMENTS;
    public static HashMap<String, String> ATTR_PARAMETERS;
    public static boolean ATTR_USEDEFAULTPARAMETERS;
    private static String defaultsResourcePath;

    static {
        ATTR_PARAMETERS = new HashMap();
        defaultsResourcePath = "/data/launch-defaults.properties";
    }

    public static void loadDefaults() throws CoreException {
        Path defaultsPropertiesPath = new Path(defaultsResourcePath);
        Bundle bundle = OpenMPIPlugin.getDefault().getBundle();
        Properties properties = OpenMPILaunchConfigurationDefaults.read(defaultsPropertiesPath, bundle);
        ATTR_NUMPROCS = OpenMPILaunchConfigurationDefaults.getInteger(bundle, properties, "NUMPROCS");
        ATTR_BYNODE = OpenMPILaunchConfigurationDefaults.getBoolean(bundle, properties, "BYNODE");
        ATTR_BYSLOT = OpenMPILaunchConfigurationDefaults.getBoolean(bundle, properties, "BYSLOT");
        ATTR_NOOVERSUBSCRIBE = OpenMPILaunchConfigurationDefaults.getBoolean(bundle, properties, "NOOVERSUBSCRIBE");
        ATTR_NOLOCAL = OpenMPILaunchConfigurationDefaults.getBoolean(bundle, properties, "NOLOCAL");
        ATTR_PREFIX = OpenMPILaunchConfigurationDefaults.getString(bundle, properties, "PREFIX");
        ATTR_USEPREFIX = OpenMPILaunchConfigurationDefaults.getBoolean(bundle, properties, "USEPREFIX");
        ATTR_HOSTFILE = OpenMPILaunchConfigurationDefaults.getString(bundle, properties, "HOSTFILE");
        ATTR_USEHOSTFILE = OpenMPILaunchConfigurationDefaults.getBoolean(bundle, properties, "USEHOSTFILE");
        ATTR_ARGUMENTS = OpenMPILaunchConfigurationDefaults.getString(bundle, properties, "ARGUMENTS");
        ATTR_USEDEFAULTARGUMENTS = OpenMPILaunchConfigurationDefaults.getBoolean(bundle, properties, "USEDEFAULTARGUMENTS");
        ATTR_USEDEFAULTPARAMETERS = OpenMPILaunchConfigurationDefaults.getBoolean(bundle, properties, "USEDEFAULTPARAMETERS");
        assert (ATTR_PREFIX != null);
        assert (ATTR_HOSTFILE != null);
        assert (ATTR_ARGUMENTS != null);
    }

    public static Properties read(Path defaultsPropertiesPath, Bundle bundle) throws CoreException {
        Properties properties = new Properties();
        try {
            InputStream inStream = FileLocator.openStream((Bundle)bundle, (IPath)defaultsPropertiesPath, (boolean)false);
            properties.load(inStream);
        }
        catch (IOException e) {
            throw OpenMPIPlugin.coreErrorException(Messages.OpenMPILaunchConfigurationDefaults_Exception_FailedReadFile, e);
        }
        return properties;
    }

    public static String getString(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)Messages.OpenMPILaunchConfigurationDefaults_MissingValue, (Object)key)));
        }
        return value;
    }

    public static int getInteger(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = OpenMPILaunchConfigurationDefaults.getString(bundle, properties, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)Messages.OpenMPILaunchConfigurationDefaults_FailedParseInteger, (Object)key)));
        }
    }

    public static boolean getBoolean(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = OpenMPILaunchConfigurationDefaults.getString(bundle, properties, key);
        return Boolean.parseBoolean(value);
    }
}

