/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolResourceManager;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPILaunchAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIMachineAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.launch.OpenMPILaunchConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.launch.OpenMPILaunchConfigurationDefaults;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.parameters.OmpiInfo;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.EffectiveOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.OpenMPIResourceManager;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.OpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIDiscoverJob;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIRuntimeSystemJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPIRuntimeSystem
extends AbstractToolRuntimeSystem {
    private final OmpiInfo info = new OmpiInfo();
    private String machineID;
    private String queueID;
    private final Map<String, String> nodeToIDMap = new HashMap<String, String>();

    public OpenMPIRuntimeSystem(OpenMPIResourceManager rm) {
        super((AbstractToolResourceManager)rm);
    }

    public Job createRuntimeSystemJob(String jobID, AttributeManager attrMgr) {
        return new OpenMPIRuntimeSystemJob(jobID, Messages.OpenMPIRuntimeSystem_JobName, this, attrMgr);
    }

    public List<IAttribute<?, ?, ?>> getAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        List attrs = super.getAttributes(configuration, mode);
        IPResourceManager rm = this.getPResourceManager();
        if (rm != null) {
            IPQueue[] queues = rm.getQueues();
            if (queues.length != 1) {
                throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), Messages.OpenMPIRuntimeSystem_NoDefaultQueue));
            }
            attrs.add(JobAttributes.getQueueIdAttributeDefinition().create(queues[0].getID()));
        }
        int numProcs = configuration.getAttribute(OpenMPILaunchConfiguration.ATTR_NUMPROCS, OpenMPILaunchConfigurationDefaults.ATTR_NUMPROCS);
        try {
            attrs.add(JobAttributes.getNumberOfProcessesAttributeDefinition().create(Integer.valueOf(numProcs)));
        }
        catch (IllegalValueException e) {
            throw new CoreException((IStatus)new Status(4, OpenMPIPlugin.getUniqueIdentifier(), Messages.OpenMPIRuntimeSystem_InvalidConfiguration, (Throwable)e));
        }
        attrs.add(OpenMPILaunchAttributes.getLaunchArgumentsAttributeDefinition().create(OpenMPILaunchConfiguration.calculateArguments(configuration)));
        return attrs;
    }

    public String getMachineID() {
        return this.machineID;
    }

    public String getNodeIDforName(String hostname) {
        return this.nodeToIDMap.get(hostname);
    }

    public OmpiInfo getOmpiInfo() {
        return this.info;
    }

    public String getQueueID() {
        return this.queueID;
    }

    public AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration() {
        return new EffectiveOpenMPIResourceManagerConfiguration(this.getRmConfiguration());
    }

    public void setNodeIDForName(String name, String id) {
        this.nodeToIDMap.put(name, id);
    }

    private OpenMPIResourceManagerConfiguration getConfiguration() {
        return (OpenMPIResourceManagerConfiguration)this.getResourceManager().getConfiguration();
    }

    protected Job createContinuousMonitorJob() {
        return null;
    }

    protected Job createDiscoverJob() {
        if (!this.getConfiguration().hasDiscoverCmd()) {
            return null;
        }
        OpenMPIDiscoverJob job = new OpenMPIDiscoverJob(this);
        job.setPriority(10);
        job.setSystem(false);
        job.setUser(false);
        return job;
    }

    protected Job createPeriodicMonitorJob() {
        return null;
    }

    protected void doFilterEvents(IPElement element, boolean filterChildren, AttributeManager filterAttributes) throws CoreException {
    }

    protected void doShutdown() throws CoreException {
    }

    protected void doStartEvents() throws CoreException {
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        this.machineID = this.createMachine(this.connection.getName());
        this.queueID = this.createQueue(Messages.OpenMPIDiscoverJob_defaultQueueName);
    }

    protected void doStopEvents() throws CoreException {
    }

    protected void notifyMonitorFailed(AbstractRemoteCommandJob job, Exception exception) {
        AttributeManager attrManager = new AttributeManager();
        attrManager.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.ERROR));
        attrManager.addAttribute((IAttribute)OpenMPIMachineAttributes.getStatusMessageAttributeDefinition().create(NLS.bind((String)Messages.OpenMPIDiscoverJob_Exception_DiscoverCommandInternalError, (Object)exception.getMessage())));
        this.changeMachine(this.machineID, attrManager);
        IPResourceManager rm = this.getPResourceManager();
        if (rm != null) {
            rm.addAttribute((IAttribute)ResourceManagerAttributes.getStateAttributeDefinition().create((Enum)ResourceManagerAttributes.State.ERROR));
        }
    }
}

