/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.types.Dimension;
import org.eclipse.photran.internal.core.parser.ASTArraySpecNode;
import org.eclipse.photran.internal.core.parser.ASTAssumedShapeSpecListNode;
import org.eclipse.photran.internal.core.parser.ASTAssumedSizeSpecNode;
import org.eclipse.photran.internal.core.parser.ASTDeferredShapeSpecListNode;
import org.eclipse.photran.internal.core.parser.ASTExplicitShapeSpecNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.vpg.IPhotranSerializable;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;

public class ArraySpec
implements IPhotranSerializable {
    private static final long serialVersionUID = 1L;
    protected List<Dimension> dimensions = new LinkedList<Dimension>();
    protected boolean assumedOrDeferredShape = false;

    public ArraySpec(ASTArraySpecNode spec) {
        if (spec.getExplicitShapeSpecList() != null) {
            this.parseExplicitShapeArray(spec.getExplicitShapeSpecList());
        } else if (spec.getAssumedSizeSpec() != null) {
            this.parseAssumedSizeArray(spec.getAssumedSizeSpec());
        } else if (spec.getAssumedShapeSpecList() != null) {
            this.parseAssumedShapeArray(spec.getAssumedShapeSpecList());
        } else if (spec.getDeferredShapeSpecList() != null) {
            this.parseDeferredShapeArray(spec.getDeferredShapeSpecList());
        } else {
            throw new Error("Unexpected entity in <ArraySpec>");
        }
    }

    private void parseExplicitShapeArray(IASTListNode<ASTExplicitShapeSpecNode> node) {
        int i = 0;
        while (i < node.size()) {
            this.dimensions.add(new Dimension((ASTExplicitShapeSpecNode)node.get(i)));
            ++i;
        }
    }

    private void parseAssumedSizeArray(ASTAssumedSizeSpecNode assumedSizeSpec) {
        this.assumedOrDeferredShape = true;
    }

    private void parseAssumedShapeArray(IASTListNode<ASTAssumedShapeSpecListNode> assumedShapeSpecList) {
        this.assumedOrDeferredShape = true;
    }

    private void parseDeferredShapeArray(IASTListNode<ASTDeferredShapeSpecListNode> deferredShapeSpecList) {
        this.assumedOrDeferredShape = true;
    }

    public boolean hasFixedConstantDimensions() {
        if (this.assumedOrDeferredShape) {
            return false;
        }
        for (Dimension d : this.dimensions) {
            if (d.hasConstantBounds()) continue;
            return false;
        }
        return true;
    }

    public Iterable<Dimension> getDimensions() {
        return this.dimensions;
    }

    public int getRank() {
        return this.dimensions.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        while (i < this.dimensions.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.dimensions.get(i).toString());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArraySpec)) {
            return false;
        }
        ArraySpec o = (ArraySpec)other;
        return this.dimensions.equals(o.dimensions) && this.assumedOrDeferredShape == o.assumedOrDeferredShape;
    }

    public int hashCode() {
        return this.dimensions.hashCode() + (this.assumedOrDeferredShape ? 1 : 0);
    }

    private ArraySpec(List<Dimension> dimensions, boolean assumedOrDeferredShape) {
        this.dimensions = dimensions;
        this.assumedOrDeferredShape = assumedOrDeferredShape;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.dimensions.size(), out);
        for (Dimension dim : this.dimensions) {
            PhotranVPGSerializer.serialize(dim, out);
        }
        PhotranVPGSerializer.serialize(this.assumedOrDeferredShape, out);
    }

    public static ArraySpec readFrom(InputStream in) throws IOException {
        int numDimensions = (Integer)PhotranVPGSerializer.deserialize(in);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(numDimensions);
        int i = 0;
        while (i < numDimensions) {
            dimensions.add((Dimension)PhotranVPGSerializer.deserialize(in));
            ++i;
        }
        boolean assumedOrDeferredShape = (Boolean)PhotranVPGSerializer.deserialize(in);
        return new ArraySpec(dimensions, assumedOrDeferredShape);
    }

    @Override
    public char getSerializationCode() {
        return 'A';
    }
}

