/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTImplicitStmtNode;
import org.eclipse.photran.internal.core.parser.ASTObjectNameNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class TransformToDerivedDataTypeRefactoring
extends FortranEditorRefactoring {
    private static final String OPS = "ops";
    private LinkedList<IBodyConstruct> statements_nodes = new LinkedList();
    private LinkedList<PhotranTokenRef> references = new LinkedList();
    private String derivedTypeVariableName;
    private String derivedTypeName;

    public String getName() {
        return "Transform To Derived Data Type";
    }

    public void setDerivedTypeName(String name) {
        assert (name != null);
        this.derivedTypeName = name;
    }

    public void setDerivedTypeVariableName(String name) {
        assert (name != null);
        this.derivedTypeVariableName = name;
    }

    private String findStatements(String s) {
        String[] attributes_not_allowed = new String[]{"parameter", "intent", "target", "optional", "save", "external", "intrinsic"};
        String[] types_allowed = new String[]{"integer", "real", "complex", "character", "logical"};
        String statement_line = new String();
        boolean has_type_in_line = false;
        boolean init = false;
        int j = 0;
        if (s.length() == 0) {
            return OPS;
        }
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ' ' || s.charAt(i) == '\t' && !init) {
                ++j;
            } else {
                init = true;
                break;
            }
            ++i;
        }
        if (s.charAt(j) == '!') {
            return OPS;
        }
        statement_line = s.substring(j);
        String[] stringArray = types_allowed;
        int n = types_allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (statement_line.toLowerCase().contains(type)) {
                has_type_in_line = true;
            }
            ++n2;
        }
        stringArray = attributes_not_allowed;
        n = attributes_not_allowed.length;
        n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (statement_line.toLowerCase().contains(attribute)) {
                has_type_in_line = false;
            }
            ++n2;
        }
        if (has_type_in_line) {
            return statement_line;
        }
        return OPS;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        String selected_text;
        this.ensureProjectHasRefactoringEnabled(status);
        IASTNode derived_type_node = TransformToDerivedDataTypeRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        ScopingNode derived_type_scope = ScopingNode.getEnclosingScope(derived_type_node);
        if (derived_type_scope instanceof ASTDerivedTypeDefNode) {
            this.fail("You can not use this refactoring within a Derived Data Type that already exists.");
        }
        if ((selected_text = this.selectedRegionInEditor.getText()).isEmpty()) {
            this.fail("Please select a variable declaration (or a list of variable declarations).");
        } else {
            String[] selected_lines;
            String[] stringArray = selected_lines = selected_text.split("\n");
            int n = selected_lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!(s = this.findStatements(s)).equalsIgnoreCase(OPS)) {
                    this.statements_nodes.add(TransformToDerivedDataTypeRefactoring.parseLiteralStatement(s));
                }
                ++n2;
            }
            LinkedList<IBodyConstruct> nodes_to_remove = new LinkedList<IBodyConstruct>();
            for (IBodyConstruct node : this.statements_nodes) {
                if (node instanceof ASTTypeDeclarationStmtNode) continue;
                nodes_to_remove.add(node);
            }
            this.statements_nodes.removeAll(nodes_to_remove);
        }
        if (this.statements_nodes.isEmpty()) {
            this.fail("Please select a variable declaration (or a list of variable declarations).");
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        Character[] numeric_digits = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
        if (this.derivedTypeName.length() < 1 || this.derivedTypeVariableName.length() < 1) {
            this.fail("Fill in the fields with valid values.");
        }
        int i = 0;
        while (i < this.derivedTypeName.length()) {
            if (this.derivedTypeName.charAt(i) == ' ' || this.derivedTypeName.charAt(i) == '!' || this.derivedTypeName.charAt(i) == '\t') {
                this.fail("The name of the Derived Data Type can not contain spaces and exclamation points.");
            }
            ++i;
        }
        i = 0;
        while (i < this.derivedTypeVariableName.length()) {
            if (this.derivedTypeVariableName.charAt(i) == ' ' || this.derivedTypeVariableName.charAt(i) == '!' || this.derivedTypeVariableName.charAt(i) == '\t') {
                this.fail("The name of the new variable can not contain spaces and exclamation points.");
            }
            ++i;
        }
        i = 0;
        while (i < numeric_digits.length) {
            if (this.derivedTypeName.charAt(0) == numeric_digits[i].charValue() || this.derivedTypeVariableName.charAt(0) == numeric_digits[i].charValue()) {
                this.fail("The names created can not start with numeric digits.");
            }
            ++i;
        }
    }

    protected void doCreateChange(IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        LinkedList<Character> blank_characters = new LinkedList<Character>();
        IASTNode node = TransformToDerivedDataTypeRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        this.astOfFileInEditor.getRoot();
        ScopingNode scope = ASTExecutableProgramNode.getEnclosingScope(node);
        Token tokenToInsertDerivedDataType = scope.getHeaderStmt().findLastToken();
        IASTListNode<? extends IASTNode> scopebody = scope.getBody();
        for (IASTNode iASTNode : scopebody) {
            if (!(iASTNode instanceof ASTImplicitStmtNode)) continue;
            ASTImplicitStmtNode implicitnode = (ASTImplicitStmtNode)iASTNode;
            tokenToInsertDerivedDataType = implicitnode.findLastToken();
            break;
        }
        String tokenText = tokenToInsertDerivedDataType.getText();
        String string = "";
        String headerStmt = scope.getHeaderStmt().toString();
        String[] headerStmtWithoutComments = headerStmt.split("\n");
        headerStmt = headerStmtWithoutComments[headerStmtWithoutComments.length - 1];
        String string3 = this.getBlankCharacters(blank_characters, string, headerStmt);
        string3 = String.valueOf(string3) + "\t";
        String new_derived_type = new String();
        new_derived_type = String.valueOf(string3) + "TYPE " + this.derivedTypeName + "\n";
        for (IBodyConstruct s : this.statements_nodes) {
            new_derived_type = String.valueOf(new_derived_type) + string3 + "\t" + ((ASTTypeDeclarationStmtNode)s).toString();
        }
        new_derived_type = String.valueOf(new_derived_type) + string3 + "END TYPE " + this.derivedTypeName;
        new_derived_type = String.valueOf(new_derived_type) + "\n\n" + string3 + "TYPE(" + this.derivedTypeName + ") :: " + this.derivedTypeVariableName + "\n";
        tokenToInsertDerivedDataType.setText(String.valueOf(tokenText.trim()) + "\n" + new_derived_type + "\n");
        this.findReferences(scope);
        if (this.statements_nodes.size() > 0) {
            this.addChangeFromModifiedAST(this.fileInEditor, progressMonitor);
        }
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    void findReferences(ScopingNode scope) {
        LinkedList<Definition> used_definitions = new LinkedList<Definition>();
        List<Definition> all_definitions = scope.getAllDefinitions();
        LinkedList<String> node_names = new LinkedList<String>();
        for (IBodyConstruct iBodyConstruct : this.statements_nodes) {
            IASTListNode<ASTEntityDeclNode> statements = ((ASTTypeDeclarationStmtNode)iBodyConstruct).getEntityDeclList();
            for (ASTEntityDeclNode aSTEntityDeclNode : statements) {
                node_names.add(aSTEntityDeclNode.getObjectName().toString().trim());
            }
        }
        for (Definition definition : all_definitions) {
            for (String n : node_names) {
                if (!definition.getDeclaredName().toString().trim().equals(n)) continue;
                used_definitions.add(definition);
            }
        }
        for (Definition definition : used_definitions) {
            Set<PhotranTokenRef> references_to_definition = definition.findAllReferences(false);
            for (PhotranTokenRef photranTokenRef : references_to_definition) {
                this.references.add(photranTokenRef);
            }
        }
        for (PhotranTokenRef photranTokenRef : this.references) {
            photranTokenRef.findToken().setText(String.valueOf(this.derivedTypeVariableName) + "%" + photranTokenRef.findToken().getText());
        }
        for (Definition definition : used_definitions) {
            try {
                this.removeVariableDeclFor(definition);
            }
            catch (VPGRefactoring.PreconditionFailure e) {
                e.printStackTrace();
            }
        }
    }

    private void removeVariableDeclFor(Definition def) throws VPGRefactoring.PreconditionFailure {
        ASTTypeDeclarationStmtNode declarationNode = this.getTypeDeclarationStmtNode(def.getTokenRef().findToken().getParent());
        IASTListNode<ASTEntityDeclNode> entityDeclList = declarationNode.getEntityDeclList();
        if (entityDeclList.size() == 1) {
            declarationNode.findFirstToken().setWhiteBefore("");
            declarationNode.replaceWith("");
        } else {
            this.removeVariableDeclFromList(def, entityDeclList);
        }
    }

    private void removeVariableDeclFromList(Definition def, IASTListNode<ASTEntityDeclNode> entityDeclList) throws VPGRefactoring.PreconditionFailure {
        for (ASTEntityDeclNode decl : entityDeclList) {
            ASTObjectNameNode objectName = decl.getObjectName();
            String declName = objectName.getObjectName().getText();
            if (!declName.equals(def.getDeclaredName())) continue;
            if (entityDeclList.remove(decl)) break;
            this.fail("The operation could not be completed.");
            break;
        }
        entityDeclList.findFirstToken().setWhiteBefore(" ");
    }

    private ASTTypeDeclarationStmtNode getTypeDeclarationStmtNode(IASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ASTTypeDeclarationStmtNode) {
            return (ASTTypeDeclarationStmtNode)node;
        }
        return this.getTypeDeclarationStmtNode(node.getParent());
    }

    private String getBlankCharacters(List<Character> blank_characters, String tab, String headerStmt) {
        boolean start = false;
        int i = 0;
        while (i < headerStmt.length()) {
            char c = headerStmt.charAt(i);
            if (c != '\t' && c != ' ') {
                start = true;
            }
            if (!(c != '\t' && c != ' ' || start)) {
                blank_characters.add(Character.valueOf(headerStmt.charAt(i)));
            }
            ++i;
        }
        i = 0;
        while (i < blank_characters.size()) {
            tab = String.valueOf(tab) + blank_characters.get(i);
            ++i;
        }
        return tab;
    }
}

