/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierTable;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl.CallGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPICallGraph
extends CallGraph {
    protected List<Boolean> gvPointer_;
    protected BarrierTable btable_ = new BarrierTable();
    protected int count = 4;
    private static final boolean traceOn = false;

    public MPICallGraph() {
        this.gvPointer_ = new ArrayList<Boolean>();
    }

    public List<Boolean> getGVPointer() {
        return this.gvPointer_;
    }

    public BarrierTable getBarrierTable() {
        return this.btable_;
    }

    public void otherOP() {
        FunctionMarker fm = new FunctionMarker();
        fm.run();
        this.checkBarrierRelatedCycles();
    }

    protected void checkBarrierRelatedCycles() {
        for (List cycle : this.cycles_) {
            boolean barrierRelated = false;
            for (MPICallGraphNode node : cycle) {
                if (!node.barrierRelated) continue;
                barrierRelated = true;
                break;
            }
            if (!barrierRelated) continue;
            String errorMsg = new String("Barrier related recursive function calls on: ");
            for (ICallGraphNode func : cycle) {
                errorMsg = String.valueOf(errorMsg) + func.getFuncName() + "(" + func.getFileName() + "), ";
            }
            System.out.println(errorMsg);
        }
    }

    class FunctionMarker
    extends ASTVisitor {
        protected MPICallGraphNode currentNode_ = null;

        FunctionMarker() {
        }

        public void run() {
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            for (MPICallGraphNode this.currentNode_ : MPICallGraph.this.nodes_) {
                this.currentNode_.getFuncDef().accept((ASTVisitor)this);
            }
            for (MPICallGraphNode this.currentNode_ : MPICallGraph.this.nodes_) {
                this.markBarrierRelated(this.currentNode_);
            }
            for (MPICallGraphNode this.currentNode_ : MPICallGraph.this.nodes_) {
                this.markMPIInit(this.currentNode_);
            }
            this.markFunction();
            MPICallGraph.this.count -= 4;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcExpr = (IASTFunctionCallExpression)expression;
                IASTExpression funcname = funcExpr.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                if (signature.equals("MPI_Barrier")) {
                    ++MPICallGraph.this.count;
                    BarrierTable.BarrierInfo newbar = MPICallGraph.this.btable_.addBarrier(funcExpr, MPICallGraph.this.count, this.currentNode_.getResource(), this.currentNode_.getFuncName());
                    this.currentNode_.setBarrierRelated(true);
                    this.currentNode_.getAllBarriers().add(newbar);
                } else if (signature.equals("MPI_Init")) {
                    this.currentNode_.mpiInit = true;
                }
            }
            return 3;
        }

        protected void markBarrierRelated(MPICallGraphNode node) {
            if (node.barrierRelated()) {
                for (MPICallGraphNode caller : node.getCallers()) {
                    if (caller.barrierRelated()) continue;
                    caller.setBarrierRelated(true);
                    this.markBarrierRelated(caller);
                }
            }
        }

        protected void markMPIInit(MPICallGraphNode node) {
            if (node.mpiInit) {
                for (MPICallGraphNode caller : node.getCallers()) {
                    if (caller.mpiInit) continue;
                    caller.mpiInit = true;
                    this.markMPIInit(caller);
                }
            }
        }

        protected void markFunction() {
            int total = MPICallGraph.this.nodes_.size();
            ICallGraphNode node = MPICallGraph.this.topEntry_;
            while (node != null) {
                this.currentNode_ = (MPICallGraphNode)node;
                if (this.currentNode_.barrierRelated() || this.currentNode_.mpiInit) {
                    this.currentNode_.marked = true;
                }
                node = node.topNext();
            }
            boolean changed = true;
            while (changed) {
                changed = false;
                ICallGraphNode node2 = MPICallGraph.this.topEntry_;
                while (node2 != null) {
                    this.currentNode_ = (MPICallGraphNode)node2;
                    if (this.currentNode_.marked) {
                        for (MPICallGraphNode callee : this.currentNode_.getCallees()) {
                            if (callee.marked) continue;
                            callee.marked = true;
                            changed = true;
                        }
                    }
                    node2 = node2.topNext();
                }
            }
        }
    }

    class FunctionPointerChecker
    extends ASTVisitor {
        protected ICallGraphNode currentFunc_;
        protected boolean funcPointer = false;
        protected Stack<String> funcCall = new Stack();

        FunctionPointerChecker() {
        }

        public boolean hasFuncPointer() {
            return this.funcPointer;
        }

        public void run() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitStatements = true;
            this.shouldVisitExpressions = true;
            for (ICallGraphNode this.currentFunc_ : MPICallGraph.this.nodes_) {
                this.currentFunc_.getFuncDef().accept((ASTVisitor)this);
            }
        }

        public int visit(IASTExpression expr) {
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcE = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcE.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                this.funcCall.push(signature);
            } else if (expr instanceof IASTIdExpression) {
                IASTIdExpression idE = (IASTIdExpression)expr;
                String name = idE.getName().toString();
                if (!this.funcCall.empty() && name.equals(this.funcCall.peek())) {
                    this.funcCall.pop();
                } else {
                    ICallGraphNode node = MPICallGraph.this.getNode(this.currentFunc_.getFileName(), name);
                    if (node != null) {
                        this.funcPointer = true;
                        System.out.println("Function Pointer " + name + " in " + this.currentFunc_.getFuncName() + "(" + this.currentFunc_.getFileName() + ")");
                    }
                }
            }
            return 3;
        }
    }
}

