/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.ui.launch;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPILaunchAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.launch.OpenMPILaunchConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.launch.OpenMPILaunchConfigurationDefaults;
import org.eclipse.ptp.rm.mpi.openmpi.ui.OpenMPIUIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.launch.BaseRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabDataSource;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabWidgetListener;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.utils.ui.PixelConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicOpenMpiRMLaunchConfigurationDynamicTab
extends BaseRMLaunchConfigurationDynamicTab {
    protected Composite control;
    protected Spinner numProcsSpinner;
    protected Button byNodeButton;
    protected Button bySlotButton;
    protected Button noOversubscribeButton;
    protected Button noLocalButton;
    protected Button usePrefixButton;
    protected Text prefixText;
    protected Text hostFileText;
    protected Button hostFileButton;
    protected Text hostListText;
    protected Button hostListButton;
    protected Button browseButton;

    protected RMLaunchConfigurationDynamicTabDataSource createDataSource() {
        return new DataSource(this);
    }

    protected RMLaunchConfigurationDynamicTabWidgetListener createListener() {
        return new WidgetListener(this);
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Title;
    }

    public void createControl(Composite parent, String id) throws CoreException {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.control.setLayout((Layout)layout);
        Label label = new Label(this.control, 0);
        label.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Label_NumberProcesses);
        this.numProcsSpinner = new Spinner(this.control, 2048);
        this.numProcsSpinner.addModifyListener((ModifyListener)this.getListener());
        this.numProcsSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Group optionsGroup = new Group(this.control, 0);
        optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        optionsGroup.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Title_OptionsGroup);
        layout = new GridLayout();
        layout.numColumns = 4;
        optionsGroup.setLayout((Layout)layout);
        this.byNodeButton = new Button((Composite)optionsGroup, 32);
        this.byNodeButton.addSelectionListener((SelectionListener)this.getListener());
        this.byNodeButton.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Label_ByNode);
        this.bySlotButton = new Button((Composite)optionsGroup, 32);
        this.bySlotButton.addSelectionListener((SelectionListener)this.getListener());
        this.bySlotButton.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Label_BySlot);
        this.noOversubscribeButton = new Button((Composite)optionsGroup, 32);
        this.noOversubscribeButton.addSelectionListener((SelectionListener)this.getListener());
        this.noOversubscribeButton.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Label_NoOversubscribe);
        this.noLocalButton = new Button((Composite)optionsGroup, 32);
        this.noLocalButton.addSelectionListener((SelectionListener)this.getListener());
        this.noLocalButton.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Label_NoLocal);
        this.usePrefixButton = new Button((Composite)optionsGroup, 32);
        this.usePrefixButton.addSelectionListener((SelectionListener)this.getListener());
        this.usePrefixButton.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Label_Prefix);
        this.prefixText = new Text((Composite)optionsGroup, 2048);
        this.prefixText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.prefixText.addModifyListener((ModifyListener)this.getListener());
        Group hostGroup = new Group(this.control, 0);
        hostGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        hostGroup.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Title_HostGroup);
        layout = new GridLayout();
        layout.numColumns = 3;
        hostGroup.setLayout((Layout)layout);
        this.hostFileButton = new Button((Composite)hostGroup, 32);
        this.hostFileButton.addSelectionListener((SelectionListener)this.getListener());
        this.hostFileButton.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Label_HostFile);
        this.hostFileText = new Text((Composite)hostGroup, 2048);
        this.hostFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hostFileText.addModifyListener((ModifyListener)this.getListener());
        this.browseButton = new Button((Composite)hostGroup, 0);
        this.browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.browseButton.addSelectionListener((SelectionListener)this.getListener());
        PixelConverter pixelconverter = new PixelConverter((Control)this.control);
        GridData gd = new GridData(131072, 0x1000000, false, false);
        gd.widthHint = pixelconverter.convertHorizontalDLUsToPixels(61);
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Label_Browse);
        this.hostListButton = new Button((Composite)hostGroup, 32);
        this.hostListButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.hostListButton.addSelectionListener((SelectionListener)this.getListener());
        this.hostListButton.setText(Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Title_HostList);
        this.hostListText = new Text((Composite)hostGroup, 2560);
        gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = 20;
        this.hostListText.setLayoutData((Object)gd);
        this.hostListText.addModifyListener((ModifyListener)this.getListener());
    }

    public IAttribute<?, ?, ?>[] getAttributes(IResourceManager rm, ILaunchConfiguration configuration, String mode) throws CoreException {
        ArrayList<Object> attrs = new ArrayList<Object>();
        int numProcs = configuration.getAttribute(OpenMPILaunchConfiguration.ATTR_NUMPROCS, OpenMPILaunchConfigurationDefaults.ATTR_NUMPROCS);
        try {
            attrs.add(JobAttributes.getNumberOfProcessesAttributeDefinition().create(Integer.valueOf(numProcs)));
        }
        catch (IllegalValueException e) {
            throw new CoreException((IStatus)new Status(4, OpenMPIUIPlugin.getDefault().getBundle().getSymbolicName(), Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Exception_InvalidConfiguration, (Throwable)e));
        }
        attrs.add(OpenMPILaunchAttributes.getLaunchArgumentsAttributeDefinition().create(OpenMPILaunchConfiguration.calculateArguments((ILaunchConfiguration)configuration)));
        return attrs.toArray(new IAttribute[attrs.size()]);
    }

    public Control getControl() {
        return this.control;
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_NUMPROCS, OpenMPILaunchConfigurationDefaults.ATTR_NUMPROCS);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_BYNODE, OpenMPILaunchConfigurationDefaults.ATTR_BYNODE);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_BYSLOT, OpenMPILaunchConfigurationDefaults.ATTR_BYSLOT);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_NOOVERSUBSCRIBE, OpenMPILaunchConfigurationDefaults.ATTR_NOOVERSUBSCRIBE);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_NOLOCAL, OpenMPILaunchConfigurationDefaults.ATTR_NOLOCAL);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_USEPREFIX, OpenMPILaunchConfigurationDefaults.ATTR_USEPREFIX);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_PREFIX, OpenMPILaunchConfigurationDefaults.ATTR_PREFIX);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_USEHOSTFILE, OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTFILE);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_HOSTFILE, OpenMPILaunchConfigurationDefaults.ATTR_HOSTFILE);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_USEHOSTLIST, OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTLIST);
        configuration.setAttribute(OpenMPILaunchConfiguration.ATTR_HOSTLIST, OpenMPILaunchConfigurationDefaults.ATTR_HOSTLIST);
        return new RMLaunchValidation(true, null);
    }

    public void updateControls() {
        this.prefixText.setEnabled(this.usePrefixButton.getSelection());
        this.browseButton.setEnabled(this.hostFileButton.getSelection());
        this.hostFileText.setEnabled(this.hostFileButton.getSelection());
        this.hostListText.setEnabled(this.hostListButton.getSelection());
    }

    private class DataSource
    extends RMLaunchConfigurationDynamicTabDataSource {
        private int numProcs;
        private boolean byNode;
        private boolean bySlot;
        private boolean noOversubscribe;
        private boolean noLocal;
        private boolean usePrefix;
        private String prefix;
        private boolean useHostFile;
        private String hostFile;
        private boolean useHostList;
        private String hostList;

        protected DataSource(BaseRMLaunchConfigurationDynamicTab page) {
            super(page);
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            this.numProcs = BasicOpenMpiRMLaunchConfigurationDynamicTab.this.numProcsSpinner.getSelection();
            this.byNode = BasicOpenMpiRMLaunchConfigurationDynamicTab.this.byNodeButton.getSelection();
            this.bySlot = BasicOpenMpiRMLaunchConfigurationDynamicTab.this.bySlotButton.getSelection();
            this.noOversubscribe = BasicOpenMpiRMLaunchConfigurationDynamicTab.this.noOversubscribeButton.getSelection();
            this.noLocal = BasicOpenMpiRMLaunchConfigurationDynamicTab.this.noLocalButton.getSelection();
            this.usePrefix = BasicOpenMpiRMLaunchConfigurationDynamicTab.this.usePrefixButton.getSelection();
            this.prefix = this.extractText(BasicOpenMpiRMLaunchConfigurationDynamicTab.this.prefixText);
            this.useHostFile = BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostFileButton.getSelection();
            this.hostFile = this.extractText(BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostFileText);
            this.useHostList = BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostListButton.getSelection();
            this.hostList = this.extractText(BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostListText);
        }

        protected void copyToFields() {
            BasicOpenMpiRMLaunchConfigurationDynamicTab.this.numProcsSpinner.setSelection(this.numProcs);
            BasicOpenMpiRMLaunchConfigurationDynamicTab.this.byNodeButton.setSelection(this.byNode);
            BasicOpenMpiRMLaunchConfigurationDynamicTab.this.bySlotButton.setSelection(this.bySlot);
            BasicOpenMpiRMLaunchConfigurationDynamicTab.this.noOversubscribeButton.setSelection(this.noOversubscribe);
            BasicOpenMpiRMLaunchConfigurationDynamicTab.this.noLocalButton.setSelection(this.noLocal);
            BasicOpenMpiRMLaunchConfigurationDynamicTab.this.usePrefixButton.setSelection(this.usePrefix);
            this.applyText(BasicOpenMpiRMLaunchConfigurationDynamicTab.this.prefixText, this.prefix);
            this.applyText(BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostFileText, this.hostFile);
            BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostFileButton.setSelection(this.useHostFile);
            this.applyText(BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostListText, this.hostListToText(this.hostList));
            BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostListButton.setSelection(this.useHostList);
        }

        protected void copyToStorage() {
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_NUMPROCS, this.numProcs);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_BYNODE, this.byNode);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_BYSLOT, this.bySlot);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_NOOVERSUBSCRIBE, this.noOversubscribe);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_NOLOCAL, this.noLocal);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_USEPREFIX, this.usePrefix);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_PREFIX, this.prefix);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_USEHOSTFILE, this.useHostFile);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_HOSTFILE, this.hostFile);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_USEHOSTLIST, this.useHostList);
            this.getConfigurationWorkingCopy().setAttribute(OpenMPILaunchConfiguration.ATTR_HOSTLIST, this.hostList);
        }

        protected void loadDefault() {
            this.numProcs = OpenMPILaunchConfigurationDefaults.ATTR_NUMPROCS;
            this.byNode = OpenMPILaunchConfigurationDefaults.ATTR_BYNODE;
            this.bySlot = OpenMPILaunchConfigurationDefaults.ATTR_BYSLOT;
            this.noOversubscribe = OpenMPILaunchConfigurationDefaults.ATTR_NOOVERSUBSCRIBE;
            this.noLocal = OpenMPILaunchConfigurationDefaults.ATTR_NOLOCAL;
            this.usePrefix = OpenMPILaunchConfigurationDefaults.ATTR_USEPREFIX;
            this.prefix = OpenMPILaunchConfigurationDefaults.ATTR_PREFIX;
            this.hostFile = OpenMPILaunchConfigurationDefaults.ATTR_HOSTFILE;
            this.useHostFile = OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTFILE;
            this.hostList = OpenMPILaunchConfigurationDefaults.ATTR_HOSTLIST;
            this.useHostList = OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTLIST;
        }

        protected void loadFromStorage() {
            try {
                this.numProcs = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_NUMPROCS, OpenMPILaunchConfigurationDefaults.ATTR_NUMPROCS);
                this.byNode = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_BYNODE, OpenMPILaunchConfigurationDefaults.ATTR_BYNODE);
                this.bySlot = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_BYSLOT, OpenMPILaunchConfigurationDefaults.ATTR_BYSLOT);
                this.noOversubscribe = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_NOOVERSUBSCRIBE, OpenMPILaunchConfigurationDefaults.ATTR_NOOVERSUBSCRIBE);
                this.noLocal = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_NOLOCAL, OpenMPILaunchConfigurationDefaults.ATTR_NOLOCAL);
                this.usePrefix = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_USEPREFIX, OpenMPILaunchConfigurationDefaults.ATTR_USEPREFIX);
                this.prefix = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_PREFIX, OpenMPILaunchConfigurationDefaults.ATTR_PREFIX);
                this.hostFile = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_HOSTFILE, OpenMPILaunchConfigurationDefaults.ATTR_HOSTFILE);
                this.useHostFile = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_USEHOSTFILE, OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTFILE);
                this.hostList = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_HOSTLIST, OpenMPILaunchConfigurationDefaults.ATTR_HOSTLIST);
                this.useHostList = this.getConfiguration().getAttribute(OpenMPILaunchConfiguration.ATTR_USEHOSTLIST, OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTLIST);
            }
            catch (CoreException e) {
                OpenMPIUIPlugin.log(e);
            }
        }

        protected void validateLocal() throws DataSource.ValidationException {
            if (this.numProcs < 1) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Validation_NoProcess);
            }
            if (this.usePrefix && this.prefix == null) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Validation_EmptyPrefix);
            }
            if (this.useHostFile && this.hostFile == null) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Validation_EmptyHostfile);
            }
            if (this.useHostList && this.hostList == null) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.BasicOpenMpiRMLaunchConfigurationDynamicTab_Validation_EmptyHostList);
            }
        }

        private String hostListToText(String list) {
            if (list == null) {
                return "";
            }
            String result = "";
            String[] values = list.split(",");
            int i = 0;
            while (i < values.length) {
                if (!values[i].equals("")) {
                    if (i > 0) {
                        result = String.valueOf(result) + "\n";
                    }
                    result = String.valueOf(result) + values[i];
                }
                ++i;
            }
            return result;
        }
    }

    private class WidgetListener
    extends RMLaunchConfigurationDynamicTabWidgetListener {
        public WidgetListener(BaseRMLaunchConfigurationDynamicTab dynamicTab) {
            super(dynamicTab);
        }

        protected void doModifyText(ModifyEvent e) {
            if (e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.numProcsSpinner && e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.prefixText && e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostFileText && e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostListText) {
                super.doModifyText(e);
            }
        }

        protected void doWidgetSelected(SelectionEvent e) {
            if (e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.byNodeButton && e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.bySlotButton && e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.noOversubscribeButton && e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.noLocalButton && e.getSource() != BasicOpenMpiRMLaunchConfigurationDynamicTab.this.usePrefixButton) {
                if (e.getSource() == BasicOpenMpiRMLaunchConfigurationDynamicTab.this.usePrefixButton || e.getSource() == BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostFileButton || e.getSource() == BasicOpenMpiRMLaunchConfigurationDynamicTab.this.hostListButton) {
                    BasicOpenMpiRMLaunchConfigurationDynamicTab.this.updateControls();
                } else {
                    super.doWidgetSelected(e);
                }
            }
        }
    }
}

