/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPICH2JobMap {
    private final Map<String, List<Job>> jobsByID = new HashMap<String, List<Job>>();
    public boolean hasErrors = false;

    public void addJob(Job job) {
        List<Job> jobs = this.jobsByID.get(job.getJobID());
        if (jobs == null) {
            jobs = new ArrayList<Job>();
            this.jobsByID.put(job.getJobID(), jobs);
        }
        jobs.add(job);
    }

    public List<Job> getJob(String jobID) {
        return this.jobsByID.get(jobID);
    }

    public Collection<List<Job>> getJobs() {
        return this.jobsByID.values();
    }

    public class Job {
        private static final int JOBID = 1;
        private static final int JOBALIAS = 2;
        private static final int USERNAME = 4;
        private static final int HOST = 8;
        private static final int PID = 16;
        private static final int SID = 32;
        private static final int RANK = 64;
        private static final int PGM = 128;
        private String jobID = null;
        private String jobAlias = null;
        private String username = null;
        private String host = null;
        private int pid = 0;
        private int sid = 0;
        private int rank = 0;
        private String pgm = null;
        private int complete = 0;

        public String getHost() {
            return this.host;
        }

        public String getJobID() {
            return this.jobID;
        }

        public String getJobAlias() {
            return this.jobAlias;
        }

        public String getPgm() {
            return this.pgm;
        }

        public int getPid() {
            return this.pid;
        }

        public int getRank() {
            return this.rank;
        }

        public int getSid() {
            return this.sid;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isComplete() {
            return this.complete == 255;
        }

        public void setHost(String host) {
            this.host = host;
            this.complete |= 8;
        }

        public void setJobID(String jobID) {
            this.jobID = jobID;
            this.complete |= 1;
        }

        public void setJobAlias(String jobAlias) {
            this.jobAlias = jobAlias;
            this.complete |= 2;
        }

        public void setPgm(String pgm) {
            this.pgm = pgm;
            this.complete |= 0x80;
        }

        public void setPid(int pid) {
            this.pid = pid;
            this.complete |= 0x10;
        }

        public void setRank(int rank) {
            this.rank = rank;
            this.complete |= 0x40;
        }

        public void setSid(int sid) {
            this.sid = sid;
            this.complete |= 0x20;
        }

        public void setUsername(String username) {
            this.username = username;
            this.complete |= 4;
        }

        public String toString() {
            String str = "Job ";
            str = !this.isComplete() ? String.valueOf(str) + "(incomplete) [" : String.valueOf(str) + "]";
            if ((this.complete & 1) == 1) {
                str = String.valueOf(str) + " id: " + this.jobID;
            }
            if ((this.complete & 2) == 2) {
                str = String.valueOf(str) + " alias: " + this.jobAlias;
            }
            if ((this.complete & 4) == 4) {
                str = String.valueOf(str) + " username:" + this.username;
            }
            if ((this.complete & 8) == 8) {
                str = String.valueOf(str) + " host:" + this.host;
            }
            if ((this.complete & 0x10) == 16) {
                str = String.valueOf(str) + " pid:" + this.pid;
            }
            if ((this.complete & 0x20) == 32) {
                str = String.valueOf(str) + " sid:" + this.sid;
            }
            if ((this.complete & 0x40) == 64) {
                str = String.valueOf(str) + " rank:" + this.rank;
            }
            if ((this.complete & 0x80) == 128) {
                str = String.valueOf(str) + " pgm:" + this.pgm;
            }
            return String.valueOf(str) + "]";
        }
    }
}

