/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIThreadManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.request.IPDIGetInfoThreadsRequest;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public class ThreadManager
extends AbstractPDIManager
implements IPDIThreadManager {
    private static final IPDIThread[] noThreads = new IPDIThread[0];
    private Map<TaskSet, IPDIThread[]> threadMap = new Hashtable<TaskSet, IPDIThread[]>();

    public ThreadManager(IPDISession session) {
        super(session, true);
    }

    public IPDIThread[] getThreads(TaskSet qTasks) throws PDIException {
        IPDIThread[] threads = this.threadMap.get(qTasks);
        if (threads == null) {
            threads = this.getPThreads(qTasks);
            this.threadMap.put(qTasks, threads);
        }
        return threads;
    }

    public void shutdown() {
        this.threadMap.clear();
    }

    public void update(TaskSet qTasks) throws PDIException {
    }

    private IPDIThread[] getPThreads(TaskSet qTasks) throws PDIException {
        IPDIThread[] pthreads = noThreads;
        int currentThreadId = 0;
        IPDITarget target = this.session.findTarget(qTasks);
        IPDIGetInfoThreadsRequest request = this.session.getRequestFactory().getGetInfoThreadsRequest(qTasks);
        this.session.getEventRequestManager().addEventRequest(request);
        String[] ids = request.getThreadIds(qTasks);
        if (ids.length > 0) {
            pthreads = new IPDIThread[ids.length];
            int i = 0;
            while (i < ids.length) {
                pthreads[i] = this.session.getModelFactory().newThread(this.session, target, Integer.parseInt(ids[i]));
                ++i;
            }
        } else {
            pthreads = new IPDIThread[]{this.session.getModelFactory().newThread(this.session, target, 0)};
        }
        currentThreadId = pthreads[0].getId();
        if (currentThreadId == 0 && pthreads.length > 1) {
            currentThreadId = pthreads[1].getId();
        }
        return pthreads;
    }
}

