/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;

public class CPPUnknownClassInstance
extends CPPUnknownClass
implements ICPPUnknownClassInstance {
    private final ICPPTemplateArgument[] arguments;

    public CPPUnknownClassInstance(ICPPUnknownBinding scopeBinding, char[] name, ICPPTemplateArgument[] arguments) {
        super(scopeBinding, name);
        this.arguments = arguments;
    }

    @Override
    public ICPPTemplateArgument[] getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " " + ASTTypeUtil.getArgumentListString(this.arguments, true);
    }

    @Override
    public boolean isSameType(IType type) {
        if (this == type) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof ICPPUnknownClassInstance) {
            ICPPUnknownClassInstance rhs = (ICPPUnknownClassInstance)type;
            if (CharArrayUtils.equals(this.getNameCharArray(), rhs.getNameCharArray())) {
                ICPPTemplateArgument[] rhsArgs;
                ICPPTemplateArgument[] lhsArgs = this.getArguments();
                if (lhsArgs != (rhsArgs = rhs.getArguments())) {
                    if (lhsArgs == null || rhsArgs == null) {
                        return false;
                    }
                    if (lhsArgs.length != rhsArgs.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < lhsArgs.length) {
                        if (!lhsArgs[i].isSameValue(rhsArgs[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                IBinding lhsContainer = this.getOwner();
                IBinding rhsContainer = rhs.getOwner();
                if (lhsContainer instanceof IType && rhsContainer instanceof IType) {
                    return ((IType)((Object)lhsContainer)).isSameType((IType)((Object)rhsContainer));
                }
            }
        }
        return false;
    }
}

