/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.ArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;

public class Cost {
    public static final Cost NO_CONVERSION = new Cost(null, null, Rank.NO_MATCH){

        @Override
        public void setRank(Rank rank) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void setReferenceBinding(ReferenceBinding binding) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void setAmbiguousUDC(boolean val) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void setDeferredUDC(DeferredUDC val) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void setInheritanceDistance(int inheritanceDistance) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void setQualificationAdjustment(int adjustment) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void setUserDefinedConversion(ICPPMethod conv) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void setCouldNarrow() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void setSelectedFunction(ICPPFunction function) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    };
    IType source;
    IType target;
    private Rank fRank;
    private Rank fSecondStandardConversionRank;
    private boolean fAmbiguousUDC;
    private DeferredUDC fDeferredUDC = DeferredUDC.NONE;
    private int fQualificationAdjustments;
    private int fInheritanceDistance;
    private boolean fImpliedObject;
    private ICPPFunction fUserDefinedConversion;
    private ReferenceBinding fReferenceBinding;
    private boolean fCouldNarrow;
    private ICPPFunction fSelectedFunction;

    public Cost(IType s, IType t, Rank rank) {
        this.source = s;
        this.target = t;
        this.fRank = rank;
        this.fReferenceBinding = ReferenceBinding.NO_REF;
    }

    public final Rank getRank() {
        return this.fRank;
    }

    public final boolean converts() {
        return this.fRank != Rank.NO_MATCH;
    }

    public void setRank(Rank rank) {
        this.fRank = rank;
    }

    public ReferenceBinding getReferenceBinding() {
        return this.fReferenceBinding;
    }

    public void setReferenceBinding(ReferenceBinding binding) {
        this.fReferenceBinding = binding;
    }

    public boolean isAmbiguousUDC() {
        return this.fAmbiguousUDC;
    }

    public void setAmbiguousUDC(boolean val) {
        this.fAmbiguousUDC = val;
    }

    public DeferredUDC isDeferredUDC() {
        return this.fDeferredUDC;
    }

    public void setDeferredUDC(DeferredUDC udc) {
        this.fDeferredUDC = udc;
    }

    public int getInheritanceDistance() {
        return this.fInheritanceDistance;
    }

    public void setInheritanceDistance(int inheritanceDistance) {
        this.fInheritanceDistance = inheritanceDistance;
    }

    public void setQualificationAdjustment(int adjustment) {
        this.fQualificationAdjustments = adjustment;
    }

    public void setUserDefinedConversion(ICPPMethod conv) {
        this.fUserDefinedConversion = conv;
        this.fSecondStandardConversionRank = this.fRank;
        this.fRank = Rank.USER_DEFINED_CONVERSION;
        this.fCouldNarrow = false;
    }

    public int compareTo(Cost other) {
        int cmp;
        if (other == null) {
            return -1;
        }
        assert (this.fDeferredUDC == DeferredUDC.NONE && other.fDeferredUDC == DeferredUDC.NONE);
        boolean ignoreInheritanceDist = this.fImpliedObject && other.fImpliedObject;
        Rank rank = this.fRank;
        Rank otherRank = other.fRank;
        if (ignoreInheritanceDist) {
            if (rank == Rank.CONVERSION) {
                rank = Rank.IDENTITY;
            }
            if (otherRank == Rank.CONVERSION) {
                otherRank = Rank.IDENTITY;
            }
        }
        if ((cmp = rank.compareTo(otherRank)) != 0) {
            return cmp;
        }
        if (rank == Rank.USER_DEFINED_CONVERSION) {
            if (this.isAmbiguousUDC() || other.isAmbiguousUDC()) {
                return 0;
            }
            if (!(this.fUserDefinedConversion == other.fUserDefinedConversion || this.fUserDefinedConversion != null && this.fUserDefinedConversion.equals(other.fUserDefinedConversion))) {
                return 0;
            }
            cmp = this.fSecondStandardConversionRank.compareTo(other.fSecondStandardConversionRank);
            if (cmp != 0) {
                return cmp;
            }
        }
        if (!ignoreInheritanceDist && (cmp = this.fInheritanceDistance - other.fInheritanceDistance) != 0) {
            return cmp;
        }
        if (this.fReferenceBinding == ReferenceBinding.LVALUE_REF) {
            if (other.fReferenceBinding == ReferenceBinding.RVALUE_REF_BINDS_RVALUE) {
                return 1;
            }
        } else if (this.fReferenceBinding == ReferenceBinding.RVALUE_REF_BINDS_RVALUE && other.fReferenceBinding == ReferenceBinding.LVALUE_REF) {
            return -1;
        }
        int qdiff = this.fQualificationAdjustments ^ other.fQualificationAdjustments;
        if (this.fReferenceBinding == ReferenceBinding.NO_REF || other.fReferenceBinding == ReferenceBinding.NO_REF) {
            qdiff &= 0xFFFFFFF8;
        }
        if (qdiff != 0) {
            if ((this.fQualificationAdjustments & qdiff) == 0) {
                return -1;
            }
            if ((other.fQualificationAdjustments & qdiff) == 0) {
                return 1;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String comma = "";
        buf.append((Object)this.fRank).append('[');
        if (this.fQualificationAdjustments != 0) {
            buf.append(comma).append("qualification=").append(this.fQualificationAdjustments);
            comma = ", ";
        }
        if (this.fInheritanceDistance != 0) {
            buf.append(comma).append("inheritance=").append(this.fInheritanceDistance);
            comma = ", ";
        }
        if (this.fDeferredUDC != DeferredUDC.NONE) {
            buf.append(comma).append((Object)this.fDeferredUDC);
            comma = ", ";
        }
        if (this.fAmbiguousUDC) {
            buf.append(comma).append("ambiguous UDC");
            comma = ", ";
        }
        if (this.fSecondStandardConversionRank != null) {
            buf.append(comma).append("2ndConvRank=").append((Object)this.fSecondStandardConversionRank);
        }
        buf.append(']');
        return buf.toString();
    }

    public boolean isNarrowingConversion() {
        if (this.fCouldNarrow) {
            if (this.source instanceof CPPBasicType && this.target instanceof ICPPBasicType) {
                ICPPBasicType basicTarget = (ICPPBasicType)this.target;
                IBasicType.Kind targetKind = basicTarget.getKind();
                if (targetKind != IBasicType.Kind.eInt && targetKind != IBasicType.Kind.eFloat && targetKind != IBasicType.Kind.eDouble) {
                    return true;
                }
                Long val = ((CPPBasicType)this.source).getAssociatedNumericalValue();
                if (val != null) {
                    long n = val;
                    return !ArithmeticConversion.fitsIntoType(basicTarget, n);
                }
            }
            return true;
        }
        return false;
    }

    public void setCouldNarrow() {
        this.fCouldNarrow = true;
    }

    public ICPPFunction getUserDefinedConversion() {
        return this.fUserDefinedConversion;
    }

    public void setSelectedFunction(ICPPFunction function) {
        this.fSelectedFunction = function;
    }

    public ICPPFunction getSelectedFunction() {
        return this.fSelectedFunction;
    }

    public void setImpliedObject() {
        this.fImpliedObject = true;
    }

    public static enum DeferredUDC {
        NONE,
        COPY_INIT_OF_CLASS,
        INIT_BY_CONVERSION,
        LIST_INIT_OF_CLASS,
        DIRECT_LIST_INIT_OF_CLASS;

    }

    public static enum Rank {
        IDENTITY,
        PROMOTION,
        CONVERSION,
        CONVERSION_PTR_BOOL,
        USER_DEFINED_CONVERSION,
        ELLIPSIS_CONVERSION,
        NO_MATCH;

    }

    static enum ReferenceBinding {
        RVALUE_REF_BINDS_RVALUE,
        LVALUE_REF,
        OTHER_REF,
        NO_REF;

    }
}

