/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPArgumentList {
    private static final int VALUE_OFFSET = 6;
    private static final int NODE_SIZE = 12;

    public static long putArguments(PDOMNode parent, ICPPTemplateArgument[] templateArguments) throws CoreException {
        long block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = Math.min(templateArguments.length, 341);
        long p = block = db.malloc(2 + 12 * len);
        db.putShort(p, (short)len);
        p += 2L;
        int i = 0;
        while (i < len) {
            ICPPTemplateArgument arg = templateArguments[i];
            boolean isNonType = arg.isNonTypeValue();
            if (isNonType) {
                linkage.storeType(p, arg.getTypeOfNonTypeValue());
                linkage.storeValue(p + 6L, arg.getNonTypeValue());
            } else {
                linkage.storeType(p, arg.getTypeValue());
            }
            ++i;
            p += 12L;
        }
        return block;
    }

    public static void clearArguments(PDOMNode parent, long record) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(record);
        Assert.isTrue((len >= 0 && len <= 341 ? 1 : 0) != 0);
        long p = record + 2L;
        int i = 0;
        while (i < len) {
            linkage.storeType(p, null);
            linkage.storeValue(p + 6L, null);
            p += 12L;
            ++i;
        }
        db.free(record);
    }

    public static ICPPTemplateArgument[] getArguments(PDOMNode parent, long rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 341 ? 1 : 0) != 0);
        if (len == 0) {
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
        rec += 2L;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[len];
        int i = 0;
        while (i < len) {
            IValue val;
            IType type = linkage.loadType(rec);
            if (type == null) {
                type = new ProblemType(10005);
            }
            result[i] = (val = linkage.loadValue(rec + 6L)) != null ? new CPPTemplateNonTypeArgument(val, type) : new CPPTemplateTypeArgument(type);
            rec += 12L;
            ++i;
        }
        return result;
    }
}

