/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.IInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalBinding
extends CPPEvaluation {
    private final IBinding fBinding;
    private final boolean fFixedType;
    private IType fType;
    private boolean fCheckedIsValueDependent;
    private boolean fIsValueDependent;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsTypeDependent;

    public EvalBinding(IBinding binding, IType type) {
        this.fBinding = binding;
        this.fType = type;
        this.fFixedType = type != null;
    }

    public IBinding getBinding() {
        return this.fBinding;
    }

    public IType getFixedType() {
        return this.fFixedType ? this.fType : null;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = this.computeIsTypeDependent();
        }
        return this.fIsTypeDependent;
    }

    private boolean computeIsTypeDependent() {
        IType t = null;
        if (this.fFixedType) {
            t = this.fType;
        } else if (this.fBinding instanceof IEnumerator) {
            t = ((IEnumerator)this.fBinding).getType();
        } else if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            t = ((ICPPTemplateNonTypeParameter)this.fBinding).getType();
        } else if (this.fBinding instanceof IVariable) {
            t = ((IVariable)this.fBinding).getType();
        } else {
            if (this.fBinding instanceof ICPPUnknownBinding) {
                return true;
            }
            if (this.fBinding instanceof IFunction) {
                t = ((IFunction)this.fBinding).getType();
            } else {
                return false;
            }
        }
        return CPPTemplates.isDependentType(t);
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedIsValueDependent) {
            this.fCheckedIsValueDependent = true;
            this.fIsValueDependent = this.computeIsValueDependent();
        }
        return this.fIsValueDependent;
    }

    private boolean computeIsValueDependent() {
        if (this.fBinding instanceof IEnumerator) {
            return Value.isDependentValue(((IEnumerator)this.fBinding).getValue());
        }
        if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            return true;
        }
        if (this.fBinding instanceof IVariable) {
            return Value.isDependentValue(((IVariable)this.fBinding).getInitialValue());
        }
        if (this.fBinding instanceof ICPPUnknownBinding) {
            return true;
        }
        if (this.fBinding instanceof IFunction) {
            return false;
        }
        return false;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        if (this.fBinding instanceof IEnumerator) {
            return ((IEnumerator)this.fBinding).getType();
        }
        if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            IType type = ((ICPPTemplateNonTypeParameter)this.fBinding).getType();
            if (CPPTemplates.isDependentType(type)) {
                return new TypeOfDependentExpression(this);
            }
            return ExpressionTypes.prvalueType(type);
        }
        if (this.fBinding instanceof IVariable) {
            IType type = ((IVariable)this.fBinding).getType();
            if (CPPTemplates.isDependentType(type)) {
                return new TypeOfDependentExpression(this);
            }
            return SemanticUtil.mapToAST(ExpressionTypes.glvalueType(type), point);
        }
        if (this.fBinding instanceof IFunction) {
            IFunctionType type = ((IFunction)this.fBinding).getType();
            if (CPPTemplates.isDependentType(type)) {
                return new TypeOfDependentExpression(this);
            }
            return SemanticUtil.mapToAST(type, point);
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        IValue value = null;
        if (this.fBinding instanceof IInternalVariable) {
            value = ((IInternalVariable)this.fBinding).getInitialValue(25);
        } else if (this.fBinding instanceof IVariable) {
            value = ((IVariable)this.fBinding).getInitialValue();
        } else if (this.fBinding instanceof IEnumerator) {
            value = ((IEnumerator)this.fBinding).getValue();
        }
        if (value == null) {
            value = Value.UNKNOWN;
        }
        return value;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            return IASTExpression.ValueCategory.PRVALUE;
        }
        if (this.fBinding instanceof IVariable || this.fBinding instanceof IFunction) {
            return IASTExpression.ValueCategory.LVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putByte((byte)3);
        buffer.marshalBinding(this.fBinding);
        buffer.marshalType(this.fFixedType ? this.fType : null);
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IBinding binding = buffer.unmarshalBinding();
        IType type = buffer.unmarshalType();
        return new EvalBinding(binding, type);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        IBinding binding = this.fBinding;
        if (this.fBinding instanceof IEnumerator) {
            IEnumerator enumerator = (IEnumerator)binding;
            IType originalType = enumerator.getType();
            IType type = CPPTemplates.instantiateType(originalType, tpMap, packOffset, within, point);
            IValue originalValue = enumerator.getValue();
            IValue value = CPPTemplates.instantiateValue(originalValue, tpMap, packOffset, within, maxdepth, point);
            if (type != originalType || value != originalValue) {
                return new EvalFixed(type, IASTExpression.ValueCategory.PRVALUE, value);
            }
        } else if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            ICPPTemplateArgument argument = tpMap.getArgument((ICPPTemplateNonTypeParameter)this.fBinding);
            if (argument != null) {
                IValue value = argument.getNonTypeValue();
                return new EvalFixed(null, IASTExpression.ValueCategory.PRVALUE, value);
            }
        } else if (this.fBinding instanceof ICPPUnknownBinding) {
            binding = EvalBinding.resolveUnknown((ICPPUnknownBinding)this.fBinding, tpMap, packOffset, within, point);
        } else if (this.fBinding instanceof ICPPMethod) {
            IBinding owner = this.fBinding.getOwner();
            if (owner instanceof ICPPClassTemplate) {
                owner = EvalBinding.resolveUnknown(CPPTemplates.createDeferredInstance((ICPPClassTemplate)owner), tpMap, packOffset, within, point);
            }
            if (owner instanceof ICPPClassSpecialization) {
                binding = CPPTemplates.createSpecialization((ICPPClassSpecialization)owner, this.fBinding, point);
            }
        }
        if (binding == this.fBinding) {
            return this;
        }
        return new EvalBinding(binding, this.getFixedType());
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        if (this.fBinding instanceof IEnumerator) {
            return CPPTemplates.determinePackSize(((IEnumerator)this.fBinding).getValue(), tpMap);
        }
        if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            return CPPTemplates.determinePackSize((ICPPTemplateNonTypeParameter)this.fBinding, tpMap);
        }
        if (this.fBinding instanceof ICPPUnknownBinding) {
            return CPPTemplates.determinePackSize((ICPPUnknownBinding)this.fBinding, tpMap);
        }
        IBinding binding = this.fBinding;
        if (this.fBinding instanceof ICPPSpecialization) {
            binding = ((ICPPSpecialization)this.fBinding).getSpecializedBinding();
        }
        int r = Integer.MAX_VALUE;
        if (binding instanceof ICPPTemplateDefinition) {
            ICPPTemplateParameter[] parameters;
            ICPPTemplateParameter[] iCPPTemplateParameterArray = parameters = ((ICPPTemplateDefinition)binding).getTemplateParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateParameter param = iCPPTemplateParameterArray[n2];
                r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(param, tpMap));
                ++n2;
            }
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fBinding instanceof ICPPTemplateParameter;
    }
}

