/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public class TypeMarshalBuffer
implements ITypeMarshalBuffer {
    public static final byte[] EMPTY = new byte[6];
    public static final byte NULL_TYPE = 0;
    public static final byte INDIRECT_TYPE = -1;
    public static final byte BINDING_TYPE = -2;
    public static final byte UNSTORABLE_TYPE = -3;
    public static final IType UNSTORABLE_TYPE_PROBLEM = new ProblemType(10005);
    private final PDOMLinkage fLinkage;
    private int fPos;
    private byte[] fBuffer;

    static {
        assert (EMPTY.length == 6);
    }

    public TypeMarshalBuffer(PDOMLinkage linkage) {
        this.fLinkage = linkage;
    }

    public TypeMarshalBuffer(PDOMLinkage linkage, byte[] data) {
        this.fLinkage = linkage;
        this.fBuffer = data;
    }

    public int getPosition() {
        return this.fPos;
    }

    public byte[] getBuffer() {
        return this.fBuffer;
    }

    @Override
    public void marshalBinding(IBinding binding) throws CoreException {
        if (binding instanceof ISerializableType) {
            ((ISerializableType)((Object)binding)).marshal(this);
        } else if (binding == null) {
            this.putByte((byte)0);
        } else {
            PDOMBinding pb = this.fLinkage.addTypeBinding(binding);
            if (pb == null) {
                this.putByte((byte)-3);
            } else {
                this.putByte((byte)-2);
                this.putByte((byte)0);
                this.putRecordPointer(pb.getRecord());
            }
        }
    }

    @Override
    public IBinding unmarshalBinding() throws CoreException {
        if (this.fPos >= this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        byte firstByte = this.fBuffer[this.fPos];
        if (firstByte == -2) {
            this.fPos += 2;
            long rec = this.getRecordPointer();
            return (IBinding)((Object)this.fLinkage.getNode(rec));
        }
        if (firstByte == 0 || firstByte == -3) {
            ++this.fPos;
            return null;
        }
        IType type = this.fLinkage.unmarshalType(this);
        if (type == null || type instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        throw this.unmarshallingError();
    }

    @Override
    public void marshalType(IType type) throws CoreException {
        if (type instanceof ISerializableType) {
            ((ISerializableType)((Object)type)).marshal(this);
        } else if (type == null) {
            this.putByte((byte)0);
        } else if (type instanceof IBinding) {
            this.marshalBinding((IBinding)((Object)type));
        } else {
            assert (false) : "Cannot serialize " + ASTTypeUtil.getType(type) + " (" + type.getClass().getName() + ")";
            this.putByte((byte)-3);
        }
    }

    @Override
    public IType unmarshalType() throws CoreException {
        if (this.fPos >= this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        byte firstByte = this.fBuffer[this.fPos];
        if (firstByte == -2) {
            this.fPos += 2;
            long rec = this.getRecordPointer();
            return (IType)((Object)this.fLinkage.getNode(rec));
        }
        if (firstByte == 0) {
            ++this.fPos;
            return null;
        }
        if (firstByte == -3) {
            ++this.fPos;
            return UNSTORABLE_TYPE_PROBLEM;
        }
        return this.fLinkage.unmarshalType(this);
    }

    @Override
    public void marshalEvaluation(ISerializableEvaluation eval, boolean includeValues) throws CoreException {
        if (eval == null) {
            this.putByte((byte)0);
        } else {
            eval.marshal(this, includeValues);
        }
    }

    @Override
    public ISerializableEvaluation unmarshalEvaluation() throws CoreException {
        if (this.fPos >= this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        byte firstByte = this.fBuffer[this.fPos];
        if (firstByte == 0) {
            ++this.fPos;
            return null;
        }
        return this.fLinkage.unmarshalEvaluation(this);
    }

    @Override
    public void marshalValue(IValue value) throws CoreException {
        if (value instanceof Value) {
            ((Value)value).marshall(this);
        } else {
            this.putByte((byte)0);
        }
    }

    @Override
    public IValue unmarshalValue() throws CoreException {
        if (this.fPos >= this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        return Value.unmarshal(this);
    }

    @Override
    public void marshalTemplateArgument(ICPPTemplateArgument arg) throws CoreException {
        if (arg instanceof CPPTemplateNonTypeArgument) {
            this.putByte((byte)10);
            ((CPPTemplateNonTypeArgument)arg).getEvaluation().marshal(this, true);
        } else {
            this.marshalType(arg.getTypeValue());
        }
    }

    @Override
    public ICPPTemplateArgument unmarshalTemplateArgument() throws CoreException {
        int firstByte = this.getByte();
        if (firstByte == 10) {
            return new CPPTemplateNonTypeArgument((ICPPEvaluation)this.unmarshalEvaluation());
        }
        --this.fPos;
        return new CPPTemplateTypeArgument(this.unmarshalType());
    }

    private void request(int i) {
        if (this.fBuffer == null) {
            this.fBuffer = i <= 6 ? new byte[6] : new byte[i];
        } else {
            int needLen = this.fPos + i;
            int bufLen = this.fBuffer.length;
            if (needLen > bufLen) {
                needLen = Math.max(needLen, 2 * bufLen);
                byte[] newBuffer = new byte[needLen];
                System.arraycopy(this.fBuffer, 0, newBuffer, 0, this.fPos);
                this.fBuffer = newBuffer;
            }
        }
    }

    @Override
    public void putByte(byte b) {
        this.request(1);
        this.fBuffer[this.fPos++] = b;
    }

    @Override
    public int getByte() throws CoreException {
        if (this.fPos + 1 > this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        return 0xFF & this.fBuffer[this.fPos++];
    }

    @Override
    public CoreException unmarshallingError() {
        return new CoreException(CCorePlugin.createStatus((String)"Unmarshalling error"));
    }

    public CoreException marshallingError() {
        return new CoreException(CCorePlugin.createStatus((String)"Marshalling error"));
    }

    @Override
    public void putShort(short value) {
        this.request(2);
        this.fBuffer[this.fPos++] = (byte)(value >> 8);
        this.fBuffer[this.fPos++] = (byte)value;
    }

    @Override
    public int getShort() throws CoreException {
        if (this.fPos + 2 > this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        int byte1 = 0xFF & this.fBuffer[this.fPos++];
        int byte2 = 0xFF & this.fBuffer[this.fPos++];
        return byte1 << 8 | byte2 & 0xFF;
    }

    @Override
    public void putInt(int value) {
        this.request(4);
        this.fPos += 4;
        int p = this.fPos;
        this.fBuffer[--p] = (byte)value;
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
    }

    @Override
    public int getInt() throws CoreException {
        if (this.fPos + 4 > this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        int result = 0;
        result |= this.fBuffer[this.fPos++] & 0xFF;
        result <<= 8;
        result |= this.fBuffer[this.fPos++] & 0xFF;
        result <<= 8;
        result |= this.fBuffer[this.fPos++] & 0xFF;
        result <<= 8;
        return result |= this.fBuffer[this.fPos++] & 0xFF;
    }

    @Override
    public void putLong(long value) {
        this.request(8);
        this.fPos += 8;
        int p = this.fPos;
        this.fBuffer[--p] = (byte)value;
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
    }

    @Override
    public long getLong() throws CoreException {
        if (this.fPos + 8 > this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        long result = 0L;
        result |= (long)(this.fBuffer[this.fPos++] & 0xFF);
        result <<= 8;
        result |= (long)(this.fBuffer[this.fPos++] & 0xFF);
        result <<= 8;
        result |= (long)(this.fBuffer[this.fPos++] & 0xFF);
        result <<= 8;
        result |= (long)(this.fBuffer[this.fPos++] & 0xFF);
        result <<= 8;
        result |= (long)(this.fBuffer[this.fPos++] & 0xFF);
        result <<= 8;
        result |= (long)(this.fBuffer[this.fPos++] & 0xFF);
        result <<= 8;
        result |= (long)(this.fBuffer[this.fPos++] & 0xFF);
        result <<= 8;
        return result |= (long)(this.fBuffer[this.fPos++] & 0xFF);
    }

    private void putRecordPointer(long record) {
        this.request(4);
        Chunk.putRecPtr(record, this.fBuffer, this.fPos);
        this.fPos += 4;
    }

    private long getRecordPointer() throws CoreException {
        int pos = this.fPos;
        this.fPos += 4;
        if (this.fPos > this.fBuffer.length) {
            this.fPos = this.fBuffer.length;
            throw this.unmarshallingError();
        }
        return Chunk.getRecPtr(this.fBuffer, pos);
    }

    @Override
    public void putCharArray(char[] chars) {
        this.putShort((short)chars.length);
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.putShort((short)c);
            ++n2;
        }
    }

    @Override
    public char[] getCharArray() throws CoreException {
        int len = this.getShort();
        char[] expr = new char[len];
        int i = 0;
        while (i < expr.length) {
            expr[i] = (char)this.getShort();
            ++i;
        }
        return expr;
    }
}

