/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFriend;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassType
extends PDOMCPPBinding
implements IPDOMCPPClassType,
IPDOMMemberOwner {
    private static final int FIRSTBASE = 28;
    private static final int MEMBERLIST = 32;
    private static final int FIRSTFRIEND = 36;
    private static final int KEY = 40;
    private static final int ANONYMOUS = 41;
    private static final int FINAL = 42;
    protected static final int RECORD_SIZE = 43;
    private PDOMCPPClassScope fScope;

    public PDOMCPPClassType(PDOMLinkage linkage, PDOMNode parent, ICPPClassType classType) throws CoreException {
        super(linkage, parent, classType.getNameCharArray());
        this.setKind(classType);
        this.setAnonymous(classType);
        this.setFinal(classType);
    }

    public PDOMCPPClassType(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 43;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPClassType) {
            ICPPClassType ct = (ICPPClassType)newBinding;
            this.setKind(ct);
            this.setAnonymous(ct);
            this.setFinal(ct);
            super.update(linkage, newBinding);
        }
    }

    private void setKind(ICPPClassType ct) throws CoreException {
        this.getDB().putByte(this.record + 40L, (byte)ct.getKey());
    }

    private void setAnonymous(ICPPClassType ct) throws CoreException {
        this.getDB().putByte(this.record + 41L, (byte)(ct.isAnonymous() ? 1 : 0));
    }

    private void setFinal(ICPPClassType ct) throws CoreException {
        this.getDB().putByte(this.record + 42L, (byte)(ct.isFinal() ? 1 : 0));
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public final void addChild(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32L);
        list.addMember(member);
        PDOMCPPClassScope.updateCache(this, member);
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPClassScope.acceptViaCache(this, visitor, false);
    }

    @Override
    public void acceptUncached(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32L);
        list.accept(visitor);
    }

    private PDOMCPPBase getFirstBase() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 28L);
        return rec != 0L ? new PDOMCPPBase((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        long rec = base != null ? base.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 28L, rec);
    }

    public void addBase(PDOMCPPBase base) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        PDOMCPPBase firstBase = this.getFirstBase();
        base.setNextBase(firstBase);
        this.setFirstBase(base);
    }

    public void removeBase(PDOMName pdomName) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase predecessor = null;
        long nameRec = pdomName.getRecord();
        while (base != null) {
            PDOMName name = base.getBaseClassSpecifierName();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = base;
            base = base.getNextBase();
        }
        if (base != null) {
            if (predecessor != null) {
                predecessor.setNextBase(base.getNextBase());
            } else {
                this.setFirstBase(base.getNextBase());
            }
            base.delete();
        }
    }

    public void addFriend(PDOMCPPFriend friend) throws CoreException {
        PDOMCPPFriend firstFriend = this.getFirstFriend();
        friend.setNextFriend(firstFriend);
        this.setFirstFriend(friend);
    }

    private PDOMCPPFriend getFirstFriend() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 36L);
        return rec != 0L ? new PDOMCPPFriend((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstFriend(PDOMCPPFriend friend) throws CoreException {
        long rec = friend != null ? friend.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 36L, rec);
    }

    public void removeFriend(PDOMName pdomName) throws CoreException {
        PDOMCPPFriend friend = this.getFirstFriend();
        PDOMCPPFriend predecessor = null;
        long nameRec = pdomName.getRecord();
        while (friend != null) {
            PDOMName name = friend.getSpecifierName();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = friend;
            friend = friend.getNextFriend();
        }
        if (friend != null) {
            if (predecessor != null) {
                predecessor.setNextFriend(friend.getNextFriend());
            } else {
                this.setFirstFriend(friend.getNextFriend());
            }
            friend.delete();
        }
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        if (this.fScope == null) {
            this.fScope = new PDOMCPPClassScope(this);
        }
        return this.fScope;
    }

    @Override
    public int getKey() {
        try {
            return this.getDB().getByte(this.record + 40L);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return 3;
        }
    }

    @Override
    public boolean isAnonymous() {
        try {
            return this.getDB().getByte(this.record + 41L) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isFinal() {
        try {
            return this.getDB().getByte(this.record + 42L) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPClassType && !(type instanceof ProblemBinding)) {
            ICPPClassType ctype = (ICPPClassType)type;
            if (PDOMCPPClassType.getEquivalentKind(ctype) != PDOMCPPClassType.getEquivalentKind(this)) {
                return false;
            }
            char[] nchars = ctype.getNameCharArray();
            if (nchars.length == 0) {
                nchars = ASTTypeUtil.createNameForAnonymous(ctype);
            }
            if (nchars == null || !CharArrayUtils.equals(nchars, this.getNameCharArray())) {
                return false;
            }
            return SemanticUtil.isSameOwner(this.getOwner(), ctype.getOwner());
        }
        return false;
    }

    private static int getEquivalentKind(ICPPClassType classType) {
        int key = classType.getKey();
        return key == 3 ? 1 : key;
    }

    @Override
    public ICPPBase[] getBases() {
        Long key = this.record + 1L;
        ICPPBase[] bases = (ICPPBase[])this.getPDOM().getCachedResult(key);
        if (bases != null) {
            return bases;
        }
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Collections.reverse(list);
            bases = list.toArray(new ICPPBase[list.size()]);
            this.getPDOM().putCachedResult(key, bases);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new ICPPBase[0];
        }
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
        try {
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getConstructors();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            PDOMCPPClassScope.acceptViaCache(this, methods, false);
            return methods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPField.EMPTY_CPPFIELD_ARRAY;
        }
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        try {
            PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPClassType.EMPTY_CLASS_ARRAY;
        }
    }

    @Override
    public IBinding[] getFriends() {
        try {
            ArrayList<IBinding> list = new ArrayList<IBinding>();
            PDOMCPPFriend friend = this.getFirstFriend();
            while (friend != null) {
                list.add(0, friend.getFriendSpecifier());
                friend = friend.getNextFriend();
            }
            return list.toArray(new IBinding[list.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new IBinding[0];
        }
    }

    @Override
    public ICPPMethod[] getMethods() {
        return ClassTypeHelper.getMethods(this, null);
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ClassTypeHelper.getAllDeclaredMethods(this, null);
    }

    @Override
    public IField[] getFields() {
        return ClassTypeHelper.getFields(this, null);
    }

    @Override
    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

