/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.IInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.cdt.internal.core.parser.scanner.ExpressionEvaluator;
import org.eclipse.core.runtime.CoreException;

public class Value
implements IValue {
    public static final int MAX_RECURSION_DEPTH = 25;
    public static final Value UNKNOWN = new Value("<unknown>".toCharArray(), null);
    public static final Value NOT_INITIALIZED = new Value("<__>".toCharArray(), null);
    private static final char UNIQUE_CHAR = '_';
    private static final IValue[] TYPICAL = new IValue[]{new Value(new char[]{'0'}, null), new Value(new char[]{'1'}, null), new Value(new char[]{'2'}, null), new Value(new char[]{'3'}, null), new Value(new char[]{'4'}, null), new Value(new char[]{'5'}, null), new Value(new char[]{'6'}, null)};
    private static UnknownValueException UNKNOWN_EX = new UnknownValueException();
    private static int sUnique = 0;
    private final char[] fFixedValue;
    private final ICPPEvaluation fEvaluation;
    private char[] fSignature;

    private Value(char[] fixedValue, ICPPEvaluation evaluation) {
        assert (fixedValue == null != (evaluation == null));
        this.fFixedValue = fixedValue;
        this.fEvaluation = evaluation;
    }

    @Override
    public Long numericalValue() {
        return this.fFixedValue == null ? null : Value.parseLong(this.fFixedValue);
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        return this.fEvaluation;
    }

    @Override
    public char[] getSignature() {
        if (this.fSignature == null) {
            this.fSignature = this.fFixedValue != null ? this.fFixedValue : this.fEvaluation.getSignature();
        }
        return this.fSignature;
    }

    @Override
    @Deprecated
    public char[] getInternalExpression() {
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    @Deprecated
    public IBinding[] getUnknownBindings() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public void marshall(ITypeMarshalBuffer buf) throws CoreException {
        if (UNKNOWN == this) {
            buf.putByte((byte)26);
        } else {
            Long num = this.numericalValue();
            if (num != null) {
                long lv = num;
                if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                    buf.putByte((byte)42);
                    buf.putInt((int)lv);
                } else {
                    buf.putByte((byte)74);
                    buf.putLong(lv);
                }
            } else if (this.fFixedValue != null) {
                buf.putByte((byte)-118);
                buf.putCharArray(this.fFixedValue);
            } else {
                buf.putByte((byte)10);
                this.fEvaluation.marshal(buf, true);
            }
        }
    }

    public static IValue unmarshal(ITypeMarshalBuffer buf) throws CoreException {
        int firstByte = buf.getByte();
        if (firstByte == 0) {
            return null;
        }
        if ((firstByte & 0x10) != 0) {
            return UNKNOWN;
        }
        if ((firstByte & 0x20) != 0) {
            int val = buf.getInt();
            return Value.create(val);
        }
        if ((firstByte & 0x40) != 0) {
            long val = buf.getLong();
            return Value.create(val);
        }
        if ((firstByte & 0x80) != 0) {
            char[] fixedValue = buf.getCharArray();
            return new Value(fixedValue, null);
        }
        ISerializableEvaluation eval = buf.unmarshalEvaluation();
        if (eval instanceof ICPPEvaluation) {
            return new Value(null, (ICPPEvaluation)eval);
        }
        return UNKNOWN;
    }

    public int hashCode() {
        return CharArrayUtils.hash(this.getSignature());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Value)) {
            return false;
        }
        Value rhs = (Value)obj;
        if (this.fFixedValue != null) {
            return CharArrayUtils.equals(this.fFixedValue, rhs.fFixedValue);
        }
        return CharArrayUtils.equals(this.getSignature(), rhs.getSignature());
    }

    public String toString() {
        return new String(this.getSignature());
    }

    public static IValue create(long value) {
        if (value >= 0L && value < (long)TYPICAL.length) {
            return TYPICAL[(int)value];
        }
        return new Value(Value.toCharArray(value), null);
    }

    public static IValue create(boolean value) {
        return Value.create(value ? 1 : 0);
    }

    public static IValue create(ICPPTemplateNonTypeParameter tntp) {
        EvalBinding eval = new EvalBinding(tntp, null);
        return new Value(null, eval);
    }

    public static IValue create(ICPPEvaluation eval) {
        return new Value(null, eval);
    }

    public static IValue evaluateBinaryExpression(int op, long v1, long v2) {
        try {
            return Value.create(Value.applyBinaryOperator(op, v1, v2));
        }
        catch (UnknownValueException unknownValueException) {
            return UNKNOWN;
        }
    }

    public static IValue evaluateUnaryExpression(int unaryOp, long value) {
        try {
            return Value.create(Value.applyUnaryOperator(unaryOp, value));
        }
        catch (UnknownValueException unknownValueException) {
            return UNKNOWN;
        }
    }

    public static IValue evaluateUnaryTypeIdExpression(int operator, IType type, IASTNode point) {
        try {
            return Value.create(Value.applyUnaryTypeIdOperator(operator, type, point));
        }
        catch (UnknownValueException unknownValueException) {
            return UNKNOWN;
        }
    }

    public static IValue evaluateBinaryTypeIdExpression(IASTBinaryTypeIdExpression.Operator operator, IType type1, IType type2, IASTNode point) {
        try {
            return Value.create(Value.applyBinaryTypeIdOperator(operator, type1, type2, point));
        }
        catch (UnknownValueException unknownValueException) {
            return UNKNOWN;
        }
    }

    private static long applyUnaryTypeIdOperator(int operator, IType type, IASTNode point) throws UnknownValueException {
        switch (operator) {
            case 0: {
                return Value.getSizeAndAlignment((IType)type, (IASTNode)point).size;
            }
            case 2: {
                return Value.getSizeAndAlignment((IType)type, (IASTNode)point).alignment;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                return !(type instanceof ICPPClassType) || TypeTraits.hasTrivialCopyCtor((ICPPClassType)type, point) ? 1 : 0;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                return type instanceof ICPPClassType && TypeTraits.isAbstract((ICPPClassType)type, point) ? 1 : 0;
            }
            case 13: {
                return type instanceof ICompositeType && ((ICompositeType)type).getKey() != 2 ? 1 : 0;
            }
            case 14: {
                break;
            }
            case 15: {
                return type instanceof IEnumeration ? 1 : 0;
            }
            case 19: {
                break;
            }
            case 16: {
                return TypeTraits.isPOD(type, point) ? 1 : 0;
            }
            case 17: {
                return type instanceof ICPPClassType && TypeTraits.isPolymorphic((ICPPClassType)type, point) ? 1 : 0;
            }
            case 20: {
                return TypeTraits.isStandardLayout(type, point) ? 1 : 0;
            }
            case 21: {
                return type instanceof ICPPClassType && TypeTraits.isTrivial((ICPPClassType)type, point) ? 1 : 0;
            }
            case 18: {
                return type instanceof ICompositeType && ((ICompositeType)type).getKey() == 2 ? 1 : 0;
            }
        }
        throw UNKNOWN_EX;
    }

    public static long applyBinaryTypeIdOperator(IASTBinaryTypeIdExpression.Operator operator, IType type1, IType type2, IASTNode point) throws UnknownValueException {
        switch (operator) {
            case __is_base_of: {
                if (!(type1 instanceof ICPPClassType) || !(type1 instanceof ICPPClassType)) break;
                return ClassTypeHelper.isSubclass((ICPPClassType)type2, (ICPPClassType)type1) ? 1 : 0;
            }
        }
        throw UNKNOWN_EX;
    }

    private static SizeofCalculator.SizeAndAlignment getSizeAndAlignment(IType type, IASTNode point) throws UnknownValueException {
        SizeofCalculator.SizeAndAlignment sizeAndAlignment = SizeofCalculator.getSizeAndAlignment(type, point);
        if (sizeAndAlignment == null) {
            throw UNKNOWN_EX;
        }
        return sizeAndAlignment;
    }

    public static int isTemplateParameter(IValue tval) {
        IBinding binding;
        ICPPEvaluation eval = tval.getEvaluation();
        if (eval instanceof EvalBinding && (binding = ((EvalBinding)eval).getBinding()) instanceof ICPPTemplateParameter) {
            return ((ICPPTemplateParameter)binding).getParameterID();
        }
        return -1;
    }

    public static boolean referencesTemplateParameter(IValue tval) {
        ICPPEvaluation eval = tval.getEvaluation();
        if (eval == null) {
            return false;
        }
        return eval.referencesTemplateParameter();
    }

    public static boolean isDependentValue(IValue nonTypeValue) {
        return nonTypeValue.getEvaluation() != null;
    }

    public static IValue create(IASTExpression expr, int maxRecursionDepth) {
        try {
            Long obj = Value.evaluate(expr, maxRecursionDepth);
            if (obj instanceof Long) {
                return Value.create(obj);
            }
            if (expr instanceof ICPPASTInitializerClause) {
                ICPPEvaluation evaluation = ((ICPPASTInitializerClause)((Object)expr)).getEvaluation();
                return new Value(null, evaluation);
            }
        }
        catch (UnknownValueException unknownValueException) {}
        return UNKNOWN;
    }

    public static IValue fromInternalRepresentation(ICPPEvaluation evaluation) {
        return new Value(null, evaluation);
    }

    public static IValue unique() {
        StringBuilder buf = new StringBuilder(10);
        buf.append('_');
        buf.append(++sUnique);
        return new Value(CharArrayUtils.extractChars(buf), null);
    }

    private static Long evaluate(IASTExpression exp, int maxdepth) throws UnknownValueException {
        if (maxdepth < 0 || exp == null) {
            throw UNKNOWN_EX;
        }
        if (exp instanceof IASTArraySubscriptExpression) {
            throw UNKNOWN_EX;
        }
        if (exp instanceof IASTBinaryExpression) {
            return Value.evaluateBinaryExpression((IASTBinaryExpression)exp, maxdepth);
        }
        if (exp instanceof IASTCastExpression) {
            return Value.evaluate(((IASTCastExpression)exp).getOperand(), maxdepth);
        }
        if (exp instanceof IASTUnaryExpression) {
            return Value.evaluateUnaryExpression((IASTUnaryExpression)exp, maxdepth);
        }
        if (exp instanceof IASTConditionalExpression) {
            IASTConditionalExpression cexpr = (IASTConditionalExpression)exp;
            Long v = Value.evaluate(cexpr.getLogicalConditionExpression(), maxdepth);
            if (v == null) {
                return null;
            }
            if (v == 0L) {
                return Value.evaluate(cexpr.getNegativeResultExpression(), maxdepth);
            }
            IASTExpression pe = cexpr.getPositiveResultExpression();
            if (pe == null) {
                return v;
            }
            return Value.evaluate(pe, maxdepth);
        }
        if (exp instanceof IASTIdExpression) {
            IBinding b = ((IASTIdExpression)exp).getName().resolvePreBinding();
            return Value.evaluateBinding(b, maxdepth);
        }
        if (exp instanceof IASTLiteralExpression) {
            IASTLiteralExpression litEx = (IASTLiteralExpression)exp;
            switch (litEx.getKind()) {
                case 6: 
                case 7: {
                    return 0L;
                }
                case 5: {
                    return 1L;
                }
                case 0: {
                    try {
                        return ExpressionEvaluator.getNumber(litEx.getValue());
                    }
                    catch (ExpressionEvaluator.EvalException evalException) {
                        throw UNKNOWN_EX;
                    }
                }
                case 2: {
                    try {
                        char[] image = litEx.getValue();
                        if (image.length > 1 && image[0] == 'L') {
                            return ExpressionEvaluator.getChar(image, 2);
                        }
                        return ExpressionEvaluator.getChar(image, 1);
                    }
                    catch (ExpressionEvaluator.EvalException evalException) {
                        throw UNKNOWN_EX;
                    }
                }
            }
        }
        if (exp instanceof IASTTypeIdExpression) {
            ASTTranslationUnit ast = (ASTTranslationUnit)exp.getTranslationUnit();
            IType type = ast.createType(((IASTTypeIdExpression)exp).getTypeId());
            if (type instanceof ICPPUnknownType) {
                return null;
            }
            return Value.applyUnaryTypeIdOperator(((IASTTypeIdExpression)exp).getOperator(), type, exp);
        }
        boolean cfr_ignored_0 = exp instanceof IASTBinaryTypeIdExpression;
        throw UNKNOWN_EX;
    }

    private static Long evaluateBinding(IBinding b, int maxdepth) throws UnknownValueException {
        if (b instanceof IType) {
            throw UNKNOWN_EX;
        }
        if (b instanceof ICPPTemplateNonTypeParameter) {
            return null;
        }
        if (b instanceof ICPPUnknownBinding) {
            return null;
        }
        IValue value = null;
        if (b instanceof IInternalVariable) {
            value = ((IInternalVariable)b).getInitialValue(maxdepth - 1);
        } else if (b instanceof IVariable) {
            value = ((IVariable)b).getInitialValue();
        } else if (b instanceof IEnumerator) {
            value = ((IEnumerator)b).getValue();
        }
        if (value != null && value != UNKNOWN) {
            return value.numericalValue();
        }
        throw UNKNOWN_EX;
    }

    private static Long evaluateUnaryExpression(IASTUnaryExpression exp, int maxdepth) throws UnknownValueException {
        int unaryOp = exp.getOperator();
        if (unaryOp == 8) {
            IASTExpression operand = exp.getOperand();
            if (operand != null) {
                IType type = operand.getExpressionType();
                if (type instanceof ICPPUnknownType) {
                    return null;
                }
                ASTTranslationUnit ast = (ASTTranslationUnit)exp.getTranslationUnit();
                SizeofCalculator calculator = ast.getSizeofCalculator();
                SizeofCalculator.SizeAndAlignment info = calculator.sizeAndAlignment(type);
                if (info != null) {
                    return info.size;
                }
            }
            throw UNKNOWN_EX;
        }
        if (unaryOp == 5 || unaryOp == 4 || unaryOp == 16) {
            throw UNKNOWN_EX;
        }
        Long value = Value.evaluate(exp.getOperand(), maxdepth);
        if (value == null) {
            return null;
        }
        return Value.applyUnaryOperator(unaryOp, value);
    }

    private static long applyUnaryOperator(int unaryOp, long value) throws UnknownValueException {
        switch (unaryOp) {
            case 2: 
            case 11: {
                return value;
            }
        }
        switch (unaryOp) {
            case 0: 
            case 9: {
                return value + 1L;
            }
            case 1: 
            case 10: {
                return value - 1L;
            }
            case 3: {
                return -value;
            }
            case 6: {
                return value ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 7: {
                return value == 0L ? 1 : 0;
            }
        }
        throw UNKNOWN_EX;
    }

    private static Long evaluateBinaryExpression(IASTBinaryExpression exp, int maxdepth) throws UnknownValueException {
        int op = exp.getOperator();
        switch (op) {
            case 28: {
                if (!exp.getOperand1().equals(exp.getOperand2())) break;
                return 1L;
            }
            case 29: {
                if (!exp.getOperand1().equals(exp.getOperand2())) break;
                return 0L;
            }
        }
        Long o1 = Value.evaluate(exp.getOperand1(), maxdepth);
        if (o1 == null) {
            return null;
        }
        Long o2 = Value.evaluate(exp.getOperand2(), maxdepth);
        if (o2 == null) {
            return null;
        }
        return Value.applyBinaryOperator(op, o1, o2);
    }

    private static long applyBinaryOperator(int op, long v1, long v2) throws UnknownValueException {
        switch (op) {
            case 1: {
                return v1 * v2;
            }
            case 2: {
                if (v2 == 0L) {
                    throw UNKNOWN_EX;
                }
                return v1 / v2;
            }
            case 3: {
                if (v2 == 0L) {
                    throw UNKNOWN_EX;
                }
                return v1 % v2;
            }
            case 4: {
                return v1 + v2;
            }
            case 5: {
                return v1 - v2;
            }
            case 6: {
                return v1 << (int)v2;
            }
            case 7: {
                return v1 >> (int)v2;
            }
            case 8: {
                return v1 < v2 ? 1 : 0;
            }
            case 9: {
                return v1 > v2 ? 1 : 0;
            }
            case 10: {
                return v1 <= v2 ? 1 : 0;
            }
            case 11: {
                return v1 >= v2 ? 1 : 0;
            }
            case 12: {
                return v1 & v2;
            }
            case 13: {
                return v1 ^ v2;
            }
            case 14: {
                return v1 | v2;
            }
            case 15: {
                return v1 != 0L && v2 != 0L ? 1 : 0;
            }
            case 16: {
                return v1 != 0L || v2 != 0L ? 1 : 0;
            }
            case 28: {
                return v1 == v2 ? 1 : 0;
            }
            case 29: {
                return v1 != v2 ? 1 : 0;
            }
            case 32: {
                return Math.max(v1, v2);
            }
            case 33: {
                return Math.min(v1, v2);
            }
        }
        throw UNKNOWN_EX;
    }

    /*
     * Unable to fully structure code
     */
    private static Long parseLong(char[] value) {
        len = value.length;
        negative = false;
        result = 0L;
        i = 0;
        if (len > 0 && value[0] == '-') {
            negative = true;
            ++i;
        }
        if (i != len) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            if (result > 0xCCCCCCCCCCCCCCCL) {
                return null;
            }
            digit = value[i] - 48;
            if (digit < 0 || digit > 9) {
                return null;
            }
            result = result * 10L + (long)digit;
            ++i;
lbl17:
            // 2 sources

            ** while (i < len)
        }
lbl18:
        // 1 sources

        return negative != false ? -result : result;
    }

    private static char[] toCharArray(long value) {
        StringBuilder buf = new StringBuilder();
        buf.append(value);
        return CharArrayUtils.extractChars(buf);
    }

    private static class UnknownValueException
    extends Exception {
        private UnknownValueException() {
        }
    }
}

