/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalID;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;

public class CPPASTFieldReference
extends ASTNode
implements ICPPASTFieldReference,
IASTAmbiguityParent,
ICPPASTCompletionContext {
    private boolean isTemplate;
    private ICPPASTExpression owner;
    private IASTName name;
    private boolean isDeref;
    private IASTImplicitName[] implicitNames;
    private ICPPEvaluation fEvaluation;

    public CPPASTFieldReference() {
    }

    public CPPASTFieldReference(IASTName name, IASTExpression owner) {
        this.setFieldName(name);
        this.setFieldOwner(owner);
    }

    @Override
    public CPPASTFieldReference copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTFieldReference copy(IASTNode.CopyStyle style) {
        CPPASTFieldReference copy = new CPPASTFieldReference();
        copy.setFieldName(this.name == null ? null : this.name.copy(style));
        copy.setFieldOwner(this.owner == null ? null : this.owner.copy(style));
        copy.isTemplate = this.isTemplate;
        copy.isDeref = this.isDeref;
        return this.copy(copy, style);
    }

    @Override
    public boolean isTemplate() {
        return this.isTemplate;
    }

    @Override
    public void setIsTemplate(boolean value) {
        this.assertNotFrozen();
        this.isTemplate = value;
    }

    @Override
    public ICPPASTExpression getFieldOwner() {
        return this.owner;
    }

    @Override
    public void setFieldOwner(IASTExpression expression) {
        this.assertNotFrozen();
        this.owner = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FIELD_OWNER);
        }
    }

    @Override
    public IASTName getFieldName() {
        return this.name;
    }

    @Override
    public void setFieldName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(FIELD_NAME);
        }
    }

    @Override
    public boolean isPointerDereference() {
        return this.isDeref;
    }

    @Override
    public void setIsPointerDereference(boolean value) {
        this.assertNotFrozen();
        this.isDeref = value;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            if (!this.isDeref) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            ArrayList<ICPPFunction> functionBindings = new ArrayList<ICPPFunction>();
            EvalMemberAccess.getFieldOwnerType(this.owner.getExpressionType(), this.isDeref, this, functionBindings, false);
            if (functionBindings.isEmpty()) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            this.implicitNames = new IASTImplicitName[functionBindings.size()];
            int i = -1;
            for (ICPPFunction op : functionBindings) {
                if (op == null || op instanceof CPPImplicitFunction) continue;
                CPPASTImplicitName operatorName = new CPPASTImplicitName(OverloadableOperator.ARROW, (IASTNode)this);
                operatorName.setBinding(op);
                operatorName.computeOperatorOffsets(this.owner, true);
                this.implicitNames[++i] = operatorName;
            }
            this.implicitNames = ArrayUtil.trimAt(IASTImplicitName.class, this.implicitNames, i);
        }
        return this.implicitNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.owner != null && !this.owner.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.owner) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.owner = (ICPPASTExpression)other;
        }
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        IBinding[] iBindingArray = bindings;
        int n2 = bindings.length;
        int n3 = 0;
        while (n3 < n2) {
            ICPPMethod method;
            IBinding binding = iBindingArray[n3];
            if (!(binding instanceof ICPPMethod) || !(method = (ICPPMethod)binding).isImplicit()) {
                filtered.add(binding);
            }
            ++n3;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }

    @Override
    public IType getFieldOwnerType() {
        return EvalMemberAccess.getFieldOwnerType(this.owner.getExpressionType(), this.isDeref, this, null, true);
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.createEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation createEvaluation() {
        IType ownerType;
        ICPPEvaluation ownerEval = this.owner.getEvaluation();
        if (!ownerEval.isTypeDependent() && (ownerType = EvalMemberAccess.getFieldOwnerType(ownerEval.getTypeOrFunctionSet(this), this.isDeref, this, null, false)) != null) {
            IBinding binding = this.name.resolvePreBinding();
            if (binding instanceof CPPFunctionSet) {
                binding = this.name.resolveBinding();
            }
            if (binding instanceof IProblemBinding || binding instanceof IType || binding instanceof ICPPConstructor) {
                return EvalFixed.INCOMPLETE;
            }
            return new EvalMemberAccess(ownerType, ownerEval.getValueCategory(this), binding, this.isDeref);
        }
        IBinding qualifier = null;
        ICPPTemplateArgument[] args = null;
        IASTName n = this.name;
        if (n instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
            if (ns.length < 2) {
                return EvalFixed.INCOMPLETE;
            }
            qualifier = ns[ns.length - 2].resolveBinding();
            if (qualifier instanceof IProblemBinding) {
                return EvalFixed.INCOMPLETE;
            }
            n = ns[ns.length - 1];
        }
        if (n instanceof ICPPASTTemplateId) {
            args = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)n);
        }
        return new EvalID(ownerEval, qualifier, this.name.getSimpleID(), false, true, args);
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }
}

