/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.core.runtime.CoreException;

public class EvalFunctionSet
extends CPPEvaluation {
    private final CPPFunctionSet fFunctionSet;
    private final boolean fAddressOf;

    public EvalFunctionSet(CPPFunctionSet set, boolean addressOf) {
        this.fFunctionSet = set;
        this.fAddressOf = addressOf;
    }

    public CPPFunctionSet getFunctionSet() {
        return this.fFunctionSet;
    }

    public boolean isAddressOf() {
        return this.fAddressOf;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return true;
    }

    @Override
    public boolean isTypeDependent() {
        int n;
        int n2;
        Object[] objectArray;
        ICPPTemplateArgument[] args = this.fFunctionSet.getTemplateArguments();
        if (args != null) {
            objectArray = args;
            n2 = args.length;
            n = 0;
            while (n < n2) {
                Object arg = objectArray[n];
                if (CPPTemplates.isDependentArgument((ICPPTemplateArgument)arg)) {
                    return true;
                }
                ++n;
            }
        }
        objectArray = this.fFunctionSet.getBindings();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Object f = objectArray[n];
            if (f instanceof ICPPUnknownBinding) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean isValueDependent() {
        return false;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        return new FunctionSetType(this.fFunctionSet, this.fAddressOf);
    }

    @Override
    public IValue getValue(IASTNode point) {
        return Value.UNKNOWN;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        ICPPFunction[] bindings = this.fFunctionSet.getBindings();
        ICPPTemplateArgument[] args = this.fFunctionSet.getTemplateArguments();
        int firstByte = 9;
        if (this.fAddressOf) {
            firstByte |= 0x10;
        }
        if (args != null) {
            firstByte |= 0x20;
        }
        buffer.putByte((byte)firstByte);
        buffer.putShort((short)bindings.length);
        Object[] objectArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction binding = objectArray[n2];
            buffer.marshalBinding(binding);
            ++n2;
        }
        if (args != null) {
            buffer.putShort((short)args.length);
            objectArray = args;
            n = args.length;
            n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                buffer.marshalTemplateArgument((ICPPTemplateArgument)arg);
                ++n2;
            }
        }
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        boolean addressOf = (firstByte & 0x10) != 0;
        int bindingCount = buffer.getShort();
        ICPPFunction[] bindings = new ICPPFunction[bindingCount];
        int i = 0;
        while (i < bindings.length) {
            bindings[i] = (ICPPFunction)buffer.unmarshalBinding();
            ++i;
        }
        ICPPTemplateArgument[] args = null;
        if ((firstByte & 0x20) != 0) {
            int len = buffer.getShort();
            args = new ICPPTemplateArgument[len];
            int i2 = 0;
            while (i2 < args.length) {
                args[i2] = buffer.unmarshalTemplateArgument();
                ++i2;
            }
        }
        return new EvalFunctionSet(new CPPFunctionSet(bindings, args, null), addressOf);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        ICPPFunction[] originalFunctions;
        IType type;
        IBinding originalOwner;
        Object[] originalArguments;
        Object[] arguments = originalArguments = this.fFunctionSet.getTemplateArguments();
        arguments = EvalFunctionSet.instantiateArguments((ICPPTemplateArgument[])originalArguments, tpMap, packOffset, within, point);
        IBinding owner = originalOwner = this.fFunctionSet.getOwner();
        if (originalOwner instanceof ICPPUnknownBinding) {
            owner = EvalFunctionSet.resolveUnknown((ICPPUnknownBinding)owner, tpMap, packOffset, within, point);
        } else if (owner instanceof IType && (type = CPPTemplates.instantiateType((IType)((Object)owner), tpMap, packOffset, within, point)) instanceof IBinding) {
            owner = (IBinding)((Object)type);
        }
        ICPPFunction[] functions = originalFunctions = this.fFunctionSet.getBindings();
        if (owner instanceof ICPPClassSpecialization && owner != originalOwner) {
            functions = new ICPPFunction[originalFunctions.length];
            int i = 0;
            while (i < originalFunctions.length) {
                functions[i] = (ICPPFunction)CPPTemplates.createSpecialization((ICPPClassSpecialization)owner, originalFunctions[i], point);
                ++i;
            }
        }
        if (Arrays.equals(arguments, originalArguments) && functions == originalFunctions) {
            return this;
        }
        return new EvalFunctionSet(new CPPFunctionSet(functions, (ICPPTemplateArgument[])arguments, null), this.fAddressOf);
    }

    public ICPPEvaluation resolveFunction(ICPPEvaluation[] args, IASTNode point) {
        ICPPFunction[] functions = this.fFunctionSet.getBindings();
        LookupData data = new LookupData(functions[0].getNameCharArray(), this.fFunctionSet.getTemplateArguments(), point);
        data.setFunctionArguments(false, args);
        try {
            IBinding binding = CPPSemantics.resolveFunction(data, functions, true);
            if (binding instanceof ICPPFunction && !(binding instanceof ICPPUnknownBinding)) {
                return new EvalBinding(binding, null);
            }
        }
        catch (DOMException e) {
            CCorePlugin.log((Throwable)e);
        }
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        ICPPTemplateArgument[] templateArguments;
        int r = Integer.MAX_VALUE;
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = templateArguments = this.fFunctionSet.getTemplateArguments();
        int n = templateArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(arg, tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }
}

