/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPArgumentList;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownClassType;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPUnknownClassInstance
extends PDOMCPPUnknownClassType
implements ICPPUnknownClassInstance,
IPDOMOverloader {
    private static final int ARGUMENTS = 36;
    private static final int SIGNATURE_HASH = 40;
    protected static final int RECORD_SIZE = 44;
    private volatile ICPPTemplateArgument[] arguments;

    public PDOMCPPUnknownClassInstance(PDOMLinkage linkage, PDOMNode parent, ICPPUnknownClassInstance classInstance) throws CoreException {
        super(linkage, parent, classInstance);
        ICPPTemplateArgument[] args = classInstance.getArguments();
        long rec = PDOMCPPArgumentList.putArguments(this, args);
        Database db = this.getDB();
        db.putRecPtr(this.record + 36L, rec);
        try {
            Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(classInstance);
            db.putInt(this.record + 40L, sigHash != null ? sigHash : 0);
        }
        catch (DOMException dOMException) {}
    }

    public PDOMCPPUnknownClassInstance(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 44;
    }

    @Override
    public int getNodeType() {
        return 48;
    }

    @Override
    public int getSignatureHash() throws CoreException {
        return this.getDB().getInt(this.record + 40L);
    }

    @Override
    public ICPPTemplateArgument[] getArguments() {
        if (this.arguments == null) {
            try {
                long rec = this.getPDOM().getDB().getRecPtr(this.record + 36L);
                this.arguments = PDOMCPPArgumentList.getArguments(this, rec);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                this.arguments = ICPPTemplateArgument.EMPTY_ARGUMENTS;
            }
        }
        return this.arguments;
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM() && node.getRecord() == this.getRecord()) {
            return true;
        }
        if (type instanceof ICPPUnknownClassInstance) {
            ICPPUnknownClassInstance rhs = (ICPPUnknownClassInstance)type;
            if (CharArrayUtils.equals(this.getNameCharArray(), rhs.getNameCharArray())) {
                ICPPTemplateArgument[] rhsArgs;
                ICPPTemplateArgument[] lhsArgs = this.getArguments();
                if (lhsArgs != (rhsArgs = rhs.getArguments())) {
                    if (lhsArgs == null || rhsArgs == null) {
                        return false;
                    }
                    if (lhsArgs.length != rhsArgs.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < lhsArgs.length) {
                        if (!lhsArgs[i].isSameValue(rhsArgs[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                IIndexBinding lhsContainer = this.getOwner();
                IBinding rhsContainer = rhs.getOwner();
                if (lhsContainer instanceof IType && rhsContainer instanceof IType) {
                    return ((IType)((Object)lhsContainer)).isSameType((IType)((Object)rhsContainer));
                }
            }
        }
        return false;
    }
}

