/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.resources;

import java.io.File;
import java.io.IOException;

public abstract class PathCanonicalizationStrategy {
    private static PathCanonicalizationStrategy instance;

    static {
        PathCanonicalizationStrategy.setPathCanonicalization(true);
    }

    public static String getCanonicalPath(File file) {
        return PathCanonicalizationStrategy.getInstance().getCanonicalPathInternal(file);
    }

    public static synchronized void setPathCanonicalization(boolean canonicalize) {
        instance = canonicalize ? new PathCanonicalizationStrategy(){

            @Override
            protected String getCanonicalPathInternal(File file) {
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return file.getAbsolutePath();
                }
            }
        } : new PathCanonicalizationStrategy(){

            @Override
            protected String getCanonicalPathInternal(File file) {
                return file.getAbsolutePath();
            }
        };
    }

    private static synchronized PathCanonicalizationStrategy getInstance() {
        return instance;
    }

    protected abstract String getCanonicalPathInternal(File var1);
}

