/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.ptp.internal.rdt.core.miners.SemanticHighlighting;
import org.eclipse.ptp.internal.rdt.core.miners.SemanticHighlightings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionCollector
extends CPPASTVisitor {
    protected SemanticHighlighting[] fJobSemanticHighlightings;
    ArrayList<ArrayList<Integer>> positionList = new ArrayList();
    private SemanticToken fToken = new SemanticToken();
    private int fMinLocation;

    public PositionCollector(boolean visitImplicitNames) {
        this.fJobSemanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        this.includeInactiveNodes = true;
        this.fMinLocation = -1;
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitImplicitNames = visitImplicitNames;
        this.shouldVisitImplicitNameAlternates = visitImplicitNames;
    }

    public int leave(IASTDeclaration declaration) {
        return 3;
    }

    public int visit(IASTTranslationUnit tu) {
        IASTPreprocessorMacroExpansion[] macroExps;
        IASTPreprocessorMacroDefinition[] macroDefs;
        IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = macroDefs = tu.getMacroDefinitions();
        int n = macroDefs.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorMacroDefinition macroDef = iASTPreprocessorMacroDefinitionArray[n2];
            if (macroDef.isPartOfTranslationUnitFile()) {
                this.visitNode((IASTNode)macroDef.getName());
            }
            ++n2;
        }
        this.fMinLocation = -1;
        IASTPreprocessorMacroExpansion[] iASTPreprocessorMacroExpansionArray = macroExps = tu.getMacroExpansions();
        int n3 = macroExps.length;
        n = 0;
        while (n < n3) {
            IASTPreprocessorMacroExpansion macroExp = iASTPreprocessorMacroExpansionArray[n];
            if (macroExp.isPartOfTranslationUnitFile()) {
                IASTName[] nestedMacroRefs;
                IASTName macroRef = macroExp.getMacroReference();
                this.visitNode((IASTNode)macroRef);
                IASTName[] iASTNameArray = nestedMacroRefs = macroExp.getNestedMacroReferences();
                int n4 = nestedMacroRefs.length;
                int n5 = 0;
                while (n5 < n4) {
                    IASTName nestedMacroRef = iASTNameArray[n5];
                    this.visitNode((IASTNode)nestedMacroRef);
                    ++n5;
                }
            }
            ++n;
        }
        this.fMinLocation = -1;
        return super.visit(tu);
    }

    public int visit(IASTDeclaration declaration) {
        if (!declaration.isPartOfTranslationUnitFile()) {
            return 1;
        }
        return 3;
    }

    public int visit(ICPPASTNamespaceDefinition namespace) {
        if (!namespace.isPartOfTranslationUnitFile()) {
            return 1;
        }
        return 3;
    }

    public int visit(IASTDeclarator declarator) {
        return 3;
    }

    public int visit(IASTStatement statement) {
        return 3;
    }

    public int visit(IASTName name) {
        if (this.visitNode((IASTNode)name)) {
            return 1;
        }
        return 3;
    }

    private boolean visitNode(IASTNode node) {
        boolean consumed = false;
        this.fToken.update(node);
        int i = 0;
        int n = this.fJobSemanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = this.fJobSemanticHighlightings[i];
            if (semanticHighlighting.consumes(this.fToken)) {
                if (node instanceof IASTName) {
                    this.addNameLocation((IASTName)node, i);
                } else {
                    this.addNodeLocation((IASTNodeLocation)node.getFileLocation(), i);
                }
                consumed = true;
                break;
            }
            ++i;
        }
        this.fToken.clear();
        return consumed;
    }

    private void addNameLocation(IASTName name, int highlightingStyleIndex) {
        IASTImageLocation imageLocation = name.getImageLocation();
        if (imageLocation != null) {
            int offset;
            if (imageLocation.getLocationKind() != 2 && (offset = imageLocation.getNodeOffset()) >= this.fMinLocation) {
                int length = imageLocation.getNodeLength();
                if (offset > -1 && length > 0) {
                    this.fMinLocation = offset + length;
                    this.addPosition(offset, length, highlightingStyleIndex);
                }
            }
        } else {
            IASTNodeLocation[] nodeLocations = name.getNodeLocations();
            if (nodeLocations.length == 1 && !(nodeLocations[0] instanceof IASTMacroExpansionLocation)) {
                this.addNodeLocation(nodeLocations[0], highlightingStyleIndex);
            }
        }
    }

    private void addNodeLocation(IASTNodeLocation nodeLocation, int highlightingStyleIndex) {
        if (nodeLocation == null) {
            return;
        }
        int offset = nodeLocation.getNodeOffset();
        if (offset >= this.fMinLocation) {
            int length = nodeLocation.getNodeLength();
            if (offset > -1 && length > 0) {
                this.fMinLocation = offset + length;
                this.addPosition(offset, length, highlightingStyleIndex);
            }
        }
    }

    private void addPosition(int offset, int length, int highlightingStyleIndex) {
        ArrayList<Integer> u = new ArrayList<Integer>();
        u.addAll(Arrays.asList(offset, length, highlightingStyleIndex));
        this.positionList.add(u);
    }

    public ArrayList<ArrayList<Integer>> getPositions() {
        return this.positionList;
    }

    public final class SemanticToken {
        private IASTNode fNode;
        private IBinding fBinding;
        private boolean fIsBindingResolved = false;
        private IASTTranslationUnit fRoot;
        private boolean fIsRootResolved = false;

        public IBinding getBinding() {
            if (!this.fIsBindingResolved) {
                this.fIsBindingResolved = true;
                if (this.fNode instanceof IASTName) {
                    this.fBinding = ((IASTName)this.fNode).resolveBinding();
                }
            }
            return this.fBinding;
        }

        public IASTNode getNode() {
            return this.fNode;
        }

        public IASTTranslationUnit getRoot() {
            if (!this.fIsRootResolved) {
                this.fIsRootResolved = true;
                if (this.fNode != null) {
                    this.fRoot = this.fNode.getTranslationUnit();
                }
            }
            return this.fRoot;
        }

        public void update(IASTNode node) {
            this.clear();
            this.fNode = node;
        }

        public void clear() {
            this.fNode = null;
            this.fBinding = null;
            this.fIsBindingResolved = false;
            this.fRoot = null;
            this.fIsRootResolved = false;
        }
    }
}

