/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.attributes.NodeAttributes;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.elements.listeners.INodeChildListener;
import org.eclipse.ptp.core.elements.listeners.INodeListener;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ChangedProcessEvent;
import org.eclipse.ptp.internal.core.elements.events.NewProcessEvent;
import org.eclipse.ptp.internal.core.elements.events.NodeChangeEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveProcessEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNode
extends Parent
implements IPNode,
IJobChildListener {
    private final ListenerList childListeners = new ListenerList();
    private final ListenerList elementListeners = new ListenerList();
    private final Map<IPJob, BitSet> jobProcessRanksMap = new HashMap<IPJob, BitSet>();

    public PNode(String id, IPMachine mac, IAttribute<?, ?, ?>[] attrs) {
        super(id, mac, attrs);
        IAttribute nodeState = (EnumeratedAttribute)this.getAttribute(NodeAttributes.getStateAttributeDefinition());
        if (nodeState == null) {
            nodeState = NodeAttributes.getStateAttributeDefinition().create();
            this.addAttribute(nodeState);
        }
    }

    @Override
    public void addChildListener(INodeChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    @Override
    public void addElementListener(INodeListener listener) {
        this.elementListeners.add((Object)listener);
    }

    @Override
    public void addJobProcessRanks(IPJob job, BitSet processRanks) {
        BitSet jobProcessRanks = this.jobProcessRanksMap.get(job);
        if (jobProcessRanks == null) {
            jobProcessRanks = new BitSet();
            this.jobProcessRanksMap.put(job, jobProcessRanks);
        }
        jobProcessRanks.or(processRanks);
        job.addChildListener(this);
        this.fireNewProcesses(job, processRanks);
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        this.fireChangedNode(attrs);
    }

    private void fireChangedNode(AttributeManager attrs) {
        NodeChangeEvent e = new NodeChangeEvent(this, attrs);
        Object[] objectArray = this.elementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireChangedProcesses(IPJob job, BitSet processes, AttributeManager attrManager) {
        ChangedProcessEvent e = new ChangedProcessEvent(this, job, processes, attrManager);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireNewProcesses(IPJob job, BitSet processes) {
        NewProcessEvent e = new NewProcessEvent(this, job, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireRemoveProcesses(IPJob job, BitSet processes) {
        RemoveProcessEvent e = new RemoveProcessEvent(this, job, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    @Override
    public BitSet getJobProcessRanks(IPJob job) {
        return (BitSet)this.jobProcessRanksMap.get(job).clone();
    }

    @Override
    public Set<? extends IPJob> getJobs() {
        return Collections.unmodifiableSet(this.jobProcessRanksMap.keySet());
    }

    @Override
    public IPMachine getMachine() {
        IPElement current = this;
        do {
            if (!(current instanceof IPMachine)) continue;
            return (IPMachine)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public String getNodeNumber() {
        IntegerAttribute num = (IntegerAttribute)this.getAttribute(NodeAttributes.getNumberAttributeDefinition());
        if (num != null) {
            return num.getValueAsString();
        }
        return "";
    }

    @Override
    public NodeAttributes.State getState() {
        return (NodeAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(NodeAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public void handleEvent(IChangedProcessEvent e) {
        this.fireChangedProcesses((IPJob)e.getSource(), e.getProcesses(), e.getAttributes());
    }

    @Override
    public void handleEvent(INewProcessEvent e) {
    }

    @Override
    public void handleEvent(IRemoveProcessEvent e) {
        this.removeJobProcessRanks(e.getJob(), e.getProcesses());
    }

    @Override
    public void removeChildListener(INodeChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    @Override
    public void removeElementListener(INodeListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    @Override
    public void removeJobProcessRanks(IPJob job, BitSet ranks) {
        BitSet jobProcessRanks = this.jobProcessRanksMap.get(job);
        if (jobProcessRanks == null) {
            PTPCorePlugin.log(String.valueOf(Messages.PNode_1) + job.getName());
        } else {
            jobProcessRanks.andNot(ranks);
        }
        this.fireRemoveProcesses(job, ranks);
    }
}

