/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.internal.core.elements.PResourceManager;
import org.eclipse.ptp.internal.core.elements.Parent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PUniverse
extends Parent
implements IPUniverse {
    private static final int RMID_SHIFT = 24;
    private int nextResourceManagerId = 1;
    private final Map<String, IPResourceManager> resourceManagers = Collections.synchronizedMap(new HashMap());
    protected String NAME_TAG = "universe ";

    private static IAttribute<?, ?, ?>[] getDefaultAttributes(String name) {
        StringAttribute nameAttr = ElementAttributes.getNameAttributeDefinition().create(name);
        return new IAttribute[]{nameAttr};
    }

    public PUniverse() {
        super("1", null, PUniverse.getDefaultAttributes("TheUniverse"));
    }

    @Override
    public IPResourceManager addResourceManager(String name, String controlId) {
        PResourceManager rm = new PResourceManager(ModelManager.getInstance().getUniverse(), name, controlId);
        this.resourceManagers.put(controlId, rm);
        return rm;
    }

    @Override
    public IPJob getJob(IJobControl control, String jobId) {
        IPResourceManager rm = this.getResourceManager(control.getControlId());
        if (rm != null) {
            return rm.getJobById(jobId);
        }
        return null;
    }

    @Override
    public IPJob getJob(IJobStatus status) {
        IPResourceManager rm = this.getResourceManager(status.getControlId());
        if (rm != null) {
            return rm.getJobById(status.getControlId());
        }
        return null;
    }

    @Override
    public synchronized String getNextResourceManagerId() {
        return Integer.toString(this.nextResourceManagerId++ << 24);
    }

    @Override
    public IPNode getNode(IJobControl control, String nodeId) {
        IPResourceManager rm = this.getResourceManager(control.getControlId());
        if (rm != null) {
            return rm.getNodeById(nodeId);
        }
        return null;
    }

    @Override
    public IPResourceManager getResourceManager(String controlId) {
        return this.resourceManagers.get(controlId);
    }

    @Override
    public IPResourceManager[] getResourceManagers() {
        return this.resourceManagers.values().toArray(new IPResourceManager[0]);
    }

    @Override
    public void removeResourceManager(String controlId) {
        this.resourceManagers.remove(controlId);
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
    }
}

