/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.AbstractJobSubmission;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributeManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerControl;
import org.eclipse.ptp.rtsystem.AbstractRuntimeResourceManager;
import org.eclipse.ptp.rtsystem.AbstractRuntimeResourceManagerMonitor;
import org.eclipse.ptp.rtsystem.IRuntimeEventListener;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeAttributeDefinitionEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeConnectedStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeErrorStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeJobChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMachineChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMessageEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeProcessChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeQueueChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRMChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveAllEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRunningStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeShutdownStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeStartupErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeSubmitJobErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeTerminateJobErrorEvent;
import org.eclipse.ptp.utils.core.RangeSet;

@Deprecated
public abstract class AbstractRuntimeResourceManagerControl
extends AbstractResourceManagerControl
implements IRuntimeEventListener {
    private final Map<String, JobSubmission> jobSubmissions = Collections.synchronizedMap(new HashMap());
    private final Map<String, IJobStatus> fJobStatus = new HashMap<String, IJobStatus>();
    private volatile int jobSubIdCounter = 0;

    public AbstractRuntimeResourceManagerControl(AbstractResourceManagerConfiguration config) {
        super(config);
    }

    public void handleEvent(IRuntimeAttributeDefinitionEvent e) {
    }

    public void handleEvent(IRuntimeConnectedStateEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(IRuntimeErrorStateEvent e) {
        Map<String, JobSubmission> map = this.jobSubmissions;
        synchronized (map) {
            for (JobSubmission sub : this.jobSubmissions.values()) {
                sub.setError(Messages.AbstractRuntimeResourceManager_6);
            }
            this.jobSubmissions.clear();
        }
    }

    public void handleEvent(IRuntimeJobChangeEvent e) {
    }

    public void handleEvent(IRuntimeMachineChangeEvent e) {
    }

    public void handleEvent(IRuntimeMessageEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(IRuntimeNewJobEvent e) {
        ElementAttributeManager mgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
            AttributeManager jobAttrs = entry.getValue();
            for (String elementId : entry.getKey()) {
                JobSubmission sub;
                StringAttribute jobSubAttr = (StringAttribute)jobAttrs.getAttribute(JobAttributes.getSubIdAttributeDefinition());
                if (jobSubAttr == null) continue;
                Map<String, JobSubmission> map = this.jobSubmissions;
                synchronized (map) {
                    sub = this.jobSubmissions.remove(jobSubAttr.getValue());
                }
                if (sub == null) continue;
                sub.setJobId(elementId);
                sub.setStatus(AbstractJobSubmission.JobSubStatus.SUBMITTED);
            }
        }
    }

    public void handleEvent(IRuntimeNewMachineEvent e) {
    }

    public void handleEvent(IRuntimeNewNodeEvent e) {
    }

    public void handleEvent(IRuntimeNewProcessEvent e) {
    }

    public void handleEvent(IRuntimeNewQueueEvent e) {
    }

    public void handleEvent(IRuntimeNodeChangeEvent e) {
    }

    public void handleEvent(IRuntimeProcessChangeEvent e) {
    }

    public void handleEvent(IRuntimeQueueChangeEvent e) {
    }

    public void handleEvent(IRuntimeRemoveAllEvent e) {
        this.cleanUp();
    }

    public void handleEvent(IRuntimeRemoveJobEvent e) {
    }

    public void handleEvent(IRuntimeRemoveMachineEvent e) {
    }

    public void handleEvent(IRuntimeRemoveNodeEvent e) {
    }

    public void handleEvent(IRuntimeRemoveProcessEvent e) {
    }

    public void handleEvent(IRuntimeRemoveQueueEvent e) {
    }

    public void handleEvent(IRuntimeRMChangeEvent e) {
    }

    public void handleEvent(IRuntimeRunningStateEvent e) {
    }

    public void handleEvent(IRuntimeShutdownStateEvent e) {
        this.cleanUp();
    }

    public void handleEvent(IRuntimeStartupErrorEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(IRuntimeSubmitJobErrorEvent e) {
        if (e.getJobSubID() != null) {
            JobSubmission sub;
            Map<String, JobSubmission> map = this.jobSubmissions;
            synchronized (map) {
                sub = this.jobSubmissions.remove(e.getJobSubID());
            }
            if (sub != null) {
                sub.setError(e.getErrorMessage());
            }
        }
    }

    public void handleEvent(IRuntimeTerminateJobErrorEvent e) {
        IPJob job = this.getPResourceManager().getJobById(e.getJobID());
        String name = e.getJobID();
        if (job != null) {
            name = job.getName();
        }
        this.getResourceManager().fireResourceManagerError(NLS.bind((String)Messages.AbstractRuntimeResourceManager_4, (Object[])new Object[]{name, e.getErrorMessage()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        Map<String, Object> map = this.jobSubmissions;
        synchronized (map) {
            for (JobSubmission sub : this.jobSubmissions.values()) {
                sub.setStatus(AbstractJobSubmission.JobSubStatus.CANCELLED);
            }
            this.jobSubmissions.clear();
        }
        map = this.fJobStatus;
        synchronized (map) {
            this.fJobStatus.clear();
        }
    }

    private IPResourceManager getPResourceManager() {
        return ModelManager.getInstance().getUniverse().getResourceManager(this.getResourceManager().getUniqueName());
    }

    protected void doControlJob(String jobId, String operation, IProgressMonitor monitor) throws CoreException {
        if (!operation.equals("TERMINATE")) {
            throw new CoreException((IStatus)new Status(8, PTPCorePlugin.getUniqueIdentifier(), Messages.AbstractRuntimeResourceManager_operationNotSupported));
        }
        this.getRuntimeSystem().terminateJob(jobId);
    }

    protected void doDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IJobStatus doGetJobStatus(String jobId, boolean force, IProgressMonitor monitor) throws CoreException {
        Map<String, IJobStatus> map = this.fJobStatus;
        synchronized (map) {
            return this.fJobStatus.get(jobId);
        }
    }

    protected void doShutdown() throws CoreException {
        this.getRuntimeSystem().removeRuntimeEventListener(this);
        this.cleanUp();
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        this.getRuntimeSystem().addRuntimeEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IJobStatus doSubmitJob(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IJobStatus jobStatus = null;
        try {
            JobSubmission sub = new JobSubmission(this.jobSubIdCounter++, configuration);
            Map<String, JobSubmission> map = this.jobSubmissions;
            synchronized (map) {
                this.jobSubmissions.put(sub.getId(), sub);
            }
            this.getRuntimeSystem().submitJob(sub.getId(), configuration, mode);
            AbstractJobSubmission.JobSubStatus state = sub.waitFor(monitor);
            switch (state) {
                case CANCELLED: {
                    Map<String, JobSubmission> map2 = this.jobSubmissions;
                    synchronized (map2) {
                        this.jobSubmissions.remove(sub.getId());
                    }
                    throw new CoreException((IStatus)new Status(8, PTPCorePlugin.getUniqueIdentifier(), Messages.AbstractRuntimeResourceManager_cancelled));
                }
                case SUBMITTED: {
                    jobStatus = sub.getJobStatus();
                    Map<String, IJobStatus> map3 = this.fJobStatus;
                    synchronized (map3) {
                        this.fJobStatus.put(jobStatus.getJobId(), jobStatus);
                        break;
                    }
                }
                case ERROR: {
                    throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), sub.getError()));
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        finally {
            monitor.done();
        }
        return jobStatus;
    }

    protected AbstractRuntimeResourceManager getResourceManager() {
        return (AbstractRuntimeResourceManager)super.getResourceManager();
    }

    protected IRuntimeSystem getRuntimeSystem() {
        return this.getResourceManager().getRuntimeSystem();
    }

    private class JobStatus
    implements IJobStatus {
        private IPJob fJob = null;
        private final String fJobId;
        private final ILaunchConfiguration fConfig;

        public JobStatus(String jobId, ILaunchConfiguration config) {
            this.fJobId = jobId;
            this.fConfig = config;
        }

        public String getControlId() {
            return AbstractRuntimeResourceManagerControl.this.getControlConfiguration().getUniqueName();
        }

        public String getErrorPath() {
            return null;
        }

        public String getJobId() {
            return this.fJobId;
        }

        public ILaunchConfiguration getLaunchConfiguration() {
            return this.fConfig;
        }

        public String getOutputPath() {
            return null;
        }

        public String getOwner() {
            return null;
        }

        public String getQueueName() {
            return null;
        }

        public String getState() {
            IPJob job = this.getJob();
            if (job != null) {
                switch (this.fJob.getState()) {
                    case COMPLETED: {
                        return "COMPLETED";
                    }
                    case RUNNING: {
                        return "RUNNING";
                    }
                    case STARTING: {
                        return "SUBMITTED";
                    }
                    case SUSPENDED: {
                        return "SUSPENDED";
                    }
                }
                return "UNDETERMINED";
            }
            return "UNDETERMINED";
        }

        public String getStateDetail() {
            StringAttribute statusAttr;
            IPJob job = this.getJob();
            if (job != null && (statusAttr = (StringAttribute)job.getAttribute(JobAttributes.getStatusAttributeDefinition())) != null) {
                return statusAttr.getValue();
            }
            return this.getState();
        }

        public IStreamsProxy getStreamsProxy() {
            AbstractRuntimeResourceManagerMonitor monitor = (AbstractRuntimeResourceManagerMonitor)AbstractRuntimeResourceManagerControl.this.getResourceManager().getMonitor();
            return monitor.getProxy(this.fJobId);
        }

        public boolean isInteractive() {
            return false;
        }

        private IPJob getJob() {
            if (this.fJob == null) {
                this.fJob = AbstractRuntimeResourceManagerControl.this.getPResourceManager().getJobById(this.fJobId);
            }
            return this.fJob;
        }
    }

    private class JobSubmission
    extends AbstractJobSubmission {
        private final ILaunchConfiguration fConfiguration;
        private IJobStatus fJobStatus;

        public JobSubmission(int count, ILaunchConfiguration configuration) {
            super(count);
            this.fJobStatus = null;
            this.fConfiguration = configuration;
        }

        public IJobStatus getJobStatus() {
            return this.fJobStatus;
        }

        public void setJobId(String jobId) {
            this.fJobStatus = new JobStatus(jobId, this.fConfiguration);
        }
    }
}

