/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.internal;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.ems.core.EnvManagerProjectProperties;
import org.eclipse.ptp.ems.core.EnvManagerRegistry;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.etfw.Activator;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.messages.Messages;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBuildLaunchUtils
implements IBuildLaunchUtils {
    Shell selshell = null;
    ILaunchConfiguration config;
    IRemoteConnection conn = null;
    IRemoteServices remoteServices = null;
    IRemoteUIServices remoteUIServices = null;
    IRemoteConnectionManager connMgr = null;
    IRemoteUIFileManager fileManagerUI = null;
    IRemoteFileManager fileManager = null;
    IEnvManagerConfig envMgrConfig = null;
    private IEnvManager envManager = null;

    public RemoteBuildLaunchUtils(ILaunchConfiguration config) {
        this.config = config;
        this.remoteServices = PTPRemoteUIPlugin.getDefault().getRemoteServices(LaunchUtils.getRemoteServicesId((ILaunchConfiguration)config), null);
        this.remoteUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.remoteServices);
        this.connMgr = this.remoteServices.getConnectionManager();
        this.conn = this.connMgr.getConnection(LaunchUtils.getConnectionName((ILaunchConfiguration)config));
        this.fileManagerUI = this.remoteUIServices.getUIFileManager();
        this.fileManager = this.remoteServices.getFileManager(this.conn);
        this.envMgrConfig = this.getEnvManagerConfig(config);
        if (this.envMgrConfig != null) {
            this.envManager = EnvManagerRegistry.getEnvManager(null, (IRemoteConnection)this.conn);
        }
    }

    @Override
    public String getWorkingDirectory() {
        return this.conn.getWorkingDirectory();
    }

    @Override
    public String findToolBinPath(String toolfind, String suggPath, String queryText, String queryMessage) {
        String vtbinpath = this.checkToolEnvPath(toolfind);
        if ((vtbinpath == null || vtbinpath.equals("")) && (vtbinpath = this.askToolPath(suggPath, queryText, queryMessage)) == null) {
            vtbinpath = "";
        }
        return vtbinpath;
    }

    @Override
    public String findToolBinPath(String toolfind, String suggPath, String toolName) {
        String vtbinpath = this.checkToolEnvPath(toolfind);
        if ((vtbinpath == null || vtbinpath.equals("")) && (vtbinpath = this.askToolPath(suggPath, toolName)) == null) {
            vtbinpath = "";
        }
        return vtbinpath;
    }

    @Override
    public String getToolPath(String toolID) {
        String toolBinID;
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        String path = pstore.getString(toolBinID = "performance_tool_bin_directory." + toolID + "." + LaunchUtils.getResourceManagerUniqueName((ILaunchConfiguration)this.config));
        if (path != null) {
            return path;
        }
        return "";
    }

    @Override
    public void getAllToolPaths(ExternalToolProcess[] tools, boolean force) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        int i = 0;
        while (i < tools.length) {
            for (Map.Entry me2 : tools[i].groupApp.entrySet()) {
                entry = (String)me2.getKey();
                if (entry.equals("internal")) continue;
                String toolBinID = "performance_tool_bin_directory." + entry + "." + LaunchUtils.getResourceManagerUniqueName((ILaunchConfiguration)this.config);
                if (!force && !pstore.getString(toolBinID).equals("")) continue;
                pstore.setValue(toolBinID, this.findToolBinPath((String)me2.getValue(), null, entry));
            }
            ++i;
        }
    }

    @Override
    public void verifyRequestToolPath(ExternalToolProcess tool, boolean force) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        for (Map.Entry me2 : tool.groupApp.entrySet()) {
            entry = (String)me2.getKey();
            if (entry.equals("internal")) continue;
            String toolBinID = "performance_tool_bin_directory." + entry + "." + LaunchUtils.getResourceManagerUniqueName((ILaunchConfiguration)this.config);
            if (!force && !pstore.getString(toolBinID).equals("")) continue;
            pstore.setValue(toolBinID, this.findToolBinPath((String)me2.getValue(), null, entry));
        }
    }

    public void verifyEnvToolPath(ExternalToolProcess tool) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        String toolBinID = null;
        String curTool = null;
        for (Map.Entry me2 : tool.groupApp.entrySet()) {
            String gVal;
            entry = (String)me2.getKey();
            if (entry.equals("internal")) continue;
            toolBinID = "performance_tool_bin_directory." + entry + "." + LaunchUtils.getResourceManagerUniqueName((ILaunchConfiguration)this.config);
            curTool = pstore.getString(toolBinID);
            IFileStore ttool = this.fileManager.getResource(curTool);
            if (curTool != null && !curTool.equals("") && ttool.fetchInfo().exists() || (gVal = (String)me2.getValue()) == null || gVal.trim().length() <= 0 || (curTool = this.checkToolEnvPath(gVal)) == null) continue;
            pstore.setValue(toolBinID, curTool);
        }
    }

    private IEnvManagerConfig getEnvManagerConfig(ILaunchConfiguration configuration) {
        try {
            EnvManagerProjectProperties projectProperties;
            IProject project;
            String projectName = configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
            if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && (projectProperties = new EnvManagerProjectProperties(project)).isEnvMgmtEnabled()) {
                return projectProperties;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String checkToolEnvPath(String toolname) {
        if (Platform.getOS().toLowerCase().trim().indexOf("win") >= 0) {
            return null;
        }
        String pPath = null;
        try {
            IRemoteProcessBuilder rpb = this.remoteServices.getProcessBuilder(this.conn, new String[0]);
            if (this.envManager != null) {
                String com = "";
                try {
                    com = this.envManager.createBashScript(null, false, this.envMgrConfig, "which " + toolname);
                    IFileStore envScript = this.fileManager.getResource(com);
                    IFileInfo envInfo = envScript.fetchInfo();
                    envInfo.setAttribute(0x1000000, true);
                    envScript.putInfo(envInfo, 1024, null);
                }
                catch (RemoteConnectionException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                rpb.command(new String[]{com});
            } else {
                rpb.command(new String[]{"which", toolname});
            }
            IRemoteProcess p = rpb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while (true) {
                if ((line = reader.readLine()) == null) {
                    reader.close();
                    reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while ((line = reader.readLine()) != null) {
                    }
                    break;
                }
                IFileStore test = this.fileManager.getResource(line);
                if (!test.fetchInfo().exists()) continue;
                pPath = line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (pPath == null) {
            return null;
        }
        IFileStore test = this.fileManager.getResource(pPath);
        String name = test.fetchInfo().getName();
        if (!name.equals(toolname)) {
            return null;
        }
        if (test.fetchInfo().exists()) {
            return test.getParent().toURI().getPath();
        }
        return null;
    }

    @Override
    public String askToolPath(String archpath, String toolText, String toolMessage) {
        if (this.selshell == null) {
            return null;
        }
        return this.fileManagerUI.browseDirectory(this.selshell, toolMessage, archpath, 0);
    }

    @Override
    public String askToolPath(String archpath, String toolName) {
        return this.askToolPath(archpath, String.valueOf(Messages.BuildLaunchUtils_Select) + toolName + Messages.BuildLaunchUtils_BinDir, String.valueOf(Messages.BuildLaunchUtils_PleaseSelectDir) + toolName);
    }

    public static String getNow() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(cal.getTime());
    }

    @Override
    public boolean runTool(List<String> tool, Map<String, String> env, String directory) {
        return this.runTool(tool, env, directory, null);
    }

    @Override
    public IFileStore getFile(String path) {
        return this.fileManager.getResource(path);
    }

    @Override
    public boolean runTool(List<String> tool, Map<String, String> env, String directory, String output) {
        int eval = -1;
        try {
            OutputStream fos = null;
            if (output != null) {
                IFileStore test = this.fileManager.getResource(output);
                IFileStore parent = test.getParent();
                if (parent == null || !parent.fetchInfo().exists()) {
                    parent = this.fileManager.getResource(directory);
                    test = parent.getChild(output);
                }
                fos = test.openOutputStream(0, null);
            }
            IRemoteProcess p = this.getProcess(tool, env, directory, false);
            StreamRunner outRun = new StreamRunner(p.getInputStream(), "out", fos);
            StreamRunner errRun = new StreamRunner(p.getErrorStream(), "err", null);
            outRun.start();
            errRun.start();
            outRun.join();
            eval = p.waitFor();
            if (fos != null) {
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return eval == 0;
    }

    @Override
    public byte[] runToolGetOutput(List<String> tool, Map<String, String> env, String directory) {
        return this.runToolGetOutput(tool, env, directory, false);
    }

    @Override
    public byte[] runToolGetOutput(List<String> tool, Map<String, String> env, String directory, boolean showErr) {
        int eval = -1;
        byte[] out = null;
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            IRemoteProcess p = this.getProcess(tool, env, directory, showErr);
            StreamRunner outRun = new StreamRunner(p.getInputStream(), "out", fos);
            StreamRunner errRun = null;
            errRun = new StreamRunner(p.getErrorStream(), "err", null);
            outRun.start();
            errRun.start();
            outRun.join();
            eval = p.waitFor();
            if (fos != null) {
                fos.flush();
                out = fos.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (eval != 0) {
            return null;
        }
        return out;
    }

    private IRemoteProcess getProcess(List<String> tool, Map<String, String> env, String directory, boolean mergeOutput) throws IOException {
        IRemoteProcessBuilder pb;
        if (this.envManager != null) {
            String com = "";
            String concat = "";
            try {
                concat = "";
                int i = 0;
                while (i < tool.size()) {
                    concat = String.valueOf(concat) + " " + tool.get(i);
                    ++i;
                }
                com = this.envManager.createBashScript(null, false, this.envMgrConfig, concat);
                IFileStore envScript = this.fileManager.getResource(com);
                IFileInfo envInfo = envScript.fetchInfo();
                envInfo.setAttribute(0x1000000, true);
                envScript.putInfo(envInfo, 1024, null);
            }
            catch (RemoteConnectionException e) {
                e.printStackTrace();
                return null;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            pb = this.remoteServices.getProcessBuilder(this.conn, new String[]{concat});
        } else {
            pb = this.remoteServices.getProcessBuilder(this.conn, tool);
        }
        if (directory != null) {
            pb.directory(this.fileManager.getResource(directory));
        }
        if (env != null) {
            pb.environment().putAll(env);
        }
        pb.redirectErrorStream(mergeOutput);
        return pb.start();
    }

    @Override
    public void runVis(List<String> tool, Map<String, String> env, String directory) {
        try {
            if (env == null) {
                env = new HashMap<String, String>();
            }
            if (env.get("DISPLAY") == null) {
                env.put("DISPLAY", ":0.0");
            }
            this.getProcess(tool, env, directory, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    static class StreamRunner
    extends Thread {
        InputStream is;
        OutputStream os;
        String type;

        StreamRunner(InputStream is, String type, OutputStream os) {
            this.is = is;
            this.os = os;
            this.type = type;
        }

        public void run() {
            try {
                PrintWriter pw = null;
                if (this.os != null) {
                    pw = new PrintWriter(this.os);
                }
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (pw != null) {
                        pw.println(line);
                        continue;
                    }
                    System.out.println(line);
                }
                if (pw != null) {
                    pw.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

