/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.preferences;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.etfw.Activator;
import org.eclipse.ptp.etfw.messages.Messages;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class ToolLocationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String EMPTY_STRING = "";
    BinDirPanel[] toolGroups = null;
    protected WidgetListener listener = new WidgetListener();

    public ToolLocationPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        Iterator eIt = null;
        String me = null;
        ExternalToolProcess[] tools = Activator.getTools();
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        int i = 0;
        while (i < tools.length) {
            eIt = tools[i].groupApp.entrySet().iterator();
            while (eIt.hasNext()) {
                me = ((String)eIt.next().getKey()).toString();
                if (me.equals("internal")) continue;
                groups.add(me);
            }
            ++i;
        }
        this.toolGroups = new BinDirPanel[groups.size()];
        Iterator gIt = groups.iterator();
        int i2 = 0;
        while (gIt.hasNext()) {
            this.toolGroups[i2] = new BinDirPanel((String)gIt.next());
            ++i2;
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        this.createTauConf(composite);
        this.loadSaved();
        this.defaultSetting();
        return composite;
    }

    private void createTauConf(Composite parent) {
        Group aGroup = new Group(parent, 16);
        aGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        aGroup.setLayoutData((Object)this.spanGridData(768, 2));
        aGroup.setText(Messages.ToolLocationPreferencePage_ToolLocationConf);
        if (this.toolGroups != null) {
            int i = 0;
            while (i < this.toolGroups.length) {
                this.toolGroups[i].makeToolBinPane((Composite)aGroup);
                ++i;
            }
        }
    }

    protected void handleBinBrowseButtonSelected(Text field, String group) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        IFileStore path = null;
        String correctPath = this.getFieldContent(field.getText());
        if (correctPath != null && (path = EFS.getLocalFileSystem().getStore((IPath)new Path(correctPath))).fetchInfo().exists()) {
            dialog.setFilterPath(!path.fetchInfo().isDirectory() ? correctPath : path.getParent().toURI().getPath());
        }
        dialog.setText(String.valueOf(Messages.ToolLocationPreferencePage_Select) + group + Messages.ToolLocationPreferencePage_BinDirectory);
        String selectedPath = dialog.open();
        if (selectedPath != null) {
            field.setText(selectedPath);
        }
    }

    private void loadSaved() {
        IPreferencesService service = Platform.getPreferencesService();
        if (this.toolGroups != null) {
            int i = 0;
            while (i < this.toolGroups.length) {
                this.toolGroups[i].binDir.setText(service.getString("org.eclipse.ptp.etfw", "performance_tool_bin_directory." + this.toolGroups[i].group, EMPTY_STRING, null));
                ++i;
            }
        }
    }

    public boolean performOk() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ptp.etfw");
        if (this.toolGroups != null) {
            int i = 0;
            while (i < this.toolGroups.length) {
                preferences.put("performance_tool_bin_directory." + this.toolGroups[i].group, this.toolGroups[i].binDir.getText());
                ++i;
            }
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    public void init(IWorkbench workbench) {
    }

    protected void defaultSetting() {
    }

    public void dispose() {
        super.dispose();
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setValid(true);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    private class BinDirPanel {
        String group = "";
        Button browseBinButton = null;
        Text binDir = null;
        BinListener binLis = new BinListener();

        private void makeToolBinPane(Composite parent) {
            Composite tauarch = new Composite(parent, 0);
            tauarch.setLayout((Layout)ToolLocationPreferencePage.this.createGridLayout(3, false, 0, 0));
            tauarch.setLayoutData((Object)ToolLocationPreferencePage.this.spanGridData(768, 5));
            Label taubinComment = new Label(tauarch, 64);
            taubinComment.setText(String.valueOf(this.group) + Messages.ToolLocationPreferencePage_BinDir);
            this.binDir = new Text(tauarch, 2052);
            this.binDir.setLayoutData((Object)new GridData(768));
            this.binDir.addModifyListener((ModifyListener)this.binLis);
            this.browseBinButton = new Button(tauarch, 8);
            this.browseBinButton.setText(Messages.ToolLocationPreferencePage_Browse);
            this.browseBinButton.addSelectionListener((SelectionListener)this.binLis);
        }

        public BinDirPanel(String group) {
            this.group = group;
        }

        protected class BinListener
        extends SelectionAdapter
        implements ModifyListener,
        IPropertyChangeListener {
            protected BinListener() {
            }

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (source == BinDirPanel.this.browseBinButton) {
                    ToolLocationPreferencePage.this.handleBinBrowseButtonSelected(BinDirPanel.this.binDir, BinDirPanel.this.group);
                }
                ToolLocationPreferencePage.this.updatePreferencePage();
            }

            public void modifyText(ModifyEvent evt) {
                Object source = evt.getSource();
                ToolLocationPreferencePage.this.updatePreferencePage();
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    ToolLocationPreferencePage.this.updatePreferencePage();
                }
            }
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ToolLocationPreferencePage.this.updatePreferencePage();
        }

        public void modifyText(ModifyEvent evt) {
            ToolLocationPreferencePage.this.updatePreferencePage();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                ToolLocationPreferencePage.this.updatePreferencePage();
            }
        }
    }
}

