/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.IMissingConnectionHandler;
import org.eclipse.ptp.rdt.sync.core.ISyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.core.ISyncListener;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.SyncEvent;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncRunner;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.osgi.service.prefs.Preferences;

public class SyncManager {
    private static final String projectScopeSyncNode = "org.eclipse.ptp.rdt.sync.core";
    private static final String instanceScopeSyncNode = "org.eclipse.ptp.rdt.sync.core";
    private static final String SYNC_MODE_KEY = "sync-mode";
    private static final String SYNC_AUTO_KEY = "sync-auto";
    private static final String SHOW_ERROR_KEY = "show-error";
    private static ISyncExceptionHandler defaultSyncExceptionHandler = new ISyncExceptionHandler(){

        @Override
        public void handle(IProject project, CoreException e) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.SyncManager_8) + project.getName(), e);
        }
    };
    private static IMissingConnectionHandler defaultMissingConnectionHandler = new IMissingConnectionHandler(){

        @Override
        public void handle(IRemoteServices remoteServices, String connectionName) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.SyncManager_10) + connectionName);
        }
    };
    private static final Map<IProject, Set<ISyncListener>> fProjectToSyncListenersMap = Collections.synchronizedMap(new HashMap());
    private static final SYNC_MODE DEFAULT_SYNC_MODE = SYNC_MODE.UNAVAILABLE;
    private static final boolean DEFAULT_SYNC_AUTO_SETTING = true;
    private static final boolean DEFAULT_SHOW_ERROR_SETTING = true;

    private SyncManager() {
    }

    public static SyncFileFilter getFileFilter(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return SyncManager.getDefaultFileFilter();
        }
        SyncFileFilter filter = SyncFileFilter.loadFilter((Preferences)node);
        if (filter == null) {
            return SyncManager.getDefaultFileFilter();
        }
        return filter;
    }

    public static SyncFileFilter getDefaultFileFilter() {
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_6);
            return SyncFileFilter.createBuiltInDefaultFilter();
        }
        SyncFileFilter filter = SyncFileFilter.loadFilter((Preferences)node);
        if (filter == null) {
            return SyncFileFilter.createBuiltInDefaultFilter();
        }
        return filter;
    }

    public static SYNC_MODE getSyncMode(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return DEFAULT_SYNC_MODE;
        }
        return SYNC_MODE.valueOf(node.get(SYNC_MODE_KEY, DEFAULT_SYNC_MODE.name()));
    }

    public static boolean getSyncAuto() {
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_6);
            return true;
        }
        return node.getBoolean(SYNC_AUTO_KEY, true);
    }

    public static boolean getShowErrors(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return true;
        }
        return node.getBoolean(SHOW_ERROR_KEY, true);
    }

    public static void setSyncMode(IProject project, SYNC_MODE mode) {
        if (project == null || mode == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return;
        }
        if (mode == DEFAULT_SYNC_MODE) {
            node.remove(SYNC_MODE_KEY);
        } else {
            node.put(SYNC_MODE_KEY, mode.name());
        }
        BuildConfigurationManager.flushNode((Preferences)node);
    }

    public static void setSyncAuto(boolean isSyncAutomatic) {
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_6);
            return;
        }
        if (isSyncAutomatic) {
            node.remove(SYNC_AUTO_KEY);
        } else {
            node.putBoolean(SYNC_AUTO_KEY, isSyncAutomatic);
        }
        BuildConfigurationManager.flushNode((Preferences)node);
    }

    public static void setShowErrors(IProject project, boolean shouldBeDisplayed) {
        if (project == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return;
        }
        if (shouldBeDisplayed) {
            node.remove(SHOW_ERROR_KEY);
        } else {
            node.putBoolean(SHOW_ERROR_KEY, shouldBeDisplayed);
        }
        BuildConfigurationManager.flushNode((Preferences)node);
    }

    public static void saveFileFilter(IProject project, SyncFileFilter filter) {
        if (project == null || filter == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return;
        }
        filter.saveFilter((Preferences)node);
        BuildConfigurationManager.flushNode((Preferences)node);
    }

    public static void saveDefaultFileFilter(SyncFileFilter filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_6);
            return;
        }
        filter.saveFilter((Preferences)node);
        BuildConfigurationManager.flushNode((Preferences)node);
    }

    public static Job sync(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, ISyncExceptionHandler seHandler) throws CoreException {
        return SyncManager.sync(delta, project, syncFlags, false, true, seHandler, null);
    }

    public static Job syncBlocking(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, IProgressMonitor monitor) throws CoreException {
        return SyncManager.sync(delta, project, syncFlags, true, false, null, monitor);
    }

    public static Job syncBlocking(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, IProgressMonitor monitor, ISyncExceptionHandler seHandler) throws CoreException {
        return SyncManager.sync(delta, project, syncFlags, true, true, seHandler, monitor);
    }

    private static Job sync(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, boolean isBlocking, boolean useExceptionHandler, ISyncExceptionHandler seHandler, IProgressMonitor monitor) throws CoreException {
        if (SyncManager.getSyncMode(project) == SYNC_MODE.UNAVAILABLE) {
            return null;
        }
        IConfiguration[] buildConfigurations = new IConfiguration[]{ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration()};
        Job[] syncJobs = SyncManager.scheduleSyncJobs(delta, project, syncFlags, buildConfigurations, isBlocking, useExceptionHandler, seHandler, monitor);
        return syncJobs[0];
    }

    public static Job[] syncAll(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, ISyncExceptionHandler seHandler) throws CoreException {
        if (SyncManager.getSyncMode(project) == SYNC_MODE.UNAVAILABLE) {
            return new Job[0];
        }
        return SyncManager.scheduleSyncJobs(delta, project, syncFlags, ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations(), false, true, seHandler, null);
    }

    private static Job[] scheduleSyncJobs(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, IConfiguration[] buildConfigurations, boolean isBlocking, boolean useExceptionHandler, ISyncExceptionHandler seHandler, IProgressMonitor monitor) throws CoreException {
        int jobNum = 0;
        Job[] syncJobs = new Job[buildConfigurations.length];
        IConfiguration[] iConfigurationArray = buildConfigurations;
        int n = buildConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizeJob job;
            block12: {
                IConfiguration buildConfig = iConfigurationArray[n2];
                job = null;
                BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
                BuildScenario buildScenario = bcm.getBuildScenarioForBuildConfiguration(buildConfig);
                SyncRunner syncRunner = bcm.getSyncRunnerForBuildConfiguration(buildConfig);
                if (syncRunner != null) {
                    if (isBlocking) {
                        try {
                            try {
                                syncRunner.synchronize(project, buildScenario, delta, SyncManager.getFileFilter(project), monitor, syncFlags);
                            }
                            catch (CoreException e) {
                                if (!useExceptionHandler) {
                                    throw e;
                                }
                                if (seHandler == null) {
                                    defaultSyncExceptionHandler.handle(project, e);
                                } else {
                                    seHandler.handle(project, e);
                                }
                                SyncManager.notifySyncListeners(project);
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            SyncManager.notifySyncListeners(project);
                            throw throwable;
                        }
                        SyncManager.notifySyncListeners(project);
                    } else {
                        job = new SynchronizeJob(project, buildScenario, delta, syncRunner, syncFlags, seHandler);
                        job.schedule();
                    }
                }
            }
            syncJobs[jobNum] = job;
            ++jobNum;
            ++n2;
        }
        return syncJobs;
    }

    public static ISyncExceptionHandler getDefaultSyncExceptionHandler() {
        return defaultSyncExceptionHandler;
    }

    public static void setDefaultSyncExceptionHandler(ISyncExceptionHandler handler) {
        defaultSyncExceptionHandler = handler;
    }

    public static IMissingConnectionHandler getDefaultMissingConnectionHandler() {
        return defaultMissingConnectionHandler;
    }

    public static void setDefaultMissingConnectionHandler(IMissingConnectionHandler handler) {
        defaultMissingConnectionHandler = handler;
    }

    public static void addPostSyncListener(IProject project, ISyncListener listener) {
        Set<ISyncListener> listenerSet = fProjectToSyncListenersMap.get(project);
        if (listenerSet == null) {
            listenerSet = new HashSet<ISyncListener>();
            fProjectToSyncListenersMap.put(project, listenerSet);
        }
        listenerSet.add(listener);
    }

    public static void removePostSyncListener(IProject project, ISyncListener listener) {
        Set<ISyncListener> listenerSet = fProjectToSyncListenersMap.get(project);
        if (listenerSet != null) {
            listenerSet.remove(listener);
        }
    }

    private static void notifySyncListeners(IProject project) {
        Set<ISyncListener> listenerSet = fProjectToSyncListenersMap.get(project);
        if (listenerSet == null) {
            return;
        }
        for (ISyncListener listener : listenerSet) {
            listener.handleSyncEvent(new SyncEvent());
        }
    }

    public static enum SYNC_MODE {
        ACTIVE,
        ALL,
        NONE,
        UNAVAILABLE;

    }

    private static class SynchronizeJob
    extends Job {
        private final IProject fProject;
        private final BuildScenario fBuildScenario;
        private final IResourceDelta fDelta;
        private final SyncRunner fSyncRunner;
        private final EnumSet<SyncFlag> fSyncFlags;
        private final ISyncExceptionHandler fSyncExceptionHandler;

        public SynchronizeJob(IProject project, BuildScenario buildScenario, IResourceDelta delta, SyncRunner runner, EnumSet<SyncFlag> syncFlags, ISyncExceptionHandler seHandler) {
            super(Messages.SyncManager_4);
            this.fProject = project;
            this.fBuildScenario = buildScenario;
            this.fDelta = delta;
            this.fSyncRunner = runner;
            this.fSyncFlags = syncFlags;
            this.fSyncExceptionHandler = seHandler;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                try {
                    this.fSyncRunner.synchronize(this.fProject, this.fBuildScenario, this.fDelta, SyncManager.getFileFilter(this.fProject), (IProgressMonitor)progress.newChild(100), this.fSyncFlags);
                }
                catch (CoreException e) {
                    if (this.fSyncExceptionHandler == null) {
                        defaultSyncExceptionHandler.handle(this.fProject, e);
                    } else {
                        this.fSyncExceptionHandler.handle(this.fProject, e);
                    }
                    monitor.done();
                    SyncManager.notifySyncListeners(this.fProject);
                }
            }
            finally {
                monitor.done();
                SyncManager.notifySyncListeners(this.fProject);
            }
            return Status.OK_STATUS;
        }
    }
}

