/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.data;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.rm.jaxb.control.internal.IAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.data.AddImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.AppendImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.PutImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.SetImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.ThrowImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.DebuggingLogger;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.JAXBCoreConstants;
import org.eclipse.ptp.rm.jaxb.core.data.AddType;
import org.eclipse.ptp.rm.jaxb.core.data.AppendType;
import org.eclipse.ptp.rm.jaxb.core.data.EntryType;
import org.eclipse.ptp.rm.jaxb.core.data.PutType;
import org.eclipse.ptp.rm.jaxb.core.data.SetType;
import org.eclipse.ptp.rm.jaxb.core.data.ThrowType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAssign
implements IAssign {
    protected String uuid = null;
    protected String field = null;
    protected Object target = null;
    protected int index = 0;
    protected boolean forceNew = false;
    protected IVariableMap rmVarMap;

    static void add(String uuid, Object assign, List<IAssign> list, IVariableMap rmVarMap) {
        if (assign instanceof AddType) {
            AddType add = (AddType)assign;
            list.add(new AddImpl(uuid, add, rmVarMap));
            return;
        }
        if (assign instanceof AppendType) {
            AppendType append = (AppendType)assign;
            list.add(new AppendImpl(uuid, append, rmVarMap));
            return;
        }
        if (assign instanceof PutType) {
            PutType put = (PutType)assign;
            list.add(new PutImpl(uuid, put, rmVarMap));
            return;
        }
        if (assign instanceof SetType) {
            SetType set = (SetType)assign;
            list.add(new SetImpl(uuid, set, rmVarMap));
            return;
        }
        if (assign instanceof ThrowType) {
            ThrowType thr = (ThrowType)assign;
            list.add(new ThrowImpl(uuid, thr, rmVarMap));
            return;
        }
    }

    static Object get(Object target, String field) throws Throwable {
        if (field == null) {
            return null;
        }
        String name = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
        Method method = null;
        try {
            method = target.getClass().getMethod(name, null);
        }
        catch (Throwable throwable) {
            name = "is" + field.substring(0, 1).toUpperCase() + field.substring(1);
            method = target.getClass().getMethod(name, null);
        }
        return method.invoke(target, null);
    }

    static Object normalizedValue(Object target, String uuid, String expression, boolean convert, IVariableMap map) throws Throwable {
        Object value = expression;
        if (expression.startsWith("#")) {
            if (target == null) {
                return null;
            }
            String field = expression.substring(1);
            value = AbstractAssign.get(target, field);
        } else if (expression.indexOf("${") >= 0) {
            expression = map.getString(uuid, expression);
            value = map.getString(uuid, expression);
        }
        if (convert) {
            return AbstractAssign.convert(value);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void set(Object target, String field, Object[] values) throws Throwable {
        String name = "set" + field.substring(0, 1).toUpperCase() + field.substring(1);
        Method[] methods = target.getClass().getMethods();
        Method setter = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name)) {
                setter = m;
            }
            ++n2;
        }
        if (setter == null) {
            throw new NoSuchMethodException(String.valueOf(name) + ":" + " " + target);
        }
        if (values != null && values[0] != null) {
            Class<?>[] mclzz = setter.getParameterTypes();
            Class<?> param = mclzz[0];
            Class<?> valueClass = values[0].getClass();
            IllegalArgumentException t = new IllegalArgumentException(String.valueOf(name) + " " + valueClass);
            if (!param.equals(Object.class) && !param.isAssignableFrom(values[0].getClass())) {
                if (valueClass.equals(String.class)) {
                    if (param.equals(Boolean.class)) {
                        values[0] = new Boolean(values[0].toString());
                    } else if (param.equals(Integer.class)) {
                        values[0] = new Integer(values[0].toString());
                    } else {
                        if (!param.equals(BigInteger.class)) throw t;
                        values[0] = new BigInteger(values[0].toString());
                    }
                } else {
                    if (!valueClass.equals(Integer.class) && !valueClass.equals(BigInteger.class) && !valueClass.equals(Boolean.class)) throw t;
                    if (!param.equals(String.class)) throw t;
                    values[0] = values[0].toString();
                }
            }
        }
        setter.invoke(target, values);
    }

    private static Object convert(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if ("true".equalsIgnoreCase(string)) {
                return true;
            }
            if ("false".equalsIgnoreCase(string)) {
                return false;
            }
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return value;
    }

    protected AbstractAssign(IVariableMap rmVarMap) {
        this.rmVarMap = rmVarMap;
    }

    @Override
    public void assign(String[] values) throws Throwable {
        Object previous = AbstractAssign.get(this.target, this.field);
        Object[] value = this.getValue(previous, values);
        AbstractAssign.set(this.target, this.field, value);
        ++this.index;
        DebuggingLogger.getLogger().logActionInfo(String.valueOf(Messages.AbstractAssign_0) + this + Messages.AbstractAssign_1 + this.target + Messages.AbstractAssign_2 + this.field + Messages.AbstractAssign_3 + Arrays.asList(value));
        DebuggingLogger.getLogger().logActionInfo(this + Messages.AbstractAssign_4 + this.index);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void incrementIndex(int increment) {
        this.index += increment;
    }

    @Override
    public boolean isForceNew() {
        return this.forceNew;
    }

    @Override
    public void setTarget(Object target) {
        this.target = target;
    }

    protected int determineKeyIndex(EntryType entry) {
        int index = entry.getKeyIndex();
        int group = entry.getKeyGroup();
        if (index == 0 && group != 0) {
            index = group;
        }
        return index;
    }

    protected int determineValueIndex(EntryType entry) {
        int index = entry.getValueIndex();
        int group = entry.getValueGroup();
        if (index == 0 && group != 0) {
            index = group;
        }
        return index;
    }

    protected String getKey(final EntryType entry, final String[] values) throws Throwable {
        String k = entry.getKey();
        if (k != null) {
            return (String)AbstractAssign.normalizedValue(this.target, this.uuid, k, false, this.rmVarMap);
        }
        int index = this.determineKeyIndex(entry);
        if (values != null) {
            if (index >= values.length) {
                new UIJob(Messages.BadEntryIndex){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.BadEntryIndex, (String)(String.valueOf(AbstractAssign.this.entryKeyInfo(entry)) + "," + " " + Arrays.asList(values)));
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            return values[index];
        }
        return null;
    }

    protected Object getValue(final EntryType entry, final String[] values) throws Throwable {
        String v = entry.getValue();
        if (v != null) {
            return AbstractAssign.normalizedValue(this.target, this.uuid, v, true, this.rmVarMap);
        }
        int index = this.determineValueIndex(entry);
        if (values != null) {
            if (index >= values.length) {
                new UIJob(Messages.BadEntryIndex){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.BadEntryIndex, (String)(String.valueOf(AbstractAssign.this.entryValueInfo(entry)) + "," + JAXBCoreConstants.LINE_SEP + values.length + Messages.AbstractAssign_9 + Arrays.asList(values)));
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            return values[index];
        }
        return null;
    }

    protected abstract Object[] getValue(Object var1, String[] var2) throws Throwable;

    private String entryKeyInfo(EntryType entry) {
        return "(" + Messages.AbstractAssign_5 + entry.getKeyGroup() + Messages.AbstractAssign_6 + entry.getKeyIndex() + ")";
    }

    private String entryValueInfo(EntryType entry) {
        return "(" + Messages.AbstractAssign_7 + entry.getValueGroup() + Messages.AbstractAssign_8 + entry.getValueIndex() + ")";
    }
}

