/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.runnable.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.jaxb.control.IJobController;
import org.eclipse.ptp.rm.jaxb.control.JAXBResourceManagerControl;
import org.eclipse.ptp.rm.jaxb.control.JAXBUtils;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.DebuggingLogger;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.SimpleCommandType;
import org.eclipse.ptp.utils.core.ArgumentParser;

public class SimpleCommandJob
extends Job {
    private final SimpleCommandType fCommand;
    private final IJobController fControl;
    private final IVariableMap fRmVarMap;
    private final int fFlags;
    private final String fUuid;
    private final String fDirectory;
    private IRemoteProcess fProcess;
    private IStatus fStatus;
    private boolean fActive;

    public SimpleCommandJob(String uuid, SimpleCommandType command, String directory, IJobController control) {
        super(command.getName() != null ? command.getName() : "Simple Command");
        this.fUuid = uuid;
        this.fCommand = command;
        this.fDirectory = command.getDirectory() != null ? command.getDirectory() : directory;
        this.fControl = control;
        this.fRmVarMap = this.fControl.getEnvironment();
        this.fFlags = this.getFlags(command.getFlags());
    }

    public IRemoteProcess getProcess() {
        return this.fProcess;
    }

    public IStatus getRunStatus() {
        return this.fStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        boolean b = false;
        SimpleCommandJob simpleCommandJob = this;
        synchronized (simpleCommandJob) {
            b = this.fActive;
        }
        return b;
    }

    public synchronized void terminate() {
        if (this.fActive) {
            this.fActive = false;
            if (this.fProcess != null && !this.fProcess.isCompleted()) {
                this.fProcess.destroy();
            }
            this.cancel();
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.fStatus = this.execute((IProgressMonitor)progress.newChild(50));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return this.fStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus execute(IProgressMonitor monitor) {
        SimpleCommandJob simpleCommandJob;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            simpleCommandJob = this;
            synchronized (simpleCommandJob) {
                this.fStatus = null;
                this.fActive = false;
            }
            IRemoteProcessBuilder builder = this.prepareCommand((IProgressMonitor)progress.newChild(10));
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.prepareEnv(builder);
            progress.worked(10);
            this.fProcess = null;
            try {
                this.fProcess = builder.start(this.fFlags);
            }
            catch (IOException t) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.CouldNotLaunch) + builder.command()), (Throwable)t);
            }
            progress.worked(30);
            SimpleCommandJob t = this;
            synchronized (t) {
                this.fActive = true;
            }
            progress.worked(20);
            if (DebuggingLogger.getLogger().getCommandOutput()) {
                final BufferedReader stdout = new BufferedReader(new InputStreamReader(this.fProcess.getInputStream()));
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = stdout.readLine()) != null) {
                                DebuggingLogger.getLogger().logCommandOutput(String.valueOf(SimpleCommandJob.this.getName()) + ": " + output);
                            }
                            stdout.close();
                        }
                        catch (IOException iOException) {}
                    }
                }, String.valueOf(this.getName()) + " stdout").start();
                final BufferedReader stderr = new BufferedReader(new InputStreamReader(this.fProcess.getErrorStream()));
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = stderr.readLine()) != null) {
                                DebuggingLogger.getLogger().logCommandOutput(String.valueOf(SimpleCommandJob.this.getName()) + ": " + output);
                            }
                            stderr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }, String.valueOf(this.getName()) + " stderr").start();
            }
            int exit = 0;
            while (!this.fProcess.isCompleted() && !progress.isCanceled()) {
                SimpleCommandJob simpleCommandJob2 = this;
                synchronized (simpleCommandJob2) {
                    try {
                        ((Object)((Object)this)).wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (progress.isCanceled()) {
                if (!this.fProcess.isCompleted()) {
                    this.fProcess.destroy();
                }
                return Status.CANCEL_STATUS;
            }
            progress.worked(20);
            if (!this.fCommand.isIgnoreExitStatus() && exit > 0) {
                throw CoreExceptionUtils.newException((String)(String.valueOf((String)builder.command().get(0)) + " " + Messages.ProcessExitValueError + exit), null);
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        catch (Throwable t) {
            return CoreExceptionUtils.getErrorStatus((String)Messages.ProcessRunError, (Throwable)t);
        }
        simpleCommandJob = this;
        synchronized (simpleCommandJob) {
            this.fActive = false;
        }
        return Status.OK_STATUS;
    }

    private int getFlags(String flags) {
        if (flags == null) {
            return 0;
        }
        String[] split = flags.split("[|]");
        int f = 0;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("ALLOCATE_PTY".equals(s = s.trim())) {
                f |= 1;
            } else if ("FORWARD_X11".equals(s)) {
                f |= 2;
            }
            ++n2;
        }
        return f;
    }

    private IRemoteProcessBuilder prepareCommand(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ArgumentParser args = new ArgumentParser(this.fRmVarMap.getString(this.fUuid, this.fCommand.getExec()));
        RemoteServicesDelegate delegate = JAXBUtils.getRemoteServicesDelegate(this.fControl.getRemoteServicesId(), this.fControl.getConnectionName(), (IProgressMonitor)progress.newChild(5));
        if (delegate.getRemoteConnection() == null) {
            throw CoreExceptionUtils.newException((String)Messages.MissingArglistFromCommandError, (Throwable)new Throwable(Messages.UninitializedRemoteServices));
        }
        if (progress.isCanceled()) {
            return null;
        }
        IRemoteConnection conn = delegate.getRemoteConnection();
        try {
            JAXBResourceManagerControl.checkConnection(conn, progress.newChild(5));
        }
        catch (RemoteConnectionException rce) {
            throw CoreExceptionUtils.newException((String)rce.getLocalizedMessage(), (Throwable)rce);
        }
        if (progress.isCanceled()) {
            return null;
        }
        if (DebuggingLogger.getLogger().getCommand()) {
            System.out.println(String.valueOf(this.getName()) + ": " + args.getCommandLine(false));
        }
        IRemoteProcessBuilder builder = delegate.getRemoteServices().getProcessBuilder(conn, args.getTokenList());
        if (this.fDirectory != null && !"".equals(this.fDirectory)) {
            String directory = this.fRmVarMap.getString(this.fUuid, this.fDirectory);
            IFileStore dir = delegate.getRemoteFileManager().getResource(directory);
            builder.directory(dir);
        }
        return builder;
    }

    private void prepareEnv(IRemoteProcessBuilder builder) throws CoreException {
        if (!this.fControl.getAppendEnv()) {
            builder.environment().clear();
        }
        Map<String, String> live = this.fControl.getLaunchEnv();
        for (String var : live.keySet()) {
            builder.environment().put(var, live.get(var));
        }
        builder.redirectErrorStream(this.fCommand.isRedirectStderr());
    }
}

