/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.monitor.ui.wizards;

import java.net.URI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.RemoteUIServicesUtils;
import org.eclipse.ptp.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.SiteType;
import org.eclipse.ptp.rm.lml.monitor.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.wizards.AbstractRemoteResourceManagerConfigurationWizardPage;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.swt.widgets.Composite;

public final class LMLRMMonitorConfigurationWizardPage
extends AbstractRemoteResourceManagerConfigurationWizardPage {
    public LMLRMMonitorConfigurationWizardPage(IRMConfigurationWizard wizard) {
        super(wizard, Messages.LMLRMMonitorConfigurationWizardPage_Title);
        this.setPageComplete(false);
        this.setTitle(Messages.LMLRMMonitorConfigurationWizardPage_Title);
        this.setDescription(Messages.LMLRMMonitorConfigurationWizardPage_Description);
        this.setEnableUseDefault(Messages.LMLRMMonitorConfigurationWizardPage_sameAsControl);
    }

    protected Composite doCreateContents(Composite parent) {
        Composite comp = super.doCreateContents(parent);
        try {
            SiteType site;
            ResourceManagerData data = this.getBaseConfiguration().getResourceManagerData();
            if (data != null && (site = this.getBaseConfiguration().getResourceManagerData().getSiteData()) != null && site.getMonitorConnection() != null && this.getConfiguration().getRemoteServicesId() == null) {
                URI uri = new URI(site.getMonitorConnection());
                IRemoteServices services = PTPRemoteUIPlugin.getDefault().getRemoteServices(uri, (IRunnableContext)this.getWizard().getContainer());
                if (services != null) {
                    this.getConfiguration().setRemoteServicesId(services.getId());
                    String auth = uri.getAuthority();
                    String host = uri.getHost();
                    String user = uri.getUserInfo();
                    int port = uri.getPort();
                    if (auth != null && host != null) {
                        IRemoteConnection conn = services.getConnectionManager().getConnection(host);
                        if (conn == null && services.canCreateConnections()) {
                            conn = services.getConnectionManager().newConnection(host);
                            conn.setAddress(host);
                            if (!auth.equals(host)) {
                                if (user != null) {
                                    conn.setUsername(user);
                                }
                                if (port != -1) {
                                    conn.setPort(port);
                                }
                            }
                        }
                        if (conn != null) {
                            this.getConfiguration().setConnectionName(conn.getName());
                            RemoteUIServicesUtils.setConnectionHints((RemoteConnectionWidget)this.connectionWidget, (IRemoteConnection)conn);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {}
        return comp;
    }

    protected IJAXBResourceManagerConfiguration getConfiguration() {
        return (IJAXBResourceManagerConfiguration)super.getConfiguration();
    }

    private IJAXBResourceManagerConfiguration getBaseConfiguration() {
        return (IJAXBResourceManagerConfiguration)((IRMConfigurationWizard)this.getWizard()).getBaseConfiguration();
    }
}

