/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.jaxb.control.IJobController;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatusMap;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.JobStatusMap;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.ManagedFilesJob;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.CommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.CommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.JobIdPinTable;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.control.runnable.ScriptHandler;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerControl;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.CommandType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFileType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFilesType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.ScriptType;
import org.eclipse.ptp.rm.jaxb.core.data.SiteType;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerControl;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBResourceManagerControl
extends AbstractResourceManagerControl
implements IJAXBResourceManagerControl,
IJobController {
    private final IJAXBResourceManagerConfiguration config;
    private IJAXBResourceManagerConfiguration baseConfig;
    private final ConnectionChangeListener connectionListener;
    private Map<String, String> launchEnv;
    private ICommandJob interactiveJob;
    private ICommandJobStatusMap jobStatusMap;
    private JobIdPinTable pinTable;
    private boolean appendLaunchEnv;
    private boolean isActive = false;
    private boolean isInitialized = false;

    public static void checkConnection(IRemoteConnection connection, SubMonitor progress) throws RemoteConnectionException {
        if (connection != null) {
            if (!connection.isOpen()) {
                connection.open((IProgressMonitor)progress.newChild(25));
                if (!connection.isOpen()) {
                    throw new RemoteConnectionException(String.valueOf(Messages.RemoteConnectionError) + connection.getAddress());
                }
            }
        } else {
            new RemoteConnectionException(String.valueOf(Messages.RemoteConnectionError) + connection);
        }
    }

    private static void checkJobForError(ICommandJob job) throws CoreException {
        IStatus status = job.getRunStatus();
        if (status != null && status.getSeverity() == 4) {
            Throwable t = status.getException();
            if (t instanceof CoreException) {
                throw (CoreException)t;
            }
            throw CoreExceptionUtils.newException((String)status.getMessage(), (Throwable)t);
        }
    }

    public JAXBResourceManagerControl(AbstractResourceManagerConfiguration jaxbServiceProvider) {
        super(jaxbServiceProvider);
        this.config = (IJAXBResourceManagerConfiguration)jaxbServiceProvider;
        this.connectionListener = new ConnectionChangeListener();
    }

    @Override
    public boolean getAppendEnv() {
        return this.appendLaunchEnv;
    }

    @Override
    public ResourceManagerData getConfiguration() {
        return this.getBaseConfiguration().getResourceManagerData();
    }

    private IJAXBResourceManagerConfiguration getBaseConfiguration() {
        if (this.baseConfig == null) {
            this.baseConfig = (IJAXBResourceManagerConfiguration)this.getResourceManager().getConfiguration();
        }
        return this.baseConfig;
    }

    @Override
    public String getConnectionName() {
        return this.config.getConnectionName();
    }

    public String getControlId() {
        return this.config.getUniqueName();
    }

    @Override
    public IVariableMap getEnvironment() {
        return this.getVarMap();
    }

    private RMVariableMap getVarMap() {
        return (RMVariableMap)this.getBaseConfiguration().getRMVariableMap();
    }

    @Override
    public synchronized ICommandJob getInteractiveJob() {
        return this.interactiveJob;
    }

    @Override
    public Map<String, String> getLaunchEnv() {
        return this.launchEnv;
    }

    public RemoteServicesDelegate getRemoteServicesDelegate(IProgressMonitor monitor) throws CoreException {
        return RemoteServicesDelegate.getDelegate((String)this.config.getRemoteServicesId(), (String)this.config.getConnectionName(), (IProgressMonitor)monitor);
    }

    @Override
    public String getRemoteServicesId() {
        return this.config.getRemoteServicesId();
    }

    public String getState() {
        return this.getResourceManager().getState();
    }

    @Override
    public ICommandJobStatusMap getStatusMap() {
        return this.jobStatusMap;
    }

    public void initialize(IProgressMonitor monitor) throws CoreException {
        block10: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                try {
                    String controlURI;
                    if (this.isInitialized) break block10;
                    SiteType site = this.getConfiguration().getSiteData();
                    if (site != null && (controlURI = site.getControlConnection()) != null) {
                        try {
                            IRemoteConnection remConn;
                            URI uri = new URI(controlURI);
                            IRemoteServices remServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(uri, (IProgressMonitor)progress.newChild(5));
                            if (remServices != null && (remConn = remServices.getConnectionManager().getConnection(uri)) != null) {
                                this.config.setRemoteServicesId(remServices.getId());
                                this.config.setConnectionName(remConn.getName());
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                    this.setFixedConfigurationProperties((IProgressMonitor)progress.newChild(5));
                    this.isInitialized = true;
                }
                catch (Throwable t) {
                    throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    @Override
    public void jobStateChanged(String jobId, IJobStatus status) {
        IPJob job = ModelManager.getInstance().getUniverse().getJob(status);
        if (job != null && status.getState().equals("COMPLETED")) {
            ((EnumeratedAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getStateAttributeDefinition())).setValue((Enum)JobAttributes.State.COMPLETED);
        }
        JobManager.getInstance().fireJobChanged(status);
    }

    @Override
    public Object runActionCommand(String action, String resetValue, ILaunchConfiguration configuration) throws CoreException {
        if (!this.resourceManagerIsActive()) {
            return null;
        }
        this.updatePropertyValues(configuration, null);
        AttributeType changedValue = null;
        if (resetValue != null) {
            changedValue = this.getVarMap().get(resetValue);
            changedValue.setValue(null);
        }
        CommandType command = null;
        for (CommandType cmd : this.getConfiguration().getControlData().getButtonAction()) {
            if (!cmd.getName().equals(action)) continue;
            command = cmd;
            break;
        }
        if (command == null) {
            for (CommandType cmd : this.getConfiguration().getControlData().getStartUpCommand()) {
                if (!cmd.getName().equals(action)) continue;
                command = cmd;
                break;
            }
        }
        if (command == null) {
            for (CommandType cmd : this.getConfiguration().getControlData().getShutDownCommand()) {
                if (!cmd.getName().equals(action)) continue;
                command = cmd;
                break;
            }
        }
        if (command != null) {
            this.runCommand(null, command, CommandJob.JobMode.INTERACTIVE, null, "run", true);
        }
        return changedValue;
    }

    @Override
    public synchronized void setInteractiveJob(ICommandJob interactiveJob) {
        this.interactiveJob = interactiveJob;
    }

    private void doConnect(IProgressMonitor monitor) throws RemoteConnectionException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RemoteServicesDelegate d = this.getRemoteServicesDelegate((IProgressMonitor)progress.newChild(50));
        IRemoteConnection conn = d.getRemoteConnection();
        if (conn != null) {
            JAXBResourceManagerControl.checkConnection(conn, progress);
            conn.addConnectionChangeListener((IRemoteConnectionChangeListener)this.connectionListener);
        }
    }

    private void doControlCommand(String jobId, String operation) throws CoreException {
        CoreException ce = CoreExceptionUtils.newException((String)(String.valueOf(Messages.RMNoSuchCommandError) + operation), null);
        CommandType job = null;
        if ("TERMINATE".equals(operation)) {
            this.maybeKillInteractive(jobId);
            job = this.getConfiguration().getControlData().getTerminateJob();
            if (job == null) {
                return;
            }
        } else if ("SUSPEND".equals(operation) ? (job = this.getConfiguration().getControlData().getSuspendJob()) == null : ("RESUME".equals(operation) ? (job = this.getConfiguration().getControlData().getResumeJob()) == null : ("RELEASE".equals(operation) ? (job = this.getConfiguration().getControlData().getReleaseJob()) == null : "HOLD".equals(operation) && (job = this.getConfiguration().getControlData().getHoldJob()) == null))) {
            throw ce;
        }
        this.runCommand(jobId, job, CommandJob.JobMode.INTERACTIVE, null, "run", true);
    }

    private ICommandJob doJobSubmitCommand(String uuid, ILaunchConfiguration configuration, String mode) throws CoreException {
        CommandType command = null;
        CommandJob.JobMode jobMode = CommandJob.JobMode.INTERACTIVE;
        if ("run".equals(mode)) {
            command = this.getConfiguration().getControlData().getSubmitBatch();
            if (command != null) {
                jobMode = CommandJob.JobMode.BATCH;
            } else {
                command = this.getConfiguration().getControlData().getSubmitInteractive();
            }
        } else if ("debug".equals(mode)) {
            command = this.getConfiguration().getControlData().getSubmitBatchDebug();
            if (command != null) {
                jobMode = CommandJob.JobMode.BATCH;
            } else {
                command = this.getConfiguration().getControlData().getSubmitInteractiveDebug();
            }
        }
        if (command == null) {
            throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.MissingRunCommandsError) + " " + uuid + " " + mode), null);
        }
        return this.runCommand(uuid, command, jobMode, configuration, mode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnShutdown() throws CoreException {
        String iJobId = null;
        JAXBResourceManagerControl jAXBResourceManagerControl = this;
        synchronized (jAXBResourceManagerControl) {
            ICommandJobStatus status;
            if (this.interactiveJob != null && (status = this.interactiveJob.getJobStatus()) != null) {
                iJobId = status.getJobId();
            }
        }
        this.doControlJob(iJobId, "TERMINATE", null);
        List onShutDown = this.getConfiguration().getControlData().getShutDownCommand();
        this.runCommands(onShutDown);
        this.isActive = false;
    }

    private void doOnStartUp() throws CoreException {
        this.launchEnv = new TreeMap<String, String>();
        this.pinTable = new JobIdPinTable();
        this.appendLaunchEnv = true;
        this.jobStatusMap = new JobStatusMap(this);
        ((Thread)((Object)this.jobStatusMap)).start();
        List onStartUp = this.getConfiguration().getControlData().getStartUpCommand();
        this.runCommands(onStartUp);
        this.isActive = true;
    }

    private IRemoteConnection getRemoteConnection() {
        String connName = this.getControlConfiguration().getConnectionName();
        IRemoteServices rsrv = this.getRemoteServices();
        if (rsrv == null) {
            return null;
        }
        IRemoteConnectionManager connMgr = rsrv.getConnectionManager();
        if (connMgr == null) {
            return null;
        }
        return connMgr.getConnection(connName);
    }

    private IRemoteServices getRemoteServices() {
        return PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getControlConfiguration().getRemoteServicesId(), null);
    }

    private void maybeAddManagedFileForScript(List<ManagedFilesType> lists, String stagingLocation, boolean delete) {
        ManagedFilesType files = null;
        if (stagingLocation == null) {
            stagingLocation = ".eclipsesettings";
        }
        for (ManagedFilesType f : lists) {
            if (!stagingLocation.equals(f.getFileStagingLocation())) continue;
            files = f;
            break;
        }
        AttributeType scriptVar = this.getVarMap().get("script");
        AttributeType scriptPathVar = this.getVarMap().get("script_path");
        if (scriptVar != null || scriptPathVar != null) {
            if (files == null) {
                files = new ManagedFilesType();
                files.setFileStagingLocation(stagingLocation);
                lists.add(files);
            }
            List fileList = files.getFile();
            ManagedFileType scriptFile = null;
            if (!fileList.isEmpty()) {
                for (ManagedFileType f : fileList) {
                    if (!f.getName().equals("managed_file_for_script")) continue;
                    scriptFile = f;
                    break;
                }
            }
            if (scriptFile == null) {
                scriptFile = new ManagedFileType();
                scriptFile.setName("managed_file_for_script");
                fileList.add(scriptFile);
            }
            scriptFile.setResolveContents(Boolean.valueOf(false));
            scriptFile.setUniqueIdPrefix(Boolean.valueOf(true));
            if (scriptPathVar != null) {
                scriptFile.setPath(String.valueOf(scriptPathVar.getValue()));
                scriptFile.setDeleteSourceAfterUse(Boolean.valueOf(false));
            } else {
                scriptFile.setContents("${ptp_rm:script#value}");
                scriptFile.setDeleteSourceAfterUse(Boolean.valueOf(true));
            }
            scriptFile.setDeleteTargetAfterUse(Boolean.valueOf(delete));
        }
    }

    private void maybeCleanupManagedFiles(String uuid, List<ManagedFilesType> lists) throws CoreException {
        if (lists == null || lists.isEmpty()) {
            return;
        }
        for (ManagedFilesType files : lists) {
            if (files.getFile().isEmpty()) continue;
            ManagedFilesJob job = new ManagedFilesJob(uuid, files, this);
            job.setOperation(ManagedFilesJob.Operation.DELETE);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean maybeHandleScript(String uuid, ScriptType script, IProgressMonitor monitor) {
        AttributeType a = this.getVarMap().get("script_path");
        if (a != null && a.getValue() != null) {
            return false;
        }
        if (script == null) {
            return false;
        }
        this.getVarMap().setEnvManagerFromConnection(this.getRemoteConnection());
        ScriptHandler job = new ScriptHandler(uuid, script, this.getVarMap(), this.launchEnv, false);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return script.isDeleteAfterSubmit();
    }

    private boolean maybeKillInteractive(String jobId) {
        ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
        boolean killed = false;
        if (status != null) {
            killed = status.cancel();
        }
        return killed;
    }

    private boolean maybeTransferManagedFiles(String uuid, List<ManagedFilesType> lists) throws CoreException {
        if (lists == null || lists.isEmpty()) {
            return true;
        }
        for (ManagedFilesType files : lists) {
            if (files.getFile().isEmpty()) continue;
            ManagedFilesJob job = new ManagedFilesJob(uuid, files, this);
            job.setOperation(ManagedFilesJob.Operation.COPY);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            if (job.getSuccess()) continue;
            return false;
        }
        return true;
    }

    private boolean resourceManagerIsActive() {
        return this.isActive;
    }

    private ICommandJob runCommand(String uuid, CommandType command, CommandJob.JobMode jobMode, ILaunchConfiguration configuration, String launchMode, boolean join) throws CoreException {
        if (command == null) {
            throw CoreExceptionUtils.newException((String)Messages.RMNoSuchCommandError, null);
        }
        CommandJob job = new CommandJob(uuid, command, jobMode, this, configuration, launchMode);
        ((Job)job).setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
        if (join) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!command.isIgnoreExitStatus()) {
            JAXBResourceManagerControl.checkJobForError(job);
        }
        return job;
    }

    private void runCommands(List<CommandType> cmds) throws CoreException {
        for (CommandType cmd : cmds) {
            this.runCommand(null, cmd, CommandJob.JobMode.INTERACTIVE, null, "run", true);
        }
    }

    private void setFixedConfigurationProperties(IProgressMonitor monitor) throws CoreException {
        IRemoteConnection rc = this.getRemoteServicesDelegate(monitor).getRemoteConnection();
        if (rc != null) {
            this.getVarMap().maybeAddAttribute("control.user.name", rc.getUsername(), false);
            this.getVarMap().maybeAddAttribute("control.address", rc.getAddress(), false);
            this.getVarMap().maybeAddAttribute("control.working.dir", rc.getWorkingDirectory(), false);
            this.getVarMap().maybeAddAttribute("ptpDirectory", new Path(rc.getWorkingDirectory()).append(".eclipsesettings").toString(), false);
        }
    }

    private void updatePropertyValues(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)40);
        this.setFixedConfigurationProperties((IProgressMonitor)progress.newChild(10));
        Map<String, Object> lcattr = RMVariableMap.getValidAttributes(configuration);
        for (String key : lcattr.keySet()) {
            Object value = lcattr.get(key);
            AttributeType target = this.getVarMap().get(key.toString());
            if (target == null) continue;
            target.setValue(value);
        }
        progress.worked(10);
        for (String key : this.getVarMap().getAttributes().keySet()) {
            AttributeType target;
            if (lcattr.containsKey(key) || !(target = this.getVarMap().get(key.toString())).isVisible()) continue;
            target.setValue(null);
        }
        progress.worked(10);
        this.getVarMap().overwrite("script_path", "script_path", lcattr);
        this.getVarMap().overwrite("directory", "directory", lcattr);
        this.getVarMap().overwrite("executablePath", "executablePath", lcattr);
        this.getVarMap().overwrite("executableDirectory", "executableDirectory", lcattr);
        this.getVarMap().overwrite("progArgs", "progArgs", lcattr);
        this.getVarMap().overwrite("debuggerExecutablePath", "debuggerExecutablePath", lcattr);
        String attr = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", null);
        if (attr != null) {
            AttributeType a = this.getVarMap().get("debuggerArgs");
            if (a == null) {
                a = new AttributeType();
                this.getVarMap().put("debuggerArgs", a);
            }
            a.setValue((Object)attr);
        }
        this.launchEnv.clear();
        this.launchEnv.putAll(configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, this.launchEnv));
        this.appendLaunchEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, this.appendLaunchEnv);
    }

    private void worked(IProgressMonitor monitor, int units) {
        if (monitor != null) {
            if (units == 0) {
                monitor.done();
            } else {
                monitor.worked(units);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doControlJob(String jobId, String operation, IProgressMonitor monitor) throws CoreException {
        if (!this.resourceManagerIsActive()) {
            throw CoreExceptionUtils.newException((String)"Resource manager has not been started", null);
        }
        if (jobId == null) {
            JAXBResourceManagerControl jAXBResourceManagerControl = this;
            synchronized (jAXBResourceManagerControl) {
                if (this.interactiveJob != null) {
                    this.interactiveJob.terminate();
                    this.interactiveJob = null;
                }
            }
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.pinTable.pin(jobId);
            AttributeType a = new AttributeType();
            a.setVisible(Boolean.valueOf(false));
            a.setName(jobId);
            this.getVarMap().put(jobId, a);
            this.worked((IProgressMonitor)progress, 30);
            this.doControlCommand(jobId, operation);
            this.getVarMap().remove(jobId);
            this.worked((IProgressMonitor)progress, 40);
            if ("TERMINATE".equals(operation)) {
                ICommandJobStatus canceledStatus = this.jobStatusMap.cancel(jobId);
                JAXBResourceManagerControl jAXBResourceManagerControl = this;
                synchronized (jAXBResourceManagerControl) {
                    if (this.interactiveJob != null && canceledStatus == this.interactiveJob.getJobStatus()) {
                        this.interactiveJob = null;
                    }
                }
            }
            this.worked((IProgressMonitor)progress, 30);
        }
        finally {
            this.pinTable.release(jobId);
        }
    }

    protected void doDispose() {
    }

    protected IJobStatus doGetJobStatus(String jobId, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.resourceManagerIsActive()) {
            throw CoreExceptionUtils.newException((String)"Resource manager has not been started", null);
        }
        try {
            ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (status != null) {
                if ("COMPLETED".equals(status.getState())) {
                    status = this.jobStatusMap.terminated(jobId, (IProgressMonitor)progress.newChild(50));
                    if (status != null && status.stateChanged()) {
                        this.jobStateChanged(jobId, status);
                    }
                    return status;
                }
                if (!force) {
                    long now = System.currentTimeMillis();
                    long lapse = now - status.getLastUpdateRequest();
                    if (lapse < 30000L) {
                        return status;
                    }
                    status.setUpdateRequestTime(now);
                }
            }
            String state = status == null ? "UNDETERMINED" : status.getStateDetail();
            try {
                AttributeType a = this.getVarMap().get(jobId);
                CommandType job = this.getConfiguration().getControlData().getGetJobStatus();
                if (job != null && this.resourceManagerIsActive() && !progress.isCanceled()) {
                    this.pinTable.pin(jobId);
                    a = new AttributeType();
                    a.setVisible(Boolean.valueOf(false));
                    a.setName(jobId);
                    this.getVarMap().put(jobId, a);
                    this.runCommand(jobId, job, CommandJob.JobMode.STATUS, null, "run", true);
                    a = this.getVarMap().remove(jobId);
                }
                if (a != null) {
                    state = String.valueOf(a.getValue());
                }
            }
            finally {
                this.pinTable.release(jobId);
            }
            if (status == null) {
                status = new CommandJobStatus(jobId, state, null, this);
                status.setOwner(this.getVarMap().getString("${ptp_rm:control.user.name#value}"));
                this.jobStatusMap.addJobStatus(jobId, status);
            } else {
                status.setState(state);
            }
            if (progress.isCanceled()) {
                status.setState("UNDETERMINED");
                this.jobStateChanged(jobId, status);
                return status;
            }
            if ("COMPLETED".equals(state)) {
                status = this.jobStatusMap.terminated(jobId, (IProgressMonitor)progress.newChild(50));
            }
            if (status.stateChanged()) {
                this.jobStateChanged(jobId, status);
            }
            return status;
        }
        catch (CoreException ce) {
            this.getResourceManager().setState("ERROR");
            throw ce;
        }
    }

    protected void doShutdown() throws CoreException {
        this.doOnShutdown();
        this.jobStatusMap.halt();
        RemoteServicesDelegate d = this.getRemoteServicesDelegate(null);
        IRemoteConnection conn = d.getRemoteConnection();
        if (conn != null) {
            conn.removeConnectionChangeListener((IRemoteConnectionChangeListener)this.connectionListener);
        }
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)60);
        try {
            this.doConnect((IProgressMonitor)progress.newChild(20));
        }
        catch (CoreException ce) {
            progress.done();
            throw ce;
        }
        catch (Throwable t) {
            progress.done();
            throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
        }
        try {
            this.initialize((IProgressMonitor)progress.newChild(30));
            this.doOnStartUp();
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
        }
    }

    protected IJobStatus doSubmitJob(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        Object status;
        String uuid = UUID.randomUUID().toString();
        if (!this.resourceManagerIsActive()) {
            throw CoreExceptionUtils.newException((String)"Resource manager has not been started", null);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String jobId = null;
        AttributeType a = new AttributeType();
        a.setVisible(Boolean.valueOf(false));
        this.getVarMap().put(uuid, a);
        this.updatePropertyValues(configuration, (IProgressMonitor)progress.newChild(5));
        ScriptType script = this.getConfiguration().getControlData().getScript();
        boolean delScript = this.maybeHandleScript(uuid, script, (IProgressMonitor)progress.newChild(10));
        this.worked((IProgressMonitor)progress, 10);
        List files = this.getConfiguration().getControlData().getManagedFiles();
        if (script != null) {
            this.maybeAddManagedFileForScript(files, script.getFileStagingLocation(), delScript);
        }
        this.worked((IProgressMonitor)progress, 5);
        if (!this.maybeTransferManagedFiles(uuid, files)) {
            throw CoreExceptionUtils.newException((String)Messages.CannotCompleteSubmitFailedStaging, null);
        }
        this.worked((IProgressMonitor)progress, 20);
        ICommandJob job = null;
        try {
            job = this.doJobSubmitCommand(uuid, configuration, mode);
            status = job.getRunStatus();
            if (status != null && status.getSeverity() == 8) {
                throw CoreExceptionUtils.newException((String)Messages.OperationWasCancelled, null);
            }
            this.worked((IProgressMonitor)progress, 40);
        }
        finally {
            this.maybeCleanupManagedFiles(uuid, files);
            this.worked((IProgressMonitor)progress, 5);
        }
        status = job.getJobStatus();
        if (this.interactiveJob != null && this.interactiveJob.getJobStatus() == status && this.interactiveJob != job) {
            return status;
        }
        this.getVarMap().remove(uuid);
        jobId = a.getName();
        if (jobId == null) {
            status = new CommandJobStatus(uuid, "CANCELED", null, this);
            status.setOwner(this.getVarMap().getString("${ptp_rm:control.user.name#value}"));
            return status;
        }
        this.jobStatusMap.addJobStatus(status.getJobId(), (ICommandJobStatus)status);
        status.setLaunchConfig(configuration);
        this.worked((IProgressMonitor)progress, 5);
        this.getVarMap().remove("script_path");
        this.getVarMap().remove("script");
        return status;
    }

    private class ConnectionChangeListener
    implements IRemoteConnectionChangeListener {
        public void connectionChanged(IRemoteConnectionChangeEvent event) {
            if (event.getType() == 4 || event.getType() == 1) {
                try {
                    JAXBResourceManagerControl.this.getResourceManager().stop();
                }
                catch (CoreException e) {
                    JAXBControlCorePlugin.log(e);
                }
            }
        }
    }
}

