/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBlock;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIControlFlowGraph;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.Util;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IBlock;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IControlFlowGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPIMVAnalysis {
    protected ICallGraph cg_;
    protected MPICallGraphNode currentNode_;
    protected final int lhs = 0;
    protected final int rhs = 1;
    protected boolean changed = false;
    private static final boolean traceOn = false;

    public MPIMVAnalysis(ICallGraph cg) {
        this.cg_ = cg;
    }

    public void run() {
        this.init();
        SeedsCollector sc = new SeedsCollector();
        sc.run();
        this.functionMVSummary();
        this.functionSlicing();
        this.exprMVAnalysis();
        ICallGraphNode n = this.cg_.topEntry();
        while (n != null) {
            MPICallGraphNode node = (MPICallGraphNode)n;
            if (node.marked) {
                IControlFlowGraph cfg = node.getCFG();
                IBlock b = cfg.getEntry();
                while (b != null) {
                    MPIBlock block = (MPIBlock)b;
                    if (block.getMV() && (block.withBreak || block.withContinue)) {
                        System.out.println("************  Multi-valued branch with Break/Continue in " + node.getFuncName() + "(" + node.getFileName() + ")");
                    }
                    b = b.topNext();
                }
            }
            n = n.topNext();
        }
    }

    private void clean() {
        IBlock b = this.currentNode_.getCFG().getEntry();
        while (b != null) {
            MPIBlock block = (MPIBlock)b;
            block.sliced = false;
            block.setMVvar(new ArrayList<String>());
            b = b.topNext();
        }
    }

    private void exprMVAnalysis() {
        ICallGraphNode n = this.cg_.botEntry();
        while (n != null) {
            MPICallGraphNode node = (MPICallGraphNode)n;
            if (node.marked) {
                IControlFlowGraph cfg = node.getCFG();
                IBlock b = cfg.getEntry();
                while (b != null) {
                    MPIBlock block = (MPIBlock)b;
                    ExprMVAnalyzer EA = new ExprMVAnalyzer(block.getContent(), block.getMVvar(), block);
                    EA.run();
                    EA.isMV();
                    block.setMV(EA.isMV());
                    b = b.topNext();
                }
            }
            n = n.botNext();
        }
    }

    private void functionMVSummary() {
        this.changed = true;
        while (this.changed) {
            this.changed = false;
            ICallGraphNode n = this.cg_.botEntry();
            while (n != null) {
                MPICallGraphNode node = (MPICallGraphNode)n;
                if (node.marked) {
                    this.currentNode_ = node;
                    Enumeration<String> e = node.getMVSummary().keys();
                    while (e.hasMoreElements()) {
                        String var = e.nextElement();
                        this.singleVariableSlicing(var);
                        this.clean();
                    }
                }
                n = n.botNext();
            }
        }
    }

    private void functionSlicing() {
        ICallGraphNode n = this.cg_.topEntry();
        while (n != null) {
            MPICallGraphNode node = (MPICallGraphNode)n;
            if (node.marked) {
                Object block;
                this.currentNode_ = node;
                IControlFlowGraph cfg = node.getCFG();
                WorkListCollector wlc = new WorkListCollector((ICallGraphNode)this.currentNode_);
                LinkedList<IBlock> seeds = wlc.getWorkList();
                boolean hasMVparam = false;
                Enumeration<String> e = node.getParamMV().keys();
                while (e.hasMoreElements()) {
                    String param = e.nextElement();
                    boolean val = node.getParamMV().get(param);
                    if (!val) continue;
                    ((MPIBlock)cfg.getEntry()).getMVvar().add(param);
                    hasMVparam = true;
                }
                if (hasMVparam) {
                    seeds.add(cfg.getEntry());
                }
                while (!seeds.isEmpty()) {
                    block = (MPIBlock)seeds.remove();
                    if (((MPIBlock)((Object)block)).sliced) continue;
                    ((MPIBlock)((Object)block)).sliced = true;
                    Hashtable<String, List<IBlock>> DUSucc = ((MPIBlock)((Object)block)).getDUSucc();
                    List<String> mv = ((MPIBlock)((Object)block)).getMVvar();
                    ArrayList<String> newMV = new ArrayList();
                    this.handlePointers((MPIBlock)((Object)block), mv);
                    if (!((MPIBlock)((Object)block)).getPhiVar().isEmpty()) {
                        List<IBlock> cond = ((MPIBlock)((Object)block)).getCond();
                        int blockcase = 0;
                        Iterator<Object> i = cond.iterator();
                        while (i.hasNext()) {
                            if (blockcase == 2) break;
                            MPIBlock mPIBlock = (MPIBlock)i.next();
                            IASTStatement parent = mPIBlock.getParent();
                            if (parent instanceof IASTIfStatement || parent instanceof IASTSwitchStatement) {
                                blockcase = 1;
                                continue;
                            }
                            if (!(parent instanceof IASTForStatement) && !(parent instanceof IASTDoStatement) && !(parent instanceof IASTWhileStatement)) continue;
                            if (block.getType() == 5) {
                                blockcase = 1;
                                continue;
                            }
                            if (block.getType() != 1) continue;
                            blockcase = 2;
                        }
                        if (blockcase == 1) {
                            newMV = Util.Union(newMV, ((MPIBlock)((Object)block)).getPhiVar());
                        } else if (blockcase == 2) {
                            for (MPIBlock mPIBlock : cond) {
                                for (String var : mPIBlock.getUsedPhiVar()) {
                                    if (!mv.contains(var)) continue;
                                    newMV.add(var);
                                }
                            }
                        }
                    }
                    IASTNode content = block.getContent();
                    ExprMVAnalyzer emva = new ExprMVAnalyzer(content, mv, (MPIBlock)((Object)block));
                    emva.run();
                    newMV = Util.Union(newMV, emva.getMVList());
                    for (String string : mv) {
                        if (!((MPIBlock)((Object)block)).getUse().contains(string) || ((MPIBlock)((Object)block)).getDef().contains(string) || newMV.contains(string)) continue;
                        newMV.add(string);
                    }
                    this.handlePointers((MPIBlock)((Object)block), newMV);
                    this.handleBroadCast((MPIBlock)((Object)block), newMV);
                    ((MPIBlock)((Object)block)).setMVvar(newMV);
                    for (String string : newMV) {
                        List<IBlock> DUnext = DUSucc.get(string);
                        if (DUnext == null) continue;
                        for (MPIBlock mPIBlock : DUnext) {
                            if (mPIBlock.sliced) continue;
                            if (!seeds.contains((Object)mPIBlock)) {
                                seeds.add((IBlock)mPIBlock);
                            }
                            if (mPIBlock.getMVvar().contains(string)) continue;
                            mPIBlock.getMVvar().add(string);
                        }
                    }
                    for (MPIBlock mPIBlock : ((MPIBlock)((Object)block)).getJoin()) {
                        if (seeds.contains((Object)mPIBlock) || mPIBlock.sliced) continue;
                        seeds.add((IBlock)mPIBlock);
                    }
                }
                block = cfg.getEntry();
                while (block != null) {
                    FuncParamMVChecker fpc = new FuncParamMVChecker(node, (MPIBlock)((Object)block));
                    fpc.run();
                    block = block.topNext();
                }
            }
            n = n.topNext();
        }
    }

    private String getFormalParamName(ICallGraphNode func, int index) {
        IASTFunctionDefinition fd = func.getFuncDef();
        IASTFunctionDeclarator fdecl = fd.getDeclarator();
        if (fdecl instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator sfunc = (IASTStandardFunctionDeclarator)fdecl;
            IASTParameterDeclaration[] params = sfunc.getParameters();
            if (index >= params.length) {
                return null;
            }
            IASTName param = params[index].getDeclarator().getName();
            return param.toString();
        }
        ICASTKnRFunctionDeclarator krfunc = (ICASTKnRFunctionDeclarator)fdecl;
        IASTName[] params = krfunc.getParameterNames();
        if (index >= params.length) {
            return null;
        }
        return params[index].toString();
    }

    private void handleBroadCast(MPIBlock block, List<String> set) {
        BroadCastAnalyzer bca = new BroadCastAnalyzer((IBlock)block);
        bca.run();
        String bcdata = bca.getBCdata();
        if (bcdata != null && set.contains(bcdata)) {
            set.remove(bcdata);
        }
        block.setMVvar(set);
    }

    private void handlePointers(MPIBlock block, List<String> set) {
        PointerAnalyzer pa = new PointerAnalyzer((IBlock)block);
        pa.run();
        for (String var : pa.getAddr()) {
            if (!block.getUse().contains(var) || set.contains(var)) continue;
            set.add(var);
        }
        for (String var : pa.getDeref()) {
            if (!block.getUse().contains(var) || set.contains(var)) continue;
            set.add(var);
        }
    }

    private void init() {
        ICallGraphNode n = this.cg_.topEntry();
        while (n != null) {
            MPICallGraphNode node = (MPICallGraphNode)n;
            if (node.marked) {
                int i;
                IASTParameterDeclaration[] params;
                IASTFunctionDefinition fd = node.getFuncDef();
                IASTFunctionDeclarator fdecl = fd.getDeclarator();
                if (fdecl instanceof IASTStandardFunctionDeclarator) {
                    IASTStandardFunctionDeclarator sfunc = (IASTStandardFunctionDeclarator)fdecl;
                    params = sfunc.getParameters();
                    i = 0;
                    while (i < params.length) {
                        IASTName param = params[i].getDeclarator().getName();
                        if (!param.toString().equals("")) {
                            node.getParamMV().put(param.toString(), new Boolean(false));
                            node.getMVSummary().put(param.toString(), new ArrayList());
                        }
                        ++i;
                    }
                } else {
                    ICASTKnRFunctionDeclarator krfunc = (ICASTKnRFunctionDeclarator)fdecl;
                    params = krfunc.getParameterNames();
                    i = 0;
                    while (i < params.length) {
                        node.getParamMV().put(params[i].toString(), new Boolean(false));
                        node.getMVSummary().put(params[i].toString(), new ArrayList());
                        ++i;
                    }
                }
                for (String var : node.getGlobalUse()) {
                    node.getMVSummary().put(var, new ArrayList());
                }
                node.getMVSummary().put(node.getFuncName(), new ArrayList());
            }
            n = n.topNext();
        }
    }

    private boolean returnMV() {
        boolean returnmv = false;
        for (MPIBlock mPIBlock : ((MPIControlFlowGraph)this.currentNode_.getCFG()).getReturnBlocks()) {
            ExprMVAnalyzer ema = new ExprMVAnalyzer(mPIBlock.getContent(), mPIBlock.getMVvar(), mPIBlock);
            ema.run();
            returnmv |= ema.isMV();
            mPIBlock.setMV(false);
        }
        return returnmv;
    }

    private void singleVariableSlicing(String var) {
        IControlFlowGraph cfg = this.currentNode_.getCFG();
        WorkListCollector wlc = new WorkListCollector((ICallGraphNode)this.currentNode_);
        LinkedList<IBlock> seeds = wlc.getWorkList();
        if (!var.equals(this.currentNode_.getFuncName())) {
            seeds.add(cfg.getEntry());
            ((MPIBlock)cfg.getEntry()).getMVvar().add(var);
        }
        while (!seeds.isEmpty()) {
            MPIBlock block = (MPIBlock)seeds.remove();
            if (block.sliced) continue;
            block.sliced = true;
            if (block.getContent() == null) continue;
            Hashtable<String, List<IBlock>> DUSucc = block.getDUSucc();
            List<String> mv = block.getMVvar();
            ArrayList<String> newMV = new ArrayList();
            this.handlePointers(block, mv);
            if (!block.getPhiVar().isEmpty()) {
                List<IBlock> cond = block.getCond();
                int blockcase = 0;
                Iterator<Object> i = cond.iterator();
                while (i.hasNext()) {
                    if (blockcase == 2) break;
                    MPIBlock mPIBlock = (MPIBlock)i.next();
                    IASTStatement parent = mPIBlock.getParent();
                    if (parent instanceof IASTIfStatement || parent instanceof IASTSwitchStatement) {
                        blockcase = 1;
                        continue;
                    }
                    if (!(parent instanceof IASTForStatement) && !(parent instanceof IASTDoStatement) && !(parent instanceof IASTWhileStatement)) continue;
                    if (block.getType() == 5) {
                        blockcase = 1;
                        continue;
                    }
                    if (block.getType() != 1) continue;
                    blockcase = 2;
                }
                if (blockcase == 1) {
                    newMV = Util.Union(newMV, block.getPhiVar());
                } else if (blockcase == 2) {
                    for (MPIBlock mPIBlock : cond) {
                        for (String v : mPIBlock.getUsedPhiVar()) {
                            if (!mv.contains(v)) continue;
                            newMV.add(v);
                        }
                    }
                }
            }
            IASTNode content = block.getContent();
            ExprMVAnalyzer emva = new ExprMVAnalyzer(content, mv, block);
            emva.run();
            newMV = Util.Union(newMV, emva.getMVList());
            for (String string : mv) {
                if (!block.getUse().contains(string) || block.getDef().contains(string) || newMV.contains(string)) continue;
                newMV.add(string);
            }
            this.handlePointers(block, newMV);
            this.handleBroadCast(block, newMV);
            block.setMVvar(newMV);
            for (String string : newMV) {
                List<IBlock> DUnext = DUSucc.get(string);
                if (DUnext == null) continue;
                for (MPIBlock mPIBlock : DUnext) {
                    if (mPIBlock.sliced) continue;
                    if (!seeds.contains((Object)mPIBlock)) {
                        seeds.add((IBlock)mPIBlock);
                    }
                    if (mPIBlock.getMVvar().contains(string)) continue;
                    mPIBlock.getMVvar().add(string);
                }
            }
            for (MPIBlock mPIBlock : block.getJoin()) {
                if (seeds.contains((Object)mPIBlock) || mPIBlock.sliced) continue;
                seeds.add((IBlock)mPIBlock);
            }
        }
        List<String> MVlist = this.currentNode_.getMVSummary().get(var);
        for (String v : this.currentNode_.getGlobalDef()) {
            if (!((MPIBlock)cfg.getExit()).getMVvar().contains(v) || MVlist.contains(v)) continue;
            MVlist.add(v);
        }
        for (String v : this.currentNode_.getParamDef()) {
            if (!((MPIBlock)cfg.getExit()).getMVvar().contains(v) || MVlist.contains(v)) continue;
            MVlist.add(v);
        }
        if (this.returnMV() && !MVlist.contains(this.currentNode_.getFuncName())) {
            MVlist.add(this.currentNode_.getFuncName());
        }
    }

    class BroadCastAnalyzer
    extends ASTVisitor {
        private final IBlock block_;
        private String var;

        public BroadCastAnalyzer(IBlock block) {
            this.block_ = block;
            this.var = null;
        }

        public String getBCdata() {
            return this.var;
        }

        public void run() {
            this.shouldVisitStatements = true;
            this.shouldVisitExpressions = true;
            IASTNode content = this.block_.getContent();
            if (content != null) {
                content.accept((ASTVisitor)this);
            }
        }

        public int visit(IASTExpression expr) {
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcE = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcE.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                if (signature.equals("MPI_Bcast")) {
                    IASTUnaryExpression uE;
                    IASTExpression paramE = funcE.getParameterExpression();
                    IASTExpression[] params = ((IASTExpressionList)paramE).getExpressions();
                    IASTExpression dataE = params[0];
                    if (dataE instanceof IASTIdExpression) {
                        IASTIdExpression ID = (IASTIdExpression)dataE;
                        this.var = ID.getName().toString();
                    } else if (dataE instanceof IASTUnaryExpression && (uE = (IASTUnaryExpression)dataE).getOperator() == 5 && uE.getOperand() instanceof IASTIdExpression) {
                        IASTIdExpression ID = (IASTIdExpression)uE.getOperand();
                        this.var = ID.getName().toString();
                    }
                }
                return 1;
            }
            return 3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExprMVAnalyzer {
        private IASTStatement stmt_;
        private IASTExpression expr_;
        private final List<String> context_;
        private final MPIBlock currentBlock_;
        private final List<String> MVvar_;
        private final Stack<boolean[]> exprListMVContext_;
        private boolean value;

        public ExprMVAnalyzer(IASTExpression expr, List<String> context, MPIBlock block) {
            this.stmt_ = null;
            this.expr_ = expr;
            this.context_ = context;
            this.currentBlock_ = block;
            this.MVvar_ = new ArrayList<String>();
            this.exprListMVContext_ = new Stack();
            this.value = false;
        }

        public ExprMVAnalyzer(IASTNode node, List<String> context, MPIBlock block) {
            if (node instanceof IASTExpression) {
                this.stmt_ = null;
                this.expr_ = (IASTExpression)node;
            } else if (node instanceof IASTStatement) {
                this.stmt_ = (IASTStatement)node;
                this.expr_ = null;
            }
            this.context_ = context;
            this.currentBlock_ = block;
            this.MVvar_ = new ArrayList<String>();
            this.exprListMVContext_ = new Stack();
            this.value = false;
        }

        public ExprMVAnalyzer(IASTStatement stmt, List<String> context, MPIBlock block) {
            this.stmt_ = stmt;
            this.expr_ = null;
            this.context_ = context;
            this.currentBlock_ = block;
            this.MVvar_ = new ArrayList<String>();
            this.exprListMVContext_ = new Stack();
            this.value = false;
        }

        public List<String> getMVList() {
            return this.MVvar_;
        }

        public boolean isMV() {
            return this.value;
        }

        public void run() {
            if (this.stmt_ != null) {
                this.value = this.useDefMVMapping(this.stmt_);
            } else if (this.expr_ != null) {
                ArrayList<String> defset = new ArrayList<String>();
                this.value = this.useDefMVMapping(this.expr_, 1, null, defset);
            }
        }

        private boolean handleInitializer(IASTInitializer init) {
            if (init instanceof IASTInitializerExpression) {
                IASTInitializerExpression initE = (IASTInitializerExpression)init;
                IASTExpression expr = initE.getExpression();
                ArrayList<String> mvlist = new ArrayList<String>();
                return this.useDefMVMapping(expr, 1, null, mvlist);
            }
            if (init instanceof IASTInitializerList) {
                IASTInitializerList initList = (IASTInitializerList)init;
                IASTInitializer[] list = initList.getInitializers();
                boolean listvalue = false;
                int i = 0;
                while (i < list.length) {
                    listvalue |= this.handleInitializer(list[i]);
                    ++i;
                }
                return listvalue;
            }
            return false;
        }

        private boolean newParameterUse(int side, List<String> set, boolean v1, List<String> l1, IASTFunctionCallExpression funcE, IASTInitializerClause[] newParameterList, MPICallGraphNode n, boolean returnval) {
            if (newParameterList != null) {
                int i = 0;
                while (i < newParameterList.length) {
                    IASTInitializerClause ic = newParameterList[i];
                    if (ic instanceof IASTExpression) {
                        String param;
                        ic.getRawSignature();
                        IASTExpression iexpr = (IASTExpression)ic;
                        boolean context = v1 |= this.useDefMVMapping(iexpr, side, funcE, l1);
                        Util.addAll(set, l1);
                        if (context && (param = MPIMVAnalysis.this.getFormalParamName((ICallGraphNode)n, i)) != null) {
                            List<String> mvlist = n.getMVSummary().get(param);
                            Util.addAll(this.MVvar_, mvlist);
                            if (mvlist.contains(n.getFuncName())) {
                                this.MVvar_.remove(n.getFuncName());
                                returnval = true;
                            }
                        }
                    }
                    ++i;
                }
            }
            return returnval;
        }

        private boolean oldParameterUse(IASTExpression parameter, MPICallGraphNode cgNode, boolean returnval) {
            if (parameter instanceof IASTExpressionList) {
                boolean[] paramContext = this.exprListMVContext_.pop();
                int i = 0;
                while (i < paramContext.length) {
                    String param;
                    if (paramContext[i] && (param = MPIMVAnalysis.this.getFormalParamName((ICallGraphNode)cgNode, i)) != null) {
                        List<String> mvlist = cgNode.getMVSummary().get(param);
                        Util.addAll(this.MVvar_, mvlist);
                        if (mvlist.contains(cgNode.getFuncName())) {
                            this.MVvar_.remove(cgNode.getFuncName());
                            returnval = true;
                        }
                    }
                    ++i;
                }
            } else {
                String param = MPIMVAnalysis.this.getFormalParamName((ICallGraphNode)cgNode, 0);
                if (param != null) {
                    List<String> mvlist = cgNode.getMVSummary().get(param);
                    Util.addAll(this.MVvar_, mvlist);
                    if (mvlist.contains(cgNode.getFuncName())) {
                        this.MVvar_.remove(cgNode.getFuncName());
                        returnval = true;
                    }
                }
            }
            return returnval;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean useDefMVMapping(IASTExpression expr, int side, IASTFunctionCallExpression func, List<String> set) {
            boolean v1 = false;
            boolean v2 = false;
            boolean v3 = false;
            ArrayList<String> l1 = new ArrayList<String>();
            ArrayList<String> l2 = new ArrayList<String>();
            ArrayList<String> l3 = new ArrayList<String>();
            if (expr == null) {
                return false;
            }
            if (expr instanceof IASTAmbiguousExpression) return false;
            if (expr instanceof IASTArraySubscriptExpression) {
                IASTArraySubscriptExpression asE = (IASTArraySubscriptExpression)expr;
                if (side == 1) {
                    v1 = this.useDefMVMapping(asE.getArrayExpression(), 1, func, l1);
                    v2 = this.useDefMVMapping(asE.getSubscriptExpression(), 1, func, l2);
                } else {
                    v1 = this.useDefMVMapping(asE.getSubscriptExpression(), 1, func, l1);
                    v2 = this.useDefMVMapping(asE.getArrayExpression(), 0, func, l2);
                }
                Util.addAll(set, l1);
                Util.addAll(set, l2);
                return v1 | v2;
            }
            if (expr instanceof IASTBinaryExpression) {
                IASTBinaryExpression biE = (IASTBinaryExpression)expr;
                int op = biE.getOperator();
                if (op == 17) {
                    v1 = this.useDefMVMapping(biE.getOperand1(), 0, func, l1);
                    v2 = this.useDefMVMapping(biE.getOperand2(), 1, func, l2);
                    if (v2) {
                        Util.addAll(this.MVvar_, l1);
                    }
                    Util.addAll(set, l1);
                    Util.addAll(set, l2);
                    return v1 | v2 | v3;
                } else if (op == 18 || op == 19 || op == 20 || op == 21 || op == 22 || op == 23 || op == 24 || op == 25 || op == 26 || op == 27) {
                    v1 = this.useDefMVMapping(biE.getOperand1(), 1, func, l1);
                    v2 = this.useDefMVMapping(biE.getOperand2(), 1, func, l2);
                    v3 = this.useDefMVMapping(biE.getOperand1(), 0, func, l3);
                    if (v1 | v2) {
                        Util.addAll(this.MVvar_, l3);
                    }
                    Util.addAll(set, l1);
                    Util.addAll(set, l2);
                    Util.addAll(set, l3);
                    return v1 | v2 | v3;
                } else {
                    v1 = this.useDefMVMapping(biE.getOperand1(), 1, func, l1);
                    v2 = this.useDefMVMapping(biE.getOperand2(), 1, func, l2);
                    Util.addAll(set, l1);
                    Util.addAll(set, l2);
                }
                return v1 | v2 | v3;
            }
            if (expr instanceof IASTCastExpression) {
                IASTCastExpression castE = (IASTCastExpression)expr;
                v1 = this.useDefMVMapping(castE.getOperand(), side, func, l1);
                Util.addAll(set, l1);
                return v1;
            }
            if (expr instanceof IASTConditionalExpression) {
                IASTConditionalExpression condE = (IASTConditionalExpression)expr;
                if (side == 1) {
                    v1 = this.useDefMVMapping(condE.getLogicalConditionExpression(), 1, func, l1);
                    v2 = this.useDefMVMapping(condE.getPositiveResultExpression(), 1, func, l2);
                    v3 = this.useDefMVMapping(condE.getNegativeResultExpression(), 1, func, l3);
                } else {
                    v1 = this.useDefMVMapping(condE.getLogicalConditionExpression(), 1, func, l1);
                    v2 = this.useDefMVMapping(condE.getPositiveResultExpression(), 0, func, l2);
                    v3 = this.useDefMVMapping(condE.getNegativeResultExpression(), 0, func, l3);
                }
                Util.addAll(set, l1);
                Util.addAll(set, l2);
                Util.addAll(set, l3);
                return v1 | v2 | v3;
            }
            if (expr instanceof IASTExpressionList) {
                IASTExpressionList exprList = (IASTExpressionList)expr;
                IASTExpression[] exprs = exprList.getExpressions();
                boolean[] newContext_ = new boolean[exprs.length];
                int i = 0;
                while (i < exprs.length) {
                    newContext_[i] = v1 |= this.useDefMVMapping(exprs[i], side, func, l1);
                    Util.addAll(set, l1);
                    ++i;
                }
                if (func == null) return v1;
                this.exprListMVContext_.push(newContext_);
                return v1;
            }
            if (expr instanceof IASTFieldReference) {
                IASTFieldReference frE = (IASTFieldReference)expr;
                v1 = this.useDefMVMapping(frE.getFieldOwner(), side, func, l1);
                Util.addAll(set, l1);
                return v1;
            }
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcE = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcE.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                IASTExpression parameter = funcE.getParameterExpression();
                funcE.getArguments();
                MPICallGraphNode cgNode = (MPICallGraphNode)MPIMVAnalysis.this.cg_.getNode(MPIMVAnalysis.this.currentNode_.getFileName(), signature);
                if (cgNode != null) {
                    boolean returnval = false;
                    if (parameter != null) {
                        v1 = this.useDefMVMapping(parameter, side, funcE, l1);
                        returnval = this.oldParameterUse(parameter, cgNode, returnval);
                    }
                    for (String guse : cgNode.getGlobalUse()) {
                        if (!this.context_.contains(guse)) continue;
                        List<String> mvlist = cgNode.getMVSummary().get(guse);
                        Util.addAll(this.MVvar_, mvlist);
                        if (!mvlist.contains(cgNode.getFuncName())) continue;
                        this.MVvar_.remove(cgNode.getFuncName());
                        returnval = true;
                    }
                    if (cgNode.getMVSummary().size() != 1) return returnval;
                    List<String> mvlist = cgNode.getMVSummary().get(cgNode.getFuncName());
                    if (mvlist.size() != 1) return false;
                    if (!mvlist.contains(cgNode.getFuncName())) return false;
                    return true;
                }
                if (parameter == null) return false;
                v1 = this.useDefMVMapping(parameter, side, funcE, l1);
                if (parameter instanceof IASTExpressionList) {
                    this.exprListMVContext_.pop();
                }
                Util.addAll(set, l1);
                return v1;
            }
            if (expr instanceof IASTIdExpression) {
                IASTIdExpression id = (IASTIdExpression)expr;
                IASTName name = id.getName();
                String var = name.toString();
                if (var.startsWith("MPI_")) {
                    return false;
                }
                if (side == 1) {
                    if (func != null) {
                        IASTExpression funcname = func.getFunctionNameExpression();
                        String signature = funcname.getRawSignature();
                        ICallGraphNode n = MPIMVAnalysis.this.cg_.getNode(MPIMVAnalysis.this.currentNode_.getFileName(), signature);
                        if (n == null && this.currentBlock_.getDef().contains(var)) {
                            if (!set.contains(var)) {
                                set.add(var);
                            }
                            if (this.context_.contains(var) && !this.MVvar_.contains(var)) {
                                this.MVvar_.add(var);
                            }
                        }
                    }
                    if (!this.context_.contains(var)) return false;
                    return true;
                }
                if (set.contains(var)) return false;
                set.add(var);
                return false;
            }
            if (expr instanceof IASTLiteralExpression) return false;
            if (expr instanceof IASTProblemExpression) return false;
            if (expr instanceof IASTTypeIdExpression) return false;
            if (expr instanceof IASTUnaryExpression) {
                IASTUnaryExpression uE = (IASTUnaryExpression)expr;
                int op = uE.getOperator();
                if (op == 0 || op == 1 || op == 9 || op == 10) {
                    v1 = this.useDefMVMapping(uE.getOperand(), 1, func, l1);
                    v2 = this.useDefMVMapping(uE.getOperand(), 0, func, l2);
                    if (v1) {
                        Util.addAll(this.MVvar_, l2);
                    }
                    Util.addAll(set, l1);
                    Util.addAll(set, l2);
                    return v1 | v2;
                } else {
                    v1 = this.useDefMVMapping(uE.getOperand(), side, func, l1);
                    Util.addAll(set, l1);
                }
                return v1 | v2;
            }
            boolean cfr_ignored_0 = expr instanceof ICASTTypeIdInitializerExpression;
            return false;
        }

        private boolean useDefMVMapping(IASTStatement stmt) {
            if (stmt instanceof IASTDeclarationStatement) {
                boolean value = false;
                IASTDeclarationStatement declStmt = (IASTDeclarationStatement)stmt;
                IASTDeclaration decl = declStmt.getDeclaration();
                if (decl instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                    IASTDeclarator[] declarators = simpleDecl.getDeclarators();
                    int i = 0;
                    while (i < declarators.length) {
                        boolean v1 = false;
                        IASTInitializer init = declarators[i].getInitializer();
                        if (init != null) {
                            IASTName name = declarators[i].getName();
                            v1 = this.handleInitializer(init);
                            if (v1 && !this.MVvar_.contains(name.toString())) {
                                this.MVvar_.add(name.toString());
                            }
                        }
                        value |= v1;
                        ++i;
                    }
                }
                return value;
            }
            if (stmt instanceof IASTExpressionStatement) {
                IASTExpressionStatement exprS = (IASTExpressionStatement)stmt;
                IASTExpression expr = exprS.getExpression();
                ArrayList<String> mvlist = new ArrayList<String>();
                this.value = this.useDefMVMapping(expr, 1, null, mvlist);
            }
            return false;
        }
    }

    class FuncParamMVChecker
    extends ASTVisitor {
        protected MPICallGraphNode currentNode_;
        protected MPIBlock block_;
        protected MPICallGraphNode func;

        public FuncParamMVChecker(MPICallGraphNode func, MPIBlock block) {
            this.currentNode_ = func;
            this.block_ = block;
            func = null;
        }

        public int leave(IASTExpression expr) {
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcExpr = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcExpr.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                if (MPIMVAnalysis.this.cg_.getNode(this.currentNode_.getFileName(), signature) == this.func) {
                    this.func = null;
                }
            }
            return 3;
        }

        public void run() {
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            IASTNode content = this.block_.getContent();
            if (content != null) {
                content.accept((ASTVisitor)this);
            }
        }

        public int visit(IASTExpression expr) {
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcExpr = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcExpr.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                this.func = (MPICallGraphNode)MPIMVAnalysis.this.cg_.getNode(this.currentNode_.getFileName(), signature);
                if (this.func != null) {
                    IASTExpression parameter = funcExpr.getParameterExpression();
                    if (parameter instanceof IASTExpressionList) {
                        IASTExpressionList paramListE = (IASTExpressionList)parameter;
                        IASTExpression[] params = paramListE.getExpressions();
                        int i = 0;
                        while (i < params.length) {
                            String paramName;
                            ExprMVAnalyzer ema = new ExprMVAnalyzer(params[i], this.block_.getMVvar(), this.block_);
                            ema.run();
                            if (ema.isMV() && (paramName = MPIMVAnalysis.this.getFormalParamName((ICallGraphNode)this.func, i)) != null) {
                                this.func.getParamMV().put(paramName, new Boolean(true));
                            }
                            ++i;
                        }
                    } else if (parameter != null) {
                        String paramName;
                        ExprMVAnalyzer ema = new ExprMVAnalyzer(parameter, this.block_.getMVvar(), this.block_);
                        ema.run();
                        if (ema.isMV() && (paramName = MPIMVAnalysis.this.getFormalParamName((ICallGraphNode)this.func, 0)) != null) {
                            this.func.getParamMV().put(paramName, new Boolean(true));
                        }
                    }
                }
            }
            return 3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PointerAnalyzer
    extends ASTVisitor {
        protected IBlock block_;
        protected List<String> deref_;
        protected List<String> addr_;

        public PointerAnalyzer(IBlock b) {
            this.block_ = b;
            this.deref_ = new ArrayList<String>();
            this.addr_ = new ArrayList<String>();
        }

        public List<String> getAddr() {
            return this.addr_;
        }

        public List<String> getDeref() {
            return this.deref_;
        }

        public void run() {
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            IASTNode content = this.block_.getContent();
            if (content != null) {
                content.accept((ASTVisitor)this);
            }
        }

        public int visit(IASTExpression expr) {
            this.visitor(expr, false, false);
            return 1;
        }

        private void visitor(IASTExpression expr, boolean inDeref, boolean inAddr) {
            if (expr instanceof IASTArraySubscriptExpression) {
                IASTArraySubscriptExpression arrayE = (IASTArraySubscriptExpression)expr;
                this.visitor(arrayE.getArrayExpression(), inDeref, inAddr);
                this.visitor(arrayE.getSubscriptExpression(), false, false);
            } else if (expr instanceof IASTBinaryExpression) {
                IASTBinaryExpression biE = (IASTBinaryExpression)expr;
                this.visitor(biE.getOperand1(), inDeref, inAddr);
                this.visitor(biE.getOperand2(), inDeref, inAddr);
            } else if (expr instanceof IASTConditionalExpression) {
                IASTConditionalExpression condE = (IASTConditionalExpression)expr;
                this.visitor(condE.getLogicalConditionExpression(), inDeref, inAddr);
                this.visitor(condE.getPositiveResultExpression(), inDeref, inAddr);
                this.visitor(condE.getNegativeResultExpression(), inDeref, inAddr);
            } else if (expr instanceof IASTExpressionList) {
                IASTExpressionList listE = (IASTExpressionList)expr;
                IASTExpression[] exprs = listE.getExpressions();
                int i = 0;
                while (i < exprs.length) {
                    this.visitor(exprs[i], inDeref, inAddr);
                    ++i;
                }
            } else if (expr instanceof IASTFieldReference) {
                IASTFieldReference fr = (IASTFieldReference)expr;
                this.visitor(fr.getFieldOwner(), inDeref, inAddr);
            } else if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcE = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcE.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                ICallGraphNode n = MPIMVAnalysis.this.cg_.getNode(MPIMVAnalysis.this.currentNode_.getFileName(), signature);
                if (n != null) {
                    return;
                }
                this.visitor(funcE.getFunctionNameExpression(), false, false);
                this.visitor(funcE.getParameterExpression(), inDeref, inAddr);
            } else if (expr instanceof IASTIdExpression) {
                IASTIdExpression ID = (IASTIdExpression)expr;
                String var = ID.getName().toString();
                if (inDeref && !this.deref_.contains(var)) {
                    this.deref_.add(var);
                }
                if (inAddr && !this.addr_.contains(var)) {
                    this.addr_.add(var);
                }
            } else if (expr instanceof IASTUnaryExpression) {
                IASTUnaryExpression uE = (IASTUnaryExpression)expr;
                int op = uE.getOperator();
                boolean addrflag = inAddr;
                boolean derefflag = inDeref;
                if (op == 5) {
                    addrflag = true;
                } else if (op == 4) {
                    derefflag = true;
                }
                this.visitor(uE.getOperand(), addrflag, derefflag);
            }
        }
    }

    class SeedsCollector
    extends ASTVisitor {
        private MPICallGraphNode currentFunc_;

        SeedsCollector() {
        }

        public void run() {
            MPICallGraphNode node;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            ICallGraphNode n = MPIMVAnalysis.this.cg_.botEntry();
            while (n != null) {
                node = (MPICallGraphNode)n;
                if (node.marked) {
                    this.currentFunc_ = node;
                    IControlFlowGraph cfg = node.getCFG();
                    IBlock b = cfg.getEntry();
                    while (b != null) {
                        IASTNode content = b.getContent();
                        if (content != null) {
                            content.accept((ASTVisitor)this);
                        }
                        b = b.topNext();
                    }
                }
                n = n.botNext();
            }
            n = MPIMVAnalysis.this.cg_.botEntry();
            while (n != null) {
                node = (MPICallGraphNode)n;
                if (node.marked && node.hasSeed()) {
                    for (MPICallGraphNode caller : node.getCallers()) {
                        caller.setSeed(true);
                    }
                }
                n = n.botNext();
            }
        }

        public int visit(IASTExpression expr) {
            IASTFunctionCallExpression funcExpr;
            IASTExpression funcname;
            String signature;
            if (expr instanceof IASTFunctionCallExpression && (signature = (funcname = (funcExpr = (IASTFunctionCallExpression)expr).getFunctionNameExpression()).getRawSignature()).equals("MPI_Comm_rank")) {
                this.currentFunc_.setSeed(true);
            }
            return 3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WorkListCollector
    extends ASTVisitor {
        private final ICallGraphNode func_;
        private boolean inRankFunc;
        private IASTExpressionList paramsOLD;
        private IASTInitializerClause[] params_;
        private final LinkedList<IBlock> wlist;
        private MPIBlock currentBlock_;

        public WorkListCollector(ICallGraphNode func) {
            this.func_ = func;
            this.inRankFunc = false;
            this.wlist = new LinkedList();
        }

        public LinkedList<IBlock> getWorkList() {
            if (!((MPICallGraphNode)this.func_).hasSeed()) {
                return this.wlist;
            }
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            IBlock b = this.func_.getCFG().getEntry();
            while (b != null) {
                this.currentBlock_ = (MPIBlock)b;
                IASTNode content = b.getContent();
                if (content != null) {
                    content.accept((ASTVisitor)this);
                }
                b = b.topNext();
            }
            return this.wlist;
        }

        public int leave(IASTExpression expr) {
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcExpr = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcExpr.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                if (signature.equals("MPI_Comm_rank")) {
                    this.inRankFunc = false;
                }
                this.params_ = null;
                this.paramsOLD = null;
            } else if (expr instanceof IASTExpressionList) {
                this.paramsOLD = null;
            }
            return 3;
        }

        public int visit(IASTExpression expr) {
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcExpr = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcExpr.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                if (signature.equals("MPI_Comm_rank")) {
                    this.inRankFunc = true;
                } else {
                    MPICallGraphNode n = (MPICallGraphNode)MPIMVAnalysis.this.cg_.getNode(MPIMVAnalysis.this.currentNode_.getFileName(), signature);
                    if (n != null && n.hasSeed()) {
                        if (!this.wlist.contains((Object)this.currentBlock_)) {
                            this.wlist.add((IBlock)this.currentBlock_);
                        }
                        List<String> genMV = n.getMVSummary().get(signature);
                        Util.addAll(this.currentBlock_.getMVvar(), genMV);
                        if (this.currentBlock_.getMVvar().contains(n.getFuncName())) {
                            this.currentBlock_.getMVvar().remove(n.getFuncName());
                        }
                    }
                }
                if (this.inRankFunc) {
                    IASTInitializerClause[] initClause = funcExpr.getArguments();
                    this.params_ = initClause;
                }
            } else if (expr instanceof IASTIdExpression) {
                ((IASTIdExpression)expr).getName().toString();
                if (this.inRankFunc) {
                    IASTExpression me = expr;
                    IASTNode parent = me.getParent();
                    while (!(parent instanceof IASTFunctionCallExpression)) {
                        me = parent;
                        parent = parent.getParent();
                    }
                    me.getRawSignature();
                    boolean temp = false;
                    if (temp && !(parent instanceof IASTExpressionList)) {
                        return 3;
                    }
                    if (this.params_ != null) {
                        IASTInitializerClause cl = this.params_[0];
                        boolean cfr_ignored_0 = cl instanceof IASTIdExpression;
                    }
                    int index = 0;
                    while (index < this.params_.length) {
                        if (me == this.params_[index]) break;
                        ++index;
                    }
                    if (index == 1) {
                        IASTIdExpression id = (IASTIdExpression)expr;
                        String var = id.getName().toString();
                        if (!this.currentBlock_.getMVvar().contains(var)) {
                            this.currentBlock_.getMVvar().add(var);
                        }
                        if (!this.wlist.contains((Object)this.currentBlock_)) {
                            this.wlist.add((IBlock)this.currentBlock_);
                        }
                    }
                }
            } else if (expr instanceof IASTExpressionList && this.inRankFunc) {
                this.paramsOLD = (IASTExpressionList)expr;
            }
            return 3;
        }
    }
}

