/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.attributes.QueueAttributes;
import org.eclipse.ptp.core.elements.listeners.IQueueListener;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.QueueChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PQueue
extends Parent
implements IPQueue {
    private final ListenerList fElementListeners = new ListenerList();
    private final Map<String, IPJob> fJobs = new HashMap<String, IPJob>();
    private final String fControlId;

    public PQueue(String id, String controlId, IPElement parent, IAttribute<?, ?, ?>[] attrs) {
        super(id, parent, attrs);
        this.fControlId = controlId;
        IAttribute state = (EnumeratedAttribute)this.getAttribute(QueueAttributes.getStateAttributeDefinition());
        if (state == null) {
            state = QueueAttributes.getStateAttributeDefinition().create();
            this.addAttribute(state);
        }
    }

    @Override
    public void addElementListener(IQueueListener listener) {
        this.fElementListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobs(Collection<IPJob> jobs) {
        Map<String, IPJob> map = this.fJobs;
        synchronized (map) {
            for (IPJob job : jobs) {
                this.fJobs.put(job.getID(), job);
            }
        }
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        this.fireChangedQueue(attrs);
    }

    private void fireChangedQueue(AttributeManager attrs) {
        QueueChangeEvent e = new QueueChangeEvent(this, attrs);
        Object[] objectArray = this.fElementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IQueueListener)listener).handleEvent(e);
            ++n2;
        }
    }

    @Override
    public IPJob[] getJobs() {
        return this.fJobs.values().toArray(new IPJob[this.fJobs.size()]);
    }

    @Override
    public String getControlId() {
        return this.fControlId;
    }

    @Override
    public QueueAttributes.State getState() {
        return (QueueAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(QueueAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public void removeElementListener(IQueueListener listener) {
        this.fElementListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJobs(Collection<IPJob> jobs) {
        Map<String, IPJob> map = this.fJobs;
        synchronized (map) {
            for (IPJob job : jobs) {
                this.fJobs.remove(job.getID());
            }
        }
    }
}

