/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.listeners.ILMLListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.IPattern;
import org.eclipse.ptp.rm.lml.internal.core.elements.RequestType;
import org.eclipse.ptp.rm.lml.internal.core.events.LguiAddedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.LguiRemovedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.MarkObjectEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.SelectObjectEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.TableFilterEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.TableSortedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.UnmarkObjectEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.UnselectObjectEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.ViewUpdateEvent;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiItem;

public class LMLManager {
    protected final Map<String, ILguiItem> LGUIS = new HashMap<String, ILguiItem>();
    private ILguiItem fLguiItem = null;
    private final ListenerList viewListeners = new ListenerList();
    private static LMLManager manager;
    private boolean isDisplayed = false;

    public static LMLManager getInstance() {
        if (manager == null) {
            manager = new LMLManager();
        }
        return manager;
    }

    private LMLManager() {
        manager = this;
    }

    public void addListener(ILMLListener listener, String view) {
        this.viewListeners.add((Object)listener);
    }

    public void addUserJob(String name, String jobId, JobStatusData status) {
        ILguiItem item = this.LGUIS.get(name);
        if (item != null) {
            item.addUserJob(jobId, status, true);
        }
        if (item == this.fLguiItem) {
            this.fireUpdatedLgui();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLgui(String name) {
        ILguiItem item = null;
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            item = this.LGUIS.get(name);
            if (item != null) {
                if (this.fLguiItem == item) {
                    this.selectLgui(null);
                }
                this.LGUIS.remove(name);
            }
        }
    }

    public void filterLgui(String gid, List<IPattern> filterValues) {
        this.fireFilterLgui(gid, filterValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentLayout(String name) {
        ILguiItem item = null;
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            item = this.LGUIS.get(name);
        }
        if (item != null) {
            if (this.fLguiItem != null && this.fLguiItem == item) {
                this.fireRemovedLgui(item);
                this.fLguiItem = null;
            }
            String string = item.saveCurrentLayout();
            return string;
        }
        return null;
    }

    public ILguiItem getSelectedLguiItem() {
        return this.fLguiItem;
    }

    public JobStatusData getUserJob(String name, String jobId) {
        ILguiItem item = this.LGUIS.get(name);
        if (item != null) {
            return item.getUserJob(jobId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatusData[] getUserJobs(String name) {
        ILguiItem item = null;
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            item = this.LGUIS.get(name);
            if (item != null) {
                return item.getUserJobs();
            }
        }
        return null;
    }

    public void markObject(String oid) {
        this.fireMarkObject(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openLgui(String name, String username, RequestType request, String layout, JobStatusData[] jobs) {
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            ILguiItem item = this.LGUIS.get(name);
            if (item == null) {
                item = new LguiItem(name, username);
                this.LGUIS.put(name, item);
            }
            this.fLguiItem = item;
        }
        this.fLguiItem.reloadLastLayout(layout);
        this.fLguiItem.setRequest(request);
        this.restoreJobStatusData(this.fLguiItem, jobs);
        if (!this.fLguiItem.isEmpty()) {
            this.fireNewLgui();
        }
    }

    public void removeListener(ILMLListener listener) {
        this.viewListeners.remove((Object)listener);
    }

    public void removeUserJob(String name, String jobId) {
        ILguiItem lguiItem = this.LGUIS.get(name);
        if (lguiItem != null) {
            lguiItem.removeUserJob(jobId);
        }
        if (lguiItem == this.fLguiItem) {
            this.fireUpdatedLgui();
        }
    }

    public void selectLgui(String name) {
        ILguiItem item;
        if (name != null && this.fLguiItem != null && this.fLguiItem.toString().equals(name)) {
            return;
        }
        if (this.fLguiItem != null) {
            this.fLguiItem = null;
            this.fireRemovedLgui(null);
        }
        if (name != null && (item = this.LGUIS.get(name)) != null) {
            this.fLguiItem = item;
            this.fireNewLgui();
            return;
        }
    }

    public void selectObject(String oid) {
        this.fireChangeSelectedObject(oid);
    }

    public void sortLgui() {
        this.fireSortedLgui();
    }

    public void unmarkObject(String oid) {
        this.fireUnmarkObject(oid);
    }

    public void unselectObject(String oid) {
        this.fireUnselectObject(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String name, InputStream input, OutputStream output) throws CoreException {
        ILguiItem lguiItem = null;
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            lguiItem = this.LGUIS.get(name);
        }
        if (lguiItem != null) {
            lguiItem.getCurrentLayout(output);
            lguiItem.update(input);
            if (this.fLguiItem == lguiItem) {
                if (!this.isDisplayed) {
                    this.fireNewLgui();
                } else {
                    this.fireUpdatedLgui();
                }
            }
        }
    }

    public void updateUserJob(String name, String jobId, String status, String detail) {
        ILguiItem lguiItem = this.LGUIS.get(name);
        if (lguiItem != null) {
            lguiItem.updateUserJob(jobId, status, detail);
        }
        if (lguiItem == this.fLguiItem) {
            this.fireUpdatedLgui();
        }
    }

    private void fireChangeSelectedObject(String oid) {
        SelectObjectEvent event = new SelectObjectEvent(oid);
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireFilterLgui(String gid, List<IPattern> filterValues) {
        TableFilterEvent event = new TableFilterEvent(gid, filterValues);
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireMarkObject(String oid) {
        MarkObjectEvent event = new MarkObjectEvent(oid);
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireNewLgui() {
        LguiAddedEvent event = new LguiAddedEvent();
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
        this.isDisplayed = true;
    }

    private void fireRemovedLgui(ILguiItem title) {
        LguiRemovedEvent event = new LguiRemovedEvent();
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
        this.isDisplayed = false;
    }

    private void fireSortedLgui() {
        TableSortedEvent event = new TableSortedEvent(this, this.fLguiItem);
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireUnmarkObject(String oid) {
        UnmarkObjectEvent event = new UnmarkObjectEvent(oid);
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireUnselectObject(String oid) {
        UnselectObjectEvent event = new UnselectObjectEvent(oid);
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireUpdatedLgui() {
        ViewUpdateEvent event = new ViewUpdateEvent();
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void restoreJobStatusData(ILguiItem item, JobStatusData[] jobs) {
        if (jobs != null && jobs.length > 0) {
            JobStatusData[] jobStatusDataArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                JobStatusData status = jobStatusDataArray[n2];
                item.addUserJob(status.getJobId(), status, false);
                ++n2;
            }
        }
    }
}

