/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.wizards;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.SyncBuildServiceProvider;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.wizards.SyncMainWizardPage;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class NewRemoteSyncProjectWizardOperation {
    public static void run(IProject project, SyncMainWizardPage mainPage, IProgressMonitor monitor) {
        IConfiguration[] allConfigs;
        try {
            RemoteSyncNature.addNature((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        ISynchronizeParticipant participant = mainPage.getSynchronizeParticipant();
        if (participant == null) {
            return;
        }
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.newServiceConfiguration(NewRemoteSyncProjectWizardOperation.getConfigName(project.getName()));
        IService syncService = smm.getService("org.eclipse.ptp.rdt.sync.core.SyncService");
        serviceConfig.setServiceProvider(syncService, (IServiceProvider)participant.getProvider(project));
        IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
        IServiceProviderDescriptor descriptor = buildService.getProviderDescriptor("org.eclipse.ptp.rdt.sync.BuildServiceProvider");
        SyncBuildServiceProvider rbsp = (SyncBuildServiceProvider)smm.getServiceProvider(descriptor);
        if (rbsp != null) {
            IRemoteConnection remoteConnection = participant.getProvider(project).getRemoteConnection();
            rbsp.setRemoteToolsConnection(remoteConnection);
            serviceConfig.setServiceProvider(buildService, (IServiceProvider)rbsp);
        }
        smm.addConfiguration(project, serviceConfig);
        try {
            smm.saveModelConfiguration();
        }
        catch (IOException e) {
            RDTSyncUIPlugin.log(e.toString(), e);
        }
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        ISyncServiceProvider provider = participant.getProvider(project);
        BuildScenario remoteBuildScenario = new BuildScenario(provider.getName(), provider.getRemoteConnection(), provider.getLocation());
        bcm.setBuildScenarioForAllBuildConfigurations(project, remoteBuildScenario);
        BuildScenario localBuildScenario = null;
        try {
            localBuildScenario = bcm.createLocalBuildScenario(project);
        }
        catch (CoreException coreException) {}
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            throw new RuntimeException("Build information for project not found. Project name: " + project.getName());
        }
        boolean defaultConfigSet = false;
        IConfiguration[] iConfigurationArray = allConfigs = buildInfo.getManagedProject().getConfigurations();
        int n = allConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            boolean isRemote = mainPage.isRemoteConfig(config);
            boolean isLocal = mainPage.isLocalConfig(config);
            if (isLocal && isRemote) {
                IConfiguration localConfig = bcm.createConfiguration(project, (Configuration)config, localBuildScenario, config.getName(), null);
                bcm.modifyConfigurationAsSyncLocal(localConfig);
            }
            if (isLocal && !isRemote) {
                bcm.setBuildScenarioForBuildConfiguration(localBuildScenario, config);
                bcm.modifyConfigurationAsSyncLocal(config);
            }
            if (isRemote) {
                bcm.modifyConfigurationAsSyncRemote(config);
                if (!defaultConfigSet) {
                    ManagedBuildManager.setDefaultConfiguration((IProject)project, (IConfiguration)config);
                    defaultConfigSet = true;
                }
            }
            config.setName(config.getName().replace(' ', '_'));
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        SyncFileFilter customFilter = mainPage.getCustomFileFilter();
        if (customFilter != null) {
            SyncManager.saveFileFilter((IProject)project, (SyncFileFilter)customFilter);
        }
        SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.ACTIVE);
    }

    private static String getConfigName(String candidateName) {
        Set configs = ServiceModelManager.getInstance().getConfigurations();
        HashSet<String> existingNames = new HashSet<String>();
        for (IServiceConfiguration config : configs) {
            existingNames.add(config.getName());
        }
        int i = 2;
        String newConfigName = candidateName;
        while (existingNames.contains(newConfigName)) {
            newConfigName = String.valueOf(candidateName) + " (" + i++ + ")";
        }
        return newConfigName;
    }
}

