/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.make.core.scannerconfig.offline;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.internal.rdt.make.core.scannerconfig.offline.OfflineBuildOutputParserUtility;
import org.eclipse.ptp.internal.rdt.make.core.scannerconfig.offline.OfflineTraceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineGCCScannerInfoConsoleParser
implements IScannerInfoConsoleParser {
    protected OfflineBuildOutputParserUtility fUtil = null;
    private String fDefaultMacroDefinitionValue = "1";
    protected IScannerInfoCollector collector;
    protected static final String DASHIDASH = "-I-";
    protected static final String DASHI = "-I";
    protected static final String DASHD = "-D";
    private boolean bMultiline = false;
    private String sMultiline = "";
    protected static final String[] COMPILER_INVOCATION = new String[]{"gcc", "g++", "cc", "c++"};
    protected String[] fCompilerCommands;

    public OfflineGCCScannerInfoConsoleParser(String baseDirectory, String buildDirectory, IScannerInfoCollector collector) {
        this.fUtil = buildDirectory != null && buildDirectory.length() > 0 ? new OfflineBuildOutputParserUtility(baseDirectory, buildDirectory) : new OfflineBuildOutputParserUtility(baseDirectory, null);
        this.fCompilerCommands = this.computeCompilerCommands();
        this.collector = collector;
    }

    protected IScannerInfoCollector getCollector() {
        return this.collector;
    }

    protected boolean processCommand(String[] tokens) {
        int compilerInvocationIdx = this.findCompilerInvocation(tokens);
        if (compilerInvocationIdx < 0) {
            return false;
        }
        if (compilerInvocationIdx + 1 >= tokens.length) {
            return false;
        }
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> symbols = new ArrayList<String>();
        ArrayList<String> targetSpecificOptions = new ArrayList<String>();
        String fileName = null;
        int j = compilerInvocationIdx + 1;
        while (j < tokens.length) {
            String token = tokens[j];
            if (!token.equals(DASHIDASH)) {
                String possibleFileName;
                String candidate;
                if (token.startsWith(DASHI)) {
                    candidate = null;
                    if (token.length() > 2) {
                        candidate = token.substring(2).trim();
                    } else if (j + 1 < tokens.length) {
                        candidate = tokens[j + 1];
                        if (candidate.startsWith("-")) {
                            candidate = null;
                        } else {
                            ++j;
                        }
                    }
                    if (candidate != null && candidate.length() > 0) {
                        if (this.fUtil != null) {
                            candidate = this.fUtil.normalizePath(candidate);
                        }
                        if (!includes.contains(candidate)) {
                            includes.add(candidate);
                        }
                    }
                } else if (token.startsWith(DASHD)) {
                    candidate = null;
                    if (token.length() > 2) {
                        candidate = token.substring(2).trim();
                    } else if (j + 1 < tokens.length) {
                        candidate = tokens[j + 1];
                        if (candidate.startsWith("-")) {
                            candidate = null;
                        } else {
                            ++j;
                        }
                    }
                    if (candidate != null && candidate.length() > 0) {
                        if (candidate.indexOf(61) == -1) {
                            candidate = String.valueOf(candidate) + '=' + this.fDefaultMacroDefinitionValue;
                        }
                        if (!symbols.contains(candidate)) {
                            symbols.add(candidate);
                        }
                    }
                } else if (token.startsWith("-m") || token.startsWith("--sysroot") || token.equals("-ansi") || token.equals("-nostdinc") || token.equals("-posix") || token.equals("-pthread") || token.startsWith("-O") || token.equals("-fno-inline") || token.startsWith("-finline") || token.equals("-fno-exceptions") || token.equals("-fexceptions") || token.equals("-fshort-wchar") || token.equals("-fshort-double") || token.equals("-fno-signed-char") || token.equals("-fsigned-char") || token.startsWith("-fabi-version=")) {
                    if (!targetSpecificOptions.contains(token)) {
                        targetSpecificOptions.add(token);
                    }
                } else if (fileName == null && ((possibleFileName = token.toLowerCase()).endsWith(".c") || possibleFileName.endsWith(".cpp") || possibleFileName.endsWith(".cc") || possibleFileName.endsWith(".cxx") || possibleFileName.endsWith(".C") || possibleFileName.endsWith(".CPP") || possibleFileName.endsWith(".CC") || possibleFileName.endsWith(".CXX") || possibleFileName.endsWith(".c++"))) {
                    fileName = token;
                }
            }
            ++j;
        }
        if (fileName == null || fileName.trim().length() == 0) {
            return false;
        }
        IPath filePath = null;
        List<String> translatedIncludes = includes;
        if (includes.size() > 0) {
            if (this.fUtil != null && (filePath = this.fUtil.getAbsolutePath(fileName)) != null) {
                translatedIncludes = this.fUtil.translateRelativePaths(filePath, fileName, includes);
            }
            if (filePath == null && this.fUtil != null) {
                Iterator iterator = translatedIncludes.iterator();
                while (iterator.hasNext()) {
                    String include = (String)iterator.next();
                    Path includePath = new Path(include);
                    if (includePath.isAbsolute() || includePath.isUNC()) continue;
                    iterator.remove();
                }
            }
        }
        File jfile = null;
        if (filePath != null) {
            jfile = new File(filePath.toOSString());
        }
        if (translatedIncludes.size() > 0 || symbols.size() > 0) {
            HashMap<ScannerInfoTypes, ArrayList<String>> scannerInfo = new HashMap<ScannerInfoTypes, ArrayList<String>>();
            scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, (ArrayList<String>)translatedIncludes);
            scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, symbols);
            scannerInfo.put(ScannerInfoTypes.TARGET_SPECIFIC_OPTION, targetSpecificOptions);
            this.getCollector().contributeToScannerConfig((Object)jfile, scannerInfo);
            OfflineTraceUtil.outputTrace("Discovered scanner info for file '" + fileName + '\'', "Include paths", includes, translatedIncludes, "Defined symbols", symbols);
        }
        return true;
    }

    public boolean processLine(String line) {
        boolean rc = false;
        int lineBreakPos = line.length() - 1;
        char[] lineChars = line.toCharArray();
        while (lineBreakPos >= 0 && Character.isWhitespace(lineChars[lineBreakPos])) {
            --lineBreakPos;
        }
        if (lineBreakPos >= 0 && (lineChars[lineBreakPos] != '\\' || lineBreakPos > 0 && lineChars[lineBreakPos - 1] == '\\')) {
            lineBreakPos = -1;
        }
        if (lineBreakPos >= 0) {
            this.sMultiline = String.valueOf(this.sMultiline) + line.substring(0, lineBreakPos);
            this.bMultiline = true;
            return rc;
        }
        if (this.bMultiline) {
            line = String.valueOf(this.sMultiline) + line;
            this.bMultiline = false;
            this.sMultiline = "";
        }
        line = line.trim();
        OfflineTraceUtil.outputTrace("AbstractGCCBOPConsoleParser parsing line: [", line, "]");
        int firstColon = line.indexOf(58);
        String make = line.substring(0, firstColon + 1);
        if (firstColon != -1 && make.indexOf("make") != -1) {
            boolean enter = false;
            String msg = line.substring(firstColon + 1).trim();
            enter = msg.startsWith("AbstractGCCBOPConsoleParser_EnteringDirectory");
            if (enter || msg.startsWith("AbstractGCCBOPConsoleParser_LeavingDirectory")) {
                int s = msg.indexOf(96);
                int e = msg.indexOf(39);
                if (s != -1 && e != -1) {
                    String dir = msg.substring(s + 1, e);
                    if (this.getUtility() != null) {
                        this.getUtility().changeMakeDirectory(dir, this.getDirectoryLevel(line), enter);
                    }
                    return rc;
                }
            }
        }
        return this.processSingleLine(line.trim());
    }

    private int getDirectoryLevel(String line) {
        int s = line.indexOf(91);
        int num = 0;
        if (s != -1) {
            int e = line.indexOf(93);
            String number = line.substring(s + 1, e).trim();
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return num;
    }

    protected String[][] tokenize(String line, boolean escapeInsideDoubleQuotes) {
        ArrayList<String[]> commands = new ArrayList<String[]>();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        char[] input = line.toCharArray();
        boolean nextEscaped = false;
        char currentQuote = '\u0000';
        int i = 0;
        while (i < input.length) {
            char c = input[i];
            boolean escaped = nextEscaped;
            nextEscaped = false;
            if (currentQuote != '\u0000') {
                if (c == currentQuote) {
                    if (escaped) {
                        token.append(c);
                    } else {
                        if (c == '`') {
                            token.append(c);
                        }
                        currentQuote = '\u0000';
                    }
                } else if (escapeInsideDoubleQuotes && currentQuote == '\"' && c == '\\') {
                    boolean bl = nextEscaped = !escaped;
                    if (escaped) {
                        token.append(c);
                    }
                } else {
                    if (escaped) {
                        token.append('\\');
                    }
                    token.append(c);
                }
            } else {
                switch (c) {
                    case '\\': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        nextEscaped = true;
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '`': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        if (c == '`') {
                            token.append(c);
                        }
                        currentQuote = c;
                        break;
                    }
                    case ';': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        this.endCommand(token, tokens, commands);
                        break;
                    }
                    case '&': 
                    case '|': {
                        if (escaped || i + 1 >= input.length || input[i + 1] != c) {
                            token.append(c);
                            break;
                        }
                        ++i;
                        this.endCommand(token, tokens, commands);
                        break;
                    }
                    default: {
                        if (Character.isWhitespace(c)) {
                            if (escaped) {
                                token.append(c);
                                break;
                            }
                            this.endToken(token, tokens);
                            break;
                        }
                        if (escaped) {
                            token.append('\\');
                        }
                        token.append(c);
                    }
                }
            }
            ++i;
        }
        this.endCommand(token, tokens, commands);
        return (String[][])commands.toArray((T[])new String[commands.size()][]);
    }

    private void endCommand(StringBuffer token, ArrayList<String> tokens, ArrayList<String[]> commands) {
        this.endToken(token, tokens);
        if (!tokens.isEmpty()) {
            commands.add(tokens.toArray(new String[tokens.size()]));
            tokens.clear();
        }
    }

    private void endToken(StringBuffer token, ArrayList<String> tokens) {
        if (token.length() > 0) {
            tokens.add(token.toString());
            token.setLength(0);
        }
    }

    protected boolean processSingleLine(String line) {
        boolean rc = false;
        String[][] tokens = this.tokenize(line, true);
        int i = 0;
        while (i < tokens.length) {
            String[] command = tokens[i];
            if (this.processCommand(command)) {
                rc = true;
            } else {
                int j = 0;
                while (j < command.length) {
                    String[][] subtokens = this.tokenize(command[j], true);
                    int k = 0;
                    while (k < subtokens.length) {
                        String[] subcommand = subtokens[k];
                        if (subcommand.length > 1 && this.processCommand(subcommand)) {
                            rc = true;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return rc;
    }

    protected int findCompilerInvocation(String[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].toLowerCase();
            int searchFromOffset = Math.max(token.lastIndexOf(47), token.lastIndexOf(92)) + 1;
            int j = 0;
            while (j < this.fCompilerCommands.length) {
                if (token.indexOf(this.fCompilerCommands[j], searchFromOffset) != -1) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    private String[] computeCompilerCommands() {
        return COMPILER_INVOCATION;
    }

    protected OfflineBuildOutputParserUtility getUtility() {
        return this.fUtil;
    }

    public void shutdown() {
    }

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
    }
}

