/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2HostMap;

public class MPICH2TraceParser {
    private String errorMessage = null;
    private final MPICH2HostMap map = new MPICH2HostMap();
    private static Pattern pattern = Pattern.compile("([^_]+)_([0-9])+ \\(([0-9.]+)\\)");

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean parse(BufferedReader reader) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) {
                    this.errorMessage = line;
                    while ((line = reader.readLine()) != null) {
                        this.errorMessage = String.valueOf(this.errorMessage) + line + "\n";
                    }
                    return false;
                }
                if (!matcher.matches() || matcher.groupCount() != 3) continue;
                String host = matcher.group(1);
                String port = matcher.group(2);
                String addr = matcher.group(3);
                this.map.addHost(host, addr, port);
                DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)("found host " + host + " addr " + addr + " port " + port));
            }
            return true;
        }
        catch (IOException e) {
            this.errorMessage = e.getLocalizedMessage();
            return false;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MPICH2HostMap getHostMap() {
        return this.map;
    }
}

