/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTIntConstNode;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTSeparatedListNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineArgNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineParNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class AddSubroutineParameterRefactoring
extends FortranEditorRefactoring {
    private ASTSubroutineStmtNode selectedSubroutine;
    private List<ASTSubroutineParNode> oldParameterList;
    private List<ASTSubroutineParNode> newParameterList;
    private int position = 0;
    private String parameterName = null;
    private String declaration = "integer, intent(in) :: newName";
    private String defaultValue = "0";
    private ASTTypeDeclarationStmtNode declStmt = null;
    private String type = "integer";

    public List<ASTSubroutineParNode> getOldParameterList() {
        return this.oldParameterList;
    }

    public String getDeclaration() {
        assert (this.declaration != null);
        return this.declaration;
    }

    public int getPosition() {
        return this.position;
    }

    public String getDefault() {
        assert (this.defaultValue != null);
        return this.defaultValue;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setDeclaration(String declaration) {
        String[] declArgs = declaration.split(",");
        String[] validTypes = new String[]{"integer", "real", "logical", "double", "character"};
        boolean hasTypeDefined = false;
        int i = 0;
        while (i < validTypes.length) {
            if (validTypes[i].equals(declArgs[0])) {
                hasTypeDefined = true;
                this.type = declArgs[0];
                break;
            }
            ++i;
        }
        if (!hasTypeDefined) {
            this.type = "real";
            declaration = declArgs.length == 1 ? "real, " + declaration : "real :: " + declaration;
        }
        this.declaration = declaration;
    }

    public void setDefaultValue(String defValue) {
        this.defaultValue = defValue;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.ensureSubroutineIsSelected();
        if (!this.matchingDeclarationsInInterfacesUniquelyBind()) {
            status.addWarning(Messages.AddSubroutineParameterRefactoring_matchingDeclarationsDoNotUniquelyBind);
        }
        this.oldParameterList = this.getSubroutineParameters();
    }

    private void ensureSubroutineIsSelected() throws VPGRefactoring.PreconditionFailure {
        IASTNode temporaryNode = AddSubroutineParameterRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (temporaryNode == null) {
            this.fail(Messages.AddSubroutineParameterRefactoring_selectSubroutineError);
        }
        if (temporaryNode instanceof ASTSubroutineSubprogramNode) {
            this.selectedSubroutine = ((ASTSubroutineSubprogramNode)temporaryNode).getSubroutineStmt();
        } else if (temporaryNode instanceof ASTSubroutineStmtNode) {
            if (temporaryNode.findNearestAncestor(ASTSubroutineSubprogramNode.class) == null) {
                this.fail(Messages.AddSubroutineParameterRefactoring_selectSubroutineError);
            }
            this.selectedSubroutine = (ASTSubroutineStmtNode)temporaryNode;
        } else {
            this.fail(Messages.AddSubroutineParameterRefactoring_selectSubroutineError);
        }
    }

    private boolean matchingDeclarationsInInterfacesUniquelyBind() {
        for (Definition declaration : this.getInterfaceDeclarations()) {
            if (declaration.resolveInterfaceBinding().size() == 1) continue;
            return false;
        }
        return true;
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureDeclarationIsValid();
        this.parameterName = ((ASTEntityDeclNode)this.declStmt.getEntityDeclList().get(0)).getObjectName().getObjectName().getText();
        this.ensurePositionIsValid();
        this.ensureDefaultValueIsValid();
        this.checkForConflictingBindings(pm, status);
    }

    private void ensureDefaultValueIsValid() throws VPGRefactoring.PreconditionFailure {
        if (this.defaultValue == null || this.defaultValue.equals("") || this.isWhiteSpace(this.defaultValue) || this.isVariableNameBeginningWithNumber(this.defaultValue) || this.isTrueOrFalse(this.defaultValue) && !this.type.equals("logical") || this.isANumber(this.defaultValue) && !this.type.equals("integer") && !this.type.equals("real") || this.isRealAndNotInteger(this.defaultValue) && this.type.equals("integer") || this.defaultValue.equals("null") && !this.declaration.contains("pointer")) {
            this.fail(Messages.AddSubroutineParameterRefactoring_InvalidDefaultValue);
        }
    }

    private boolean isRealAndNotInteger(String str) {
        if (this.isANumber(str)) {
            try {
                Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        return false;
    }

    private boolean isTrueOrFalse(String str) {
        if (str == null) {
            return false;
        }
        return str.equals(".true.") || str.equals(".false.");
    }

    private boolean isVariableNameBeginningWithNumber(String str) {
        return str != null && str.length() != 0 && this.isANumber(str.substring(0, 1)) && !this.isANumber(str);
    }

    private boolean isANumber(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private void ensurePositionIsValid() throws VPGRefactoring.PreconditionFailure {
        if (this.position > this.oldParameterList.size() || this.position < 0) {
            this.fail(Messages.AddSubroutineParameterRefactoring_InvalidParameterPosition);
        }
    }

    private void ensureDeclarationIsValid() throws VPGRefactoring.PreconditionFailure {
        IBodyConstruct decl = AddSubroutineParameterRefactoring.parseLiteralStatementNoFail(this.declaration);
        if (decl == null || !(decl instanceof ASTTypeDeclarationStmtNode)) {
            this.fail(Messages.AddSubroutineParameterRefactoring_InvalidDeclaration);
        }
        this.declStmt = (ASTTypeDeclarationStmtNode)decl;
        IASTListNode<ASTEntityDeclNode> entityDeclList = this.declStmt.getEntityDeclList();
        if (entityDeclList == null) {
            this.fail(Messages.AddSubroutineParameterRefactoring_InvalidDeclaration);
        }
    }

    private void checkForConflictingBindings(IProgressMonitor pm, RefactoringStatus status) {
        Definition def = this.arbitraryDefinitionInScope();
        if (def == null) {
            return;
        }
        AddSubroutineParameterRefactoring.checkForConflictingBindings(pm, (FortranResourceRefactoring.IConflictingBindingCallback)new ConflictingBindingErrorHandler(status), def, Collections.<PhotranTokenRef>emptyList(), this.parameterName);
    }

    private Definition arbitraryDefinitionInScope() {
        ScopingNode enclosingScope = this.selectedSubroutine.findNearestAncestor(ScopingNode.class);
        List<Definition> allDefs = enclosingScope.getAllDefinitions();
        if (allDefs.isEmpty()) {
            return null;
        }
        return allDefs.get(0);
    }

    private boolean isWhiteSpace(String str) {
        return str.replace(" ", "").replace("\t", "").equals("");
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.buildNewParameterListWithNewParameter();
        this.permuteArgumentList(this.selectedSubroutine);
        this.addArgumentDeclaration(this.selectedSubroutine);
        this.permuteCallSites();
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void addArgumentDeclaration(ASTSubroutineStmtNode subroutineStatement) {
        ASTSubroutineSubprogramNode subroutine = (ASTSubroutineSubprogramNode)subroutineStatement.getParent();
        IASTListNode<IBodyConstruct> statements = subroutine.getBody();
        if (statements == null) {
            statements = new ASTListNode<IBodyConstruct>();
            subroutine.setBody(statements);
        }
        statements.add(0, this.declStmt);
        Reindenter.reindent(this.declStmt, this.astOfFileInEditor);
    }

    public String getName() {
        return Messages.AddSubroutineParameterRefactoring_Name;
    }

    public List<ASTSubroutineParNode> getSubroutineParameters() {
        if (this.selectedSubroutine.getSubroutinePars() != null) {
            return this.selectedSubroutine.getSubroutinePars();
        }
        return new ArrayList<ASTSubroutineParNode>();
    }

    private Collection<Definition> getInterfaceDeclarations() {
        List<Definition> subroutineDefinitions = this.selectedSubroutine.getSubroutineName().getSubroutineName().resolveBinding();
        if (subroutineDefinitions.size() != 1) {
            return new ArrayList<Definition>();
        }
        return subroutineDefinitions.get(0).findMatchingDeclarationsInInterfaces();
    }

    public void buildNewParameterListWithNewParameter() {
        ASTSubroutineParNode newParameter = new ASTSubroutineParNode();
        Token variableName = this.generateVariableName();
        newParameter.setVariableName(variableName);
        this.newParameterList = new ArrayList<ASTSubroutineParNode>(this.oldParameterList);
        this.newParameterList.add(this.position, newParameter);
    }

    private Token generateVariableName() {
        Token variableName = new Token(Terminal.T_IDENT, this.parameterName);
        return variableName;
    }

    protected void permuteArgumentList(ASTSubroutineStmtNode node) {
        ASTSeparatedListNode<ASTSubroutineParNode> newParameterList = new ASTSeparatedListNode<ASTSubroutineParNode>(new Token(Terminal.T_COMMA, ","), this.newParameterList);
        node.setSubroutinePars(newParameterList);
    }

    private void permuteCallSites() {
        for (ASTCallStmtNode callStmt : this.getCallSites()) {
            int positionToCompareTo;
            ASTSubroutineParNode firstParameter;
            ASTSubroutineArgNode firstParameterArgument;
            int previousArgumentListSize = 0;
            if (callStmt.getArgList() != null) {
                previousArgumentListSize = callStmt.getArgList().size();
            }
            ASTIntConstNode expr = new ASTIntConstNode();
            expr.setIntConst(new Token(Terminal.T_ICON, this.defaultValue));
            ASTSubroutineArgNode addedParArg = new ASTSubroutineArgNode();
            addedParArg.setExpr(expr);
            if (previousArgumentListSize > 0 && (firstParameterArgument = this.getActualArgFromCallStmt(callStmt, (firstParameter = this.oldParameterList.get(positionToCompareTo = Math.min(this.position, previousArgumentListSize - 1))).getVariableName(), positionToCompareTo)).getName() != null) {
                addedParArg.setName(new Token(Terminal.T_IDENT, this.parameterName));
            }
            ArrayList<ASTSubroutineArgNode> newParameterListForCallSite = new ArrayList<ASTSubroutineArgNode>();
            int i = 0;
            while (i < previousArgumentListSize) {
                ASTSubroutineParNode desiredPar = this.oldParameterList.get(i);
                ASTSubroutineArgNode desiredParArgument = this.getActualArgFromCallStmt(callStmt, desiredPar.getVariableName(), i);
                newParameterListForCallSite.add(desiredParArgument);
                ++i;
            }
            newParameterListForCallSite.add(this.position, addedParArg);
            ASTSeparatedListNode<ASTSubroutineArgNode> newArgList = new ASTSeparatedListNode<ASTSubroutineArgNode>(new Token(Terminal.T_COMMA, ","), newParameterListForCallSite);
            callStmt.setArgList(newArgList);
        }
    }

    private Set<ASTCallStmtNode> getCallSites() {
        List<Definition> subroutineDefinitions = this.selectedSubroutine.getSubroutineName().getSubroutineName().resolveBinding();
        HashSet<ASTCallStmtNode> result = new HashSet<ASTCallStmtNode>();
        if (subroutineDefinitions.size() != 1) {
            return result;
        }
        for (PhotranTokenRef tokenRef : subroutineDefinitions.get(0).findAllReferences(true)) {
            Token token = tokenRef.findToken();
            ASTCallStmtNode callStmtNode = token.findNearestAncestor(ASTCallStmtNode.class);
            if (callStmtNode == null) continue;
            result.add(callStmtNode);
        }
        return result;
    }

    private ASTSubroutineArgNode getActualArgFromCallStmt(ASTCallStmtNode callStmt, Token desiredParName, int desiredParIndex) {
        int i = 0;
        while (i < callStmt.getArgList().size()) {
            String parameterName;
            String argumentName;
            ASTSubroutineArgNode argument = (ASTSubroutineArgNode)callStmt.getArgList().get(i);
            if (argument.getName() == null || desiredParName == null ? i == desiredParIndex : (argumentName = PhotranVPG.canonicalizeIdentifier(argument.getName().getText())).equals(parameterName = PhotranVPG.canonicalizeIdentifier(desiredParName.getText()))) {
                return argument;
            }
            ++i;
        }
        return null;
    }

    private final class ConflictingBindingErrorHandler
    implements FortranResourceRefactoring.IConflictingBindingCallback {
        private final RefactoringStatus status;

        private ConflictingBindingErrorHandler(RefactoringStatus status) {
            this.status = status;
        }

        @Override
        public void addConflictError(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            FortranResourceRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = Messages.bind((String)Messages.AddSubroutineParameterRefactoring_NameConflictsWith, (Object)conflict.name, (Object)((PhotranVPG)AddSubroutineParameterRefactoring.this.vpg).getDefinitionFor(conflict.tokenRef));
            RefactoringStatusContext context = AddSubroutineParameterRefactoring.this.createContext((IVPGNode)conflict.tokenRef);
            this.status.addError(msg, context);
        }

        @Override
        public void addConflictWarning(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            FortranResourceRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = Messages.bind((String)Messages.AddSubroutineParameterRefactoring_NameMightConflictWithSubprogram, (Object)conflict.name);
            RefactoringStatusContext context = AddSubroutineParameterRefactoring.this.createContext((IVPGNode)conflict.tokenRef);
            this.status.addWarning(msg, context);
        }

        @Override
        public void addReferenceWillChangeError(String newName, Token reference) {
            throw new IllegalStateException();
        }
    }
}

