/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.refactoring.interfaces.IRenameRefactoring;
import org.eclipse.photran.internal.core.sourceform.SourceForm;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class RenameRefactoring
extends FortranEditorRefactoring
implements IRenameRefactoring {
    private Definition definitionToRename = null;
    private Collection<PhotranTokenRef> allReferences = null;
    private String oldName = null;
    private String newName = null;
    private boolean shouldBindInterfacesAndExternals = true;

    @Override
    public String getName() {
        return Messages.RenameRefactoring_Name;
    }

    public String getOldNameOfIdentifier() {
        assert (this.oldName != null);
        return this.oldName;
    }

    @Override
    public void setNewNameForIdentifier(String newName) {
        assert (newName != null);
        this.newName = newName;
    }

    public void setShouldBindInterfacesAndExternals(boolean value) {
        this.shouldBindInterfacesAndExternals = value;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.oldName = this.findEnclosingToken().getText();
        this.definitionToRename = this.findDeclarationToRename();
        this.checkIfDefinitionCanBeRenamed();
    }

    private Token findEnclosingToken() throws VPGRefactoring.PreconditionFailure {
        Token selectedToken = RenameRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedToken == null || !RenameRefactoring.isIdentifier(selectedToken)) {
            this.fail(Messages.RenameRefactoring_PleaseSelectAnIdentifier);
        }
        return selectedToken;
    }

    private Definition findDeclarationToRename() throws VPGRefactoring.PreconditionFailure {
        List<Definition> declarations = this.findEnclosingToken().resolveBinding();
        if (declarations.size() == 0) {
            this.fail(Messages.bind((String)Messages.RenameRefactoring_NoDeclarationFoundFor, (Object)this.oldName));
        } else if (declarations.size() > 1) {
            this.fail(Messages.bind((String)Messages.RenameRefactoring_MultipleDeclarationsFoundFor, (Object)this.oldName));
        }
        return declarations.get(0);
    }

    private void checkIfDefinitionCanBeRenamed() throws VPGRefactoring.PreconditionFailure {
        if (this.definitionToRename.isSubprogramArgument()) {
            this.fail(Messages.RenameRefactoring_CannotRenameSubprogramArgs);
        }
        if (this.definitionToRename.isTypeBoundProcedure() && !this.definitionToRename.isRenamedTypeBoundProcedure()) {
            this.fail(Messages.RenameRefactoring_CannotRenameTypeBoundProcedures);
        }
        if (!(this.definitionToRename.isLocalVariable() || this.definitionToRename.isSubprogram() || this.definitionToRename.isExternal() || this.definitionToRename.isInterface() || this.definitionToRename.isDerivedType() || this.definitionToRename.isModuleEntityBeforeRename() || this.definitionToRename.isRenamedModuleEntity() || this.definitionToRename.isMainProgram() || this.definitionToRename.isNamelist() || this.definitionToRename.isCommon() || this.definitionToRename.isBlockData())) {
            this.fail(Messages.bind((String)Messages.RenameRefactoring_CannotRename, (Object)this.definitionToRename.describeClassification(), (Object)this.oldName));
        }
        if (this.definitionToRename.isIntrinsic()) {
            this.fail(Messages.bind((String)Messages.RenameRefactoring_CannotRenameIntrinsicProcedure, (Object)this.oldName));
        }
        if (RenameRefactoring.isPreprocessed(this.definitionToRename.getTokenRef().findToken())) {
            this.fail(Messages.bind((String)Messages.RenameRefactoring_CannotRenameInINCLUDEFile, (Object)this.oldName));
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        assert (this.definitionToRename != null);
        assert (this.newName != null);
        assert (this.allReferences == null);
        if (this.newName.equals(this.oldName)) {
            this.fail(Messages.bind((String)Messages.RenameRefactoring_NewNameIsExactlyTheSame, (Object)this.newName));
        }
        if (!RenameRefactoring.isValidIdentifier(this.newName)) {
            this.fail(Messages.bind((String)Messages.RenameRefactoring_InvalidIdentifier, (Object)this.newName));
        }
        this.allReferences = this.definitionToRename.findAllReferences(this.shouldBindInterfacesAndExternals);
        this.removeFixedFormReferences(status);
        this.removeCPreprocessedReferences(status);
        this.checkIfReferencesCanBeRenamed(pm);
        RenameRefactoring.checkForConflictingBindings(pm, (FortranResourceRefactoring.IConflictingBindingCallback)new ConflictingBindingErrorHandler(status), this.definitionToRename, this.allReferences, this.newName);
    }

    private void removeFixedFormReferences(RefactoringStatus status) {
        if (FIXED_FORM_REFACTORING_ENABLED) {
            return;
        }
        HashSet<IFile> fixedFormFiles = new HashSet<IFile>();
        HashSet<IFile> freeFormFiles = new HashSet<IFile>();
        HashSet<PhotranTokenRef> referencesToRemove = new HashSet<PhotranTokenRef>();
        for (PhotranTokenRef reference : this.allReferences) {
            IFile file = reference.getFile();
            if (fixedFormFiles.contains(file)) {
                referencesToRemove.add(reference);
                continue;
            }
            if (freeFormFiles.contains(file)) continue;
            if (SourceForm.isFixedForm((IFile)file)) {
                fixedFormFiles.add(file);
                status.addError(Messages.bind((String)Messages.RenameRefactoring_FixedFormFileWillNotBeRefactored, (Object)file.getName()));
                referencesToRemove.add(reference);
                continue;
            }
            freeFormFiles.add(file);
        }
        this.allReferences.removeAll(referencesToRemove);
    }

    private void removeCPreprocessedReferences(RefactoringStatus status) {
        HashSet<IFile> cppFiles = new HashSet<IFile>();
        HashSet<IFile> freeFormFiles = new HashSet<IFile>();
        HashSet<PhotranTokenRef> referencesToRemove = new HashSet<PhotranTokenRef>();
        for (PhotranTokenRef reference : this.allReferences) {
            IFile file = reference.getFile();
            if (cppFiles.contains(file)) {
                referencesToRemove.add(reference);
                continue;
            }
            if (freeFormFiles.contains(file)) continue;
            if (SourceForm.isCPreprocessed((IFile)file)) {
                cppFiles.add(file);
                status.addError(Messages.bind((String)Messages.RenameRefactoring_CPreprocessedFileWillNotBeRefactored, (Object)file.getName()));
                referencesToRemove.add(reference);
                continue;
            }
            freeFormFiles.add(file);
        }
        this.allReferences.removeAll(referencesToRemove);
    }

    private void checkIfReferencesCanBeRenamed(IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        for (PhotranTokenRef ref : this.allReferences) {
            pm.subTask(Messages.bind((String)Messages.RenameRefactoring_StatusCheckingIfReferencesInFileCanBeRenamed, (Object)ref.getFilename()));
            Token reference = ref.findToken();
            if (reference.resolveBinding().size() > 1) {
                this.fail(Messages.bind((String)Messages.RenameRefactoring_CannotRenameAmbiguous, (Object[])new Object[]{this.oldName, RenameRefactoring.describeToken(reference), this.oldName}));
            }
            if (!RenameRefactoring.isPreprocessed(reference)) continue;
            this.fail(Messages.bind((String)Messages.RenameRefactoring_CannotRenameUsedInINCLUDEFile, (Object)this.oldName, (Object)RenameRefactoring.describeToken(reference)));
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        assert (this.definitionToRename != null);
        assert (this.allReferences != null);
        assert (this.newName != null);
        Set<IFile> filesToChange = this.determineFilesToChange();
        pm.beginTask(Messages.RenameRefactoring_StatusRenaming, filesToChange.size());
        try {
            for (IFile file : filesToChange) {
                this.makeChangesTo(file, pm);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
            pm.done();
        }
    }

    private Set<IFile> determineFilesToChange() {
        HashSet<IFile> files = new HashSet<IFile>(this.allReferences.size() + 2);
        files.add(this.fileInEditor);
        files.add(this.definitionToRename.getTokenRef().getFile());
        for (PhotranTokenRef ref : this.allReferences) {
            files.add(ref.getFile());
        }
        return files;
    }

    private void makeChangesTo(IFile file, IProgressMonitor pm) throws Error {
        try {
            pm.subTask(Messages.bind((String)Messages.RenameRefactoring_StatusModifyingFile, (Object)file.getName()));
            pm.worked(1);
            ((PhotranVPG)this.vpg).acquirePermanentAST(file);
            if (this.definitionToRename.getTokenRef().getFile().equals((Object)file)) {
                this.definitionToRename.getTokenRef().findToken().setText(this.newName);
            }
            for (PhotranTokenRef ref : this.allReferences) {
                if (!ref.getFile().equals((Object)file)) continue;
                ref.findToken().setText(this.newName);
            }
            this.addChangeFromModifiedAST(file, pm);
            ((PhotranVPG)this.vpg).releaseAST(file);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private final class ConflictingBindingErrorHandler
    implements FortranResourceRefactoring.IConflictingBindingCallback {
        private final RefactoringStatus status;

        private ConflictingBindingErrorHandler(RefactoringStatus status) {
            this.status = status;
        }

        @Override
        public void addConflictError(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            FortranResourceRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = Messages.bind((String)Messages.RenameRefactoring_NameConflicts, (Object)conflict.name, (Object)((PhotranVPG)RenameRefactoring.this.vpg).getDefinitionFor(conflict.tokenRef));
            RefactoringStatusContext context = RenameRefactoring.this.createContext((IVPGNode)conflict.tokenRef);
            this.status.addError(msg, context);
        }

        @Override
        public void addConflictWarning(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            FortranResourceRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = Messages.bind((String)Messages.RenameRefactoring_NameMightConflict, (Object)conflict.name);
            RefactoringStatusContext context = RenameRefactoring.this.createContext((IVPGNode)conflict.tokenRef);
            this.status.addWarning(msg, context);
        }

        @Override
        public void addReferenceWillChangeError(String newName, Token reference) {
            this.status.addError(Messages.bind((String)Messages.RenameRefactoring_ChangingNameWouldChangeMeaning, (Object[])new Object[]{newName, reference.getText(), reference.getLine(), reference.getTokenRef().getFilename()}), RenameRefactoring.this.createContext(reference));
        }
    }
}

