/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.launch.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.launch.ui.LaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.LaunchImages;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.ptp.rm.jaxb.control.IJobController;
import org.eclipse.ptp.rm.jaxb.control.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.core.JAXBExtensionUtils;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorType;
import org.eclipse.ptp.rm.launch.RMLaunchPlugin;
import org.eclipse.ptp.rm.launch.internal.messages.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ResourcesTab
extends LaunchConfigurationTab {
    public static final String TAB_ID = "org.eclipse.ptp.rm.launch.applicationLaunch.resourcesTab";
    private Combo fSystemTypeCombo;
    private final List<String> fProviders = new ArrayList<String>();
    private boolean fDefaultConnection;
    private ILaunchController fLaunchControl;
    private RemoteConnectionWidget fRemoteConnectionWidget;
    private IRemoteConnection fRemoteConnection;
    private ScrolledComposite launchAttrsScrollComposite;
    private final Map<IJobControl, IRMLaunchConfigurationDynamicTab> fDynamicTabs = new HashMap<IJobControl, IRMLaunchConfigurationDynamicTab>();
    private final ContentsChangedListener launchContentsChangedListener = new ContentsChangedListener();

    public boolean canSave() {
        this.setErrorMessage(null);
        if (this.fSystemTypeCombo.getSelectionIndex() == 0) {
            this.setErrorMessage(Messages.ResourcesTab_No_Target_Configuration);
            return false;
        }
        if (this.fLaunchControl == null) {
            this.setErrorMessage(Messages.ResourcesTab_No_Connection_name);
            return false;
        }
        IRMLaunchConfigurationDynamicTab dynamicTab = this.getLaunchConfigurationDynamicTab((IJobController)this.fLaunchControl);
        ScrolledComposite launchComp = this.getLaunchAttrsScrollComposite();
        if (dynamicTab == null || launchComp == null) {
            this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.fLaunchControl.getConfiguration().getName()}));
            return false;
        }
        RMLaunchValidation validation = dynamicTab.canSave((Control)launchComp);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        new Label(comp, 0).setText(Messages.ResourcesTab_targetSystemConfiguration);
        this.fSystemTypeCombo = new Combo(comp, 8);
        gd = new GridData(768);
        this.fSystemTypeCombo.setLayoutData((Object)gd);
        this.fSystemTypeCombo.add(Messages.ResourcesTab_pleaseSelectTargetSystem);
        String[] configNames = JAXBExtensionUtils.getConfiguationNames();
        if (JAXBExtensionUtils.getInvalid() != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ResourcesTab_InvalidConfig_title, (String)(String.valueOf(Messages.ResourcesTab_InvalidConfig_message) + JAXBExtensionUtils.getInvalid()));
        }
        String[] stringArray = configNames;
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.fSystemTypeCombo.add(name);
            this.fProviders.add(name);
            ++n2;
        }
        this.fSystemTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResourcesTab.this.rmTypeSelectionChanged();
                ResourcesTab.this.updateEnablement();
                ResourcesTab.this.handleConnectionChanged();
            }
        });
        this.fSystemTypeCombo.select(0);
        this.fRemoteConnectionWidget = new RemoteConnectionWidget(comp, 0, null, (IRunnableContext)this.getLaunchConfigurationDialog());
        this.fRemoteConnectionWidget.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fRemoteConnectionWidget.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResourcesTab.this.handleConnectionChanged();
            }
        });
        this.fRemoteConnectionWidget.setEnabled(false);
        this.createVerticalSpacer(comp, 2);
        ScrolledComposite scrollComp = this.createLaunchAttributeControlComposite(comp, 2);
        this.setLaunchAttrsScrollComposite(scrollComp);
    }

    public String getId() {
        return TAB_ID;
    }

    public Image getImage() {
        return LaunchImages.getImage((String)LaunchImages.IMG_PARALLEL_TAB);
    }

    public String getName() {
        return Messages.ResourcesTab_Resources;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        String rmType = LaunchUtils.getTemplateName((ILaunchConfiguration)configuration);
        String remId = LaunchUtils.getRemoteServicesId((ILaunchConfiguration)configuration);
        String remName = LaunchUtils.getConnectionName((ILaunchConfiguration)configuration);
        if (rmType != null && remId != null && remName != null) {
            this.fSystemTypeCombo.select(this.fProviders.lastIndexOf(rmType) + 1);
            this.updateEnablement();
            if (!(this.fLaunchControl == null || this.fLaunchControl.getConfiguration().getName().equals(rmType) && this.fLaunchControl.getRemoteServicesId().equals(remId) && this.fLaunchControl.getConnectionName().equals(remName))) {
                this.stopController(this.fLaunchControl);
                this.fLaunchControl = null;
            }
            this.fRemoteConnectionWidget.setConnection(remId, remName);
            if (this.openConnection()) {
                this.fRemoteConnection = this.fRemoteConnectionWidget.getConnection();
                if (this.fLaunchControl == null) {
                    this.fLaunchControl = this.getNewController(remId, remName, rmType);
                }
            } else {
                this.fRemoteConnectionWidget.setConnection(null);
            }
            this.updateLaunchAttributeControls(this.fLaunchControl, this.getLaunchConfiguration(), true);
            this.updateLaunchConfigurationDialog();
            this.fDefaultConnection = false;
        } else {
            this.stopController(this.fLaunchControl);
            this.fLaunchControl = null;
            this.fRemoteConnection = null;
            this.updateEnablement();
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fSystemTypeCombo.getSelectionIndex() == 0) {
            this.setErrorMessage(Messages.ResourcesTab_No_Target_Configuration);
            return false;
        }
        if (this.fLaunchControl == null) {
            this.setErrorMessage(Messages.ResourcesTab_No_Connection_name);
            return false;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getLaunchConfigurationDynamicTab((IJobController)this.fLaunchControl);
        if (rmDynamicTab == null) {
            this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.fLaunchControl.getConfiguration().getName()}));
            return false;
        }
        RMLaunchValidation validation = rmDynamicTab.isValid(configuration);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int index = this.fSystemTypeCombo.getSelectionIndex();
        if (this.fLaunchControl != null && index > 0) {
            IRMLaunchConfigurationDynamicTab dynamicTab;
            MonitorType monitorData;
            LaunchUtils.setConfigurationName((ILaunchConfigurationWorkingCopy)configuration, (String)this.fSystemTypeCombo.getItem(index));
            LaunchUtils.setResourceManagerUniqueName((ILaunchConfigurationWorkingCopy)configuration, (String)this.fLaunchControl.getControlId());
            LaunchUtils.setConnectionName((ILaunchConfigurationWorkingCopy)configuration, (String)this.fLaunchControl.getConnectionName());
            LaunchUtils.setRemoteServicesId((ILaunchConfigurationWorkingCopy)configuration, (String)this.fLaunchControl.getRemoteServicesId());
            if (this.fLaunchControl.getConfiguration() != null && (monitorData = this.fLaunchControl.getConfiguration().getMonitorData()) != null) {
                LaunchUtils.setSystemType((ILaunchConfigurationWorkingCopy)configuration, (String)monitorData.getSchedulerType());
            }
            if ((dynamicTab = this.getLaunchConfigurationDynamicTab((IJobController)this.fLaunchControl)) == null) {
                this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.fLaunchControl.getConfiguration().getName()}));
                return;
            }
            RMLaunchValidation validation = dynamicTab.performApply(configuration);
            if (!validation.isSuccess()) {
                this.setErrorMessage(validation.getMessage());
                return;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.fDefaultConnection = true;
    }

    private ScrolledComposite createLaunchAttributeControlComposite(Composite parent, int colspan) {
        ScrolledComposite attrComp = new ScrolledComposite(parent, 768);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = colspan;
        attrComp.setLayoutData((Object)gridData);
        attrComp.setExpandHorizontal(true);
        attrComp.setExpandVertical(true);
        return attrComp;
    }

    private ScrolledComposite getLaunchAttrsScrollComposite() {
        return this.launchAttrsScrollComposite;
    }

    private IRMLaunchConfigurationDynamicTab getLaunchConfigurationDynamicTab(final IJobController controller) {
        if (!this.fDynamicTabs.containsKey(controller)) {
            final IRMLaunchConfigurationDynamicTab[] dynamicTab = new IRMLaunchConfigurationDynamicTab[1];
            try {
                this.getLaunchConfigurationDialog().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                        dynamicTab[0] = ResourcesTab.this.getLaunchConfigurationDynamicTab(controller, (IProgressMonitor)progress.newChild(1));
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            return dynamicTab[0];
        }
        return this.fDynamicTabs.get(controller);
    }

    private IRMLaunchConfigurationDynamicTab getLaunchConfigurationDynamicTab(IJobController controller, IProgressMonitor monitor) {
        if (!this.fDynamicTabs.containsKey(controller)) {
            try {
                JAXBControllerLaunchConfigurationTab dynamicTab = new JAXBControllerLaunchConfigurationTab(controller, monitor);
                dynamicTab.addContentsChangedListener((IRMLaunchConfigurationContentsChangedListener)this.launchContentsChangedListener);
                this.fDynamicTabs.put((IJobControl)controller, (IRMLaunchConfigurationDynamicTab)dynamicTab);
                return dynamicTab;
            }
            catch (Throwable e) {
                this.setErrorMessage(e.getMessage());
                RMLaunchPlugin.errorDialog(e.getMessage(), e);
                return null;
            }
        }
        return this.fDynamicTabs.get(controller);
    }

    private ILaunchController getNewController(String remId, String connName, String type) {
        try {
            return LaunchControllerManager.getInstance().getLaunchController(remId, connName, type);
        }
        catch (CoreException e) {
            RMLaunchPlugin.errorDialog(e.getMessage(), e);
            return null;
        }
    }

    private void handleConnectionChanged() {
        this.fRemoteConnectionWidget.setFocus();
        IRemoteConnection conn = null;
        if (this.fRemoteConnectionWidget.isEnabled()) {
            conn = this.fRemoteConnectionWidget.getConnection();
        }
        if (conn == null) {
            this.stopController(this.fLaunchControl);
            this.fLaunchControl = null;
            this.fRemoteConnection = null;
            this.updateLaunchAttributeControls(null, this.getLaunchConfiguration(), false);
            this.updateLaunchConfigurationDialog();
        } else if (this.openConnection()) {
            String type = this.fSystemTypeCombo.getItem(this.fSystemTypeCombo.getSelectionIndex());
            ILaunchController controller = this.getNewController(conn.getRemoteServices().getId(), conn.getName(), type);
            if (controller != null) {
                this.stopController(this.fLaunchControl);
                this.fLaunchControl = controller;
                this.fRemoteConnection = conn;
                this.updateLaunchAttributeControls(this.fLaunchControl, this.getLaunchConfiguration(), true);
                this.updateLaunchConfigurationDialog();
            }
        } else {
            this.fRemoteConnectionWidget.setConnection(this.fRemoteConnection);
        }
    }

    private boolean openConnection() {
        IRemoteConnection conn = this.fRemoteConnectionWidget.getConnection();
        if (conn != null) {
            boolean result;
            return conn.isOpen() || (result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ResourcesTab_openConnection, (String)NLS.bind((String)Messages.ResourcesTab_noInformation, (Object)conn.getName())));
        }
        return false;
    }

    private void rmTypeSelectionChanged() {
        this.stopController(this.fLaunchControl);
        this.fLaunchControl = null;
    }

    private void setLaunchAttrsScrollComposite(ScrolledComposite comp) {
        this.launchAttrsScrollComposite = comp;
    }

    private void stopController(ILaunchController controller) {
        if (controller != null) {
            try {
                controller.stop();
            }
            catch (CoreException coreException) {}
        }
    }

    private void updateEnablement() {
        if (this.fSystemTypeCombo.getSelectionIndex() > 0) {
            this.fRemoteConnectionWidget.setEnabled(true);
            this.fRemoteConnectionWidget.setConnection(null);
        } else {
            this.fRemoteConnectionWidget.setEnabled(false);
        }
    }

    private void updateLaunchAttributeControls(final ILaunchController controller, ILaunchConfiguration launchConfiguration, final boolean startController) {
        ScrolledComposite launchAttrsScrollComp = this.getLaunchAttrsScrollComposite();
        launchAttrsScrollComp.setContent(null);
        Control[] controlArray = launchAttrsScrollComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (controller != null) {
            final IRMLaunchConfigurationDynamicTab[] dynamicTab = new IRMLaunchConfigurationDynamicTab[1];
            try {
                this.getLaunchConfigurationDialog().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
                        if (startController) {
                            try {
                                controller.start((IProgressMonitor)progress.newChild(10));
                                dynamicTab[0] = ResourcesTab.this.getLaunchConfigurationDynamicTab((IJobController)controller, (IProgressMonitor)progress.newChild(10));
                            }
                            catch (CoreException e) {
                                RMLaunchPlugin.errorDialog(e.getMessage(), e);
                            }
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            if (dynamicTab[0] != null) {
                try {
                    dynamicTab[0].createControl((Composite)launchAttrsScrollComp, controller.getControlId());
                    Control dynControl = dynamicTab[0].getControl();
                    launchAttrsScrollComp.setContent(dynControl);
                    Point size = dynControl.computeSize(-1, -1);
                    launchAttrsScrollComp.setMinSize(size);
                    dynamicTab[0].initializeFrom(launchConfiguration);
                }
                catch (CoreException e) {
                    this.setErrorMessage(e.getMessage());
                    Throwable t = e.getCause();
                    if (t == null) {
                        t = e;
                    }
                    RMLaunchPlugin.errorDialog(e.getMessage(), t);
                }
            }
        }
        launchAttrsScrollComp.layout(true);
    }

    private final class ContentsChangedListener
    implements IRMLaunchConfigurationContentsChangedListener {
        private ContentsChangedListener() {
        }

        public void handleContentsChanged(IRMLaunchConfigurationDynamicTab rmDynamicTab) {
            ResourcesTab.this.updateLaunchConfigurationDialog();
        }
    }
}

