/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.core.runtime.CoreException;

public abstract class CPPEvaluation
implements ICPPEvaluation {
    CPPEvaluation() {
    }

    @Override
    public char[] getSignature() {
        SignatureBuilder buf = new SignatureBuilder();
        try {
            this.marshal(buf, true);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new char[]{'?'};
        }
        return buf.getSignature();
    }

    protected static IBinding resolveUnknown(ICPPUnknownBinding unknown, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        try {
            return CPPTemplates.resolveUnknown(unknown, tpMap, packOffset, within, point);
        }
        catch (DOMException e) {
            CCorePlugin.log((Throwable)e);
            return unknown;
        }
    }

    protected static ICPPTemplateArgument[] instantiateArguments(ICPPTemplateArgument[] args, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        try {
            return CPPTemplates.instantiateArguments(args, tpMap, packOffset, within, point);
        }
        catch (DOMException e) {
            CCorePlugin.log((Throwable)e);
            return args;
        }
    }

    private static class SignatureBuilder
    implements ITypeMarshalBuffer {
        private static final byte NULL_TYPE = 0;
        private static final byte UNSTORABLE_TYPE = -1;
        private final StringBuilder fBuffer = new StringBuilder();

        public String toString() {
            return this.fBuffer.toString();
        }

        public char[] getSignature() {
            return CharArrayUtils.extractChars(this.fBuffer);
        }

        @Override
        public void marshalBinding(IBinding binding) throws CoreException {
            if (binding instanceof ISerializableType) {
                ((ISerializableType)((Object)binding)).marshal(this);
            } else if (binding == null) {
                this.putByte((byte)0);
            } else {
                this.appendSeparator();
                if (binding instanceof ICPPBinding) {
                    if (binding instanceof ICPPTemplateParameter) {
                        ICPPTemplateParameter param = (ICPPTemplateParameter)binding;
                        this.fBuffer.append(param.isParameterPack() ? (char)'*' : '#');
                        this.fBuffer.append(param.getParameterID());
                    } else {
                        this.fBuffer.append(ASTTypeUtil.getQualifiedName((ICPPBinding)binding));
                    }
                } else {
                    this.fBuffer.append(binding.getNameCharArray());
                }
            }
        }

        @Override
        public void marshalType(IType type) throws CoreException {
            if (type instanceof ISerializableType) {
                ((ISerializableType)((Object)type)).marshal(this);
            } else if (type == null) {
                this.putByte((byte)0);
            } else if (type instanceof IBinding) {
                this.marshalBinding((IBinding)((Object)type));
            } else {
                assert (false) : "Cannot serialize " + ASTTypeUtil.getType(type) + " (" + type.getClass().getName() + ")";
                this.putByte((byte)-1);
            }
        }

        @Override
        public void marshalEvaluation(ISerializableEvaluation eval, boolean includeValues) throws CoreException {
            if (eval == null) {
                this.putByte((byte)0);
            } else {
                eval.marshal(this, includeValues);
            }
        }

        @Override
        public void marshalValue(IValue value) throws CoreException {
            if (value instanceof Value) {
                ((Value)value).marshall(this);
            } else {
                this.putByte((byte)0);
            }
        }

        @Override
        public void marshalTemplateArgument(ICPPTemplateArgument arg) throws CoreException {
            if (arg.isNonTypeValue()) {
                this.putByte((byte)10);
                arg.getNonTypeEvaluation().marshal(this, true);
            } else {
                this.marshalType(arg.getTypeValue());
            }
        }

        @Override
        public void putByte(byte value) {
            this.appendSeparator();
            this.fBuffer.append(value);
        }

        @Override
        public void putShort(short value) {
            this.appendSeparator();
            this.fBuffer.append(value);
        }

        @Override
        public void putInt(int value) {
            this.appendSeparator();
            this.fBuffer.append(value);
        }

        @Override
        public void putLong(long value) {
            this.appendSeparator();
            this.fBuffer.append(value);
        }

        @Override
        public void putCharArray(char[] chars) {
            this.appendSeparator();
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                this.fBuffer.append(c);
                ++n2;
            }
        }

        private void appendSeparator() {
            if (this.fBuffer.length() != 0) {
                this.fBuffer.append(' ');
            }
        }

        @Override
        public IBinding unmarshalBinding() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public IType unmarshalType() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ISerializableEvaluation unmarshalEvaluation() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public IValue unmarshalValue() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICPPTemplateArgument unmarshalTemplateArgument() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getByte() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public CoreException unmarshallingError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getShort() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLong() throws CoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public char[] getCharArray() throws CoreException {
            throw new UnsupportedOperationException();
        }
    }
}

