/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.UniqueType;

public class SemanticUtil {
    private static final char[] OPERATOR_CHARS = "operator".toCharArray();
    private static final CharArraySet cas = new CharArraySet(OverloadableOperator.values().length);
    public static final int TDEF = 1;
    public static final int COND_TDEF = 2;
    public static final int REF = 4;
    public static final int CVTYPE = 8;
    public static final int ALLCVQ = 16;
    public static final int PTR = 32;
    public static final int MPTR = 64;
    public static final int ARRAY = 128;

    static {
        int OPERATOR_SPC = OPERATOR_CHARS.length + 1;
        OverloadableOperator[] overloadableOperatorArray = OverloadableOperator.values();
        int n = overloadableOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            OverloadableOperator op = overloadableOperatorArray[n2];
            char[] name = op.toCharArray();
            cas.put(CharArrayUtils.subarray(name, OPERATOR_SPC, name.length));
            ++n2;
        }
    }

    public static final ICPPMethod[] getDeclaredConversionOperators(ICPPClassType clazz, IASTNode point) throws DOMException {
        ICPPMethod[] decs;
        ICPPMethod[] methods = ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        if (clazz instanceof ICPPDeferredClassInstance) {
            clazz = (ICPPClassType)((Object)((ICPPDeferredClassInstance)clazz).getTemplateDefinition());
        }
        if ((decs = ClassTypeHelper.getDeclaredMethods(clazz, point)) != null) {
            ICPPMethod[] iCPPMethodArray = decs;
            int n = decs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod method = iCPPMethodArray[n2];
                if (SemanticUtil.isConversionOperator(method)) {
                    methods = ArrayUtil.append(methods, method);
                }
                ++n2;
            }
        }
        return methods;
    }

    public static ICPPMethod[] getConversionOperators(ICPPClassType clazz, IASTNode point) throws DOMException {
        ICPPMethod[] methods = ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        ObjectSet<ICPPClassType> ancestry = SemanticUtil.inheritanceClosure(clazz, point);
        int i = 0;
        while (i < ancestry.size()) {
            methods = ArrayUtil.addAll(methods, SemanticUtil.getDeclaredConversionOperators((ICPPClassType)ancestry.keyAt(i), point));
            ++i;
        }
        return methods;
    }

    public static ObjectSet<ICPPClassType> inheritanceClosure(ICPPClassType root, IASTNode point) throws DOMException {
        ObjectSet<ICPPClassType> done = new ObjectSet<ICPPClassType>(2);
        ObjectSet<ICPPClassType> current = new ObjectSet<ICPPClassType>(2);
        current.put(root);
        int count = 0;
        while (count < 16 && !current.isEmpty()) {
            ObjectSet<ICPPClassType> next = new ObjectSet<ICPPClassType>(2);
            int i = 0;
            while (i < current.size()) {
                ICPPClassType clazz = (ICPPClassType)current.keyAt(i);
                done.put(clazz);
                ICPPBase[] iCPPBaseArray = ClassTypeHelper.getBases(clazz, point);
                int n = iCPPBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPClassType ct;
                    ICPPBase base = iCPPBaseArray[n2];
                    IBinding binding = base.getBaseClass();
                    if (binding instanceof ICPPClassType && !(binding instanceof IProblemBinding) && !done.containsKey(ct = (ICPPClassType)binding)) {
                        next.put(ct);
                    }
                    ++n2;
                }
                ++i;
            }
            current = next;
            ++count;
        }
        return done;
    }

    public static final boolean isConversionOperator(ICPPFunction method) {
        char[] name;
        if (method instanceof ICPPMethod && (name = method.getNameCharArray()).length > OPERATOR_CHARS.length + 1 && name[OPERATOR_CHARS.length] == ' ' && CharArrayUtils.equals(name, 0, OPERATOR_CHARS.length, OPERATOR_CHARS)) {
            return !cas.containsKey(name, OPERATOR_CHARS.length + 1, name.length - (OPERATOR_CHARS.length + 1));
        }
        return false;
    }

    public static CVQualifier getCVQualifier(IType t) {
        if (t instanceof IQualifierType) {
            IQualifierType qt = (IQualifierType)t;
            return qt.isConst() ? (qt.isVolatile() ? CVQualifier.CONST_VOLATILE : CVQualifier.CONST) : (qt.isVolatile() ? CVQualifier.VOLATILE : CVQualifier.NONE);
        }
        if (t instanceof IPointerType) {
            IPointerType pt = (IPointerType)t;
            return pt.isConst() ? (pt.isVolatile() ? (pt.isRestrict() ? CVQualifier.CONST_VOLATILE_RESTRICT : CVQualifier.CONST_VOLATILE) : (pt.isRestrict() ? CVQualifier.CONST_RESTRICT : CVQualifier.CONST)) : (pt.isVolatile() ? (pt.isRestrict() ? CVQualifier.VOLATILE_RESTRICT : CVQualifier.VOLATILE) : (pt.isRestrict() ? CVQualifier.RESTRICT : CVQualifier.NONE));
        }
        if (t instanceof IArrayType) {
            return SemanticUtil.getCVQualifier(((IArrayType)t).getType());
        }
        return CVQualifier.NONE;
    }

    public static IType getUltimateType(IType type, boolean stopAtPointerToMember) {
        return SemanticUtil.getNestedType(type, stopAtPointerToMember ? 181 : 245);
    }

    public static IType getUltimateTypeUptoPointers(IType type) {
        return SemanticUtil.getNestedType(type, 13);
    }

    public static IType getNestedType(IType type, int options) {
        boolean tdef = (options & 1) != 0;
        boolean cond_tdef = (options & 2) != 0;
        boolean ptr = (options & 0x20) != 0;
        boolean mptr = (options & 0x40) != 0;
        boolean allcvq = (options & 0x10) != 0;
        boolean cvtype = (options & 8) != 0;
        IType beforeTypedefs = null;
        while (true) {
            IType nested;
            IType t = null;
            if (type instanceof ITypedef) {
                if (tdef || cond_tdef) {
                    if (beforeTypedefs == null && cond_tdef) {
                        beforeTypedefs = type;
                    }
                    t = ((ITypedef)type).getType();
                }
            } else if (type instanceof IPointerType) {
                IPointerType pt;
                boolean isMbrPtr = type instanceof ICPPPointerToMemberType;
                if (ptr && !isMbrPtr || mptr && isMbrPtr) {
                    t = ((IPointerType)type).getType();
                    beforeTypedefs = null;
                } else if (allcvq && ((pt = (IPointerType)type).isConst() || pt.isVolatile() || pt.isRestrict())) {
                    if (pt instanceof ICPPPointerToMemberType) {
                        IType memberOfClass = ((ICPPPointerToMemberType)pt).getMemberOfClass();
                        return new CPPPointerToMemberType(pt.getType(), memberOfClass, false, false, false);
                    }
                    return new CPPPointerType(pt.getType(), false, false, false);
                }
            } else if (type instanceof IQualifierType) {
                IQualifierType qt = (IQualifierType)type;
                IType qttgt = qt.getType();
                if (allcvq || cvtype) {
                    t = qttgt;
                    beforeTypedefs = null;
                } else if (tdef || cond_tdef) {
                    t = SemanticUtil.getNestedType(qttgt, options);
                    if (t == qttgt) {
                        return qt;
                    }
                    return SemanticUtil.addQualifiers(t, qt.isConst(), qt.isVolatile(), false);
                }
            } else if (type instanceof IArrayType) {
                IArrayType atype = (IArrayType)type;
                if ((options & 0x80) != 0) {
                    t = atype.getType();
                    beforeTypedefs = null;
                } else if (allcvq) {
                    IType newNested;
                    nested = atype.getType();
                    if (nested == (newNested = SemanticUtil.getNestedType(nested, 16))) {
                        return type;
                    }
                    return SemanticUtil.replaceNestedType((ITypeContainer)((Object)atype), newNested);
                }
            } else if (type instanceof ICPPReferenceType) {
                ICPPReferenceType rt = (ICPPReferenceType)type;
                if ((options & 4) != 0) {
                    t = rt.getType();
                    beforeTypedefs = null;
                } else if (tdef) {
                    IType newNested;
                    nested = rt.getType();
                    if (nested == (newNested = SemanticUtil.getNestedType(nested, 1))) {
                        return type;
                    }
                    return SemanticUtil.replaceNestedType((ITypeContainer)((Object)rt), newNested);
                }
            }
            if (t == null) {
                if (beforeTypedefs != null) {
                    return beforeTypedefs;
                }
                return type;
            }
            type = t;
        }
    }

    public static IType getSimplifiedType(IType type) {
        if (type instanceof ICPPFunctionType) {
            ICPPFunctionType ft = (ICPPFunctionType)type;
            IType ret = null;
            IType[] params = null;
            IType r = ft.getReturnType();
            ret = SemanticUtil.getSimplifiedType(r);
            IType[] ps = ft.getParameterTypes();
            params = SemanticUtil.getSimplifiedTypes(ps);
            if (ret == r && params == ps) {
                return type;
            }
            return new CPPFunctionType(ret, params, ft.isConst(), ft.isVolatile(), ft.takesVarArgs());
        }
        if (type instanceof ITypedef) {
            IType t = ((ITypedef)type).getType();
            if (t != null) {
                return SemanticUtil.getSimplifiedType(t);
            }
            return type;
        }
        if (type instanceof ITypeContainer) {
            ITypeContainer tc = (ITypeContainer)type;
            IType nestedType = tc.getType();
            if (nestedType == null) {
                return type;
            }
            IType newType = SemanticUtil.getSimplifiedType(nestedType);
            if (newType != nestedType) {
                return SemanticUtil.replaceNestedType(tc, newType);
            }
            return type;
        }
        return type;
    }

    static boolean isSimplified(IType type) {
        if (type instanceof ICPPFunctionType) {
            IType[] ps;
            ICPPFunctionType ft = (ICPPFunctionType)type;
            if (!SemanticUtil.isSimplified(ft.getReturnType())) {
                return false;
            }
            IType[] iTypeArray = ps = ft.getParameterTypes();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IType p = iTypeArray[n2];
                if (!SemanticUtil.isSimplified(p)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (type instanceof ITypedef) {
            return false;
        }
        if (type instanceof ITypeContainer) {
            return SemanticUtil.isSimplified(((ITypeContainer)type).getType());
        }
        return true;
    }

    public static IType replaceNestedType(ITypeContainer type, IType newNestedType) {
        if (newNestedType == null) {
            return type;
        }
        if (type instanceof IQualifierType) {
            IQualifierType qt = (IQualifierType)((Object)type);
            return SemanticUtil.addQualifiers(newNestedType, qt.isConst(), qt.isVolatile(), false);
        }
        type = (ITypeContainer)type.clone();
        type.setType(newNestedType);
        return type;
    }

    public static IType substituteTypedef(IType type, IType typedefType) {
        if (!((typedefType = SemanticUtil.getNestedType(typedefType, 180)) instanceof ITypedef)) {
            return null;
        }
        IType nestedType = type;
        while (!nestedType.isSameType(((ITypedef)typedefType).getType())) {
            if (nestedType instanceof IQualifierType) {
                nestedType = ((IQualifierType)nestedType).getType();
                continue;
            }
            if (nestedType instanceof IPointerType) {
                nestedType = ((IPointerType)nestedType).getType();
                continue;
            }
            if (nestedType instanceof IArrayType) {
                nestedType = ((IArrayType)nestedType).getType();
                continue;
            }
            if (nestedType instanceof ICPPReferenceType) {
                nestedType = ((ICPPReferenceType)nestedType).getType();
                continue;
            }
            return null;
        }
        IType result = null;
        ITypeContainer containerType = null;
        IType t = type;
        while (true) {
            IType newType;
            IType iType = newType = t == nestedType ? typedefType : (IType)t.clone();
            if (result == null) {
                result = newType;
            }
            if (containerType != null) {
                containerType.setType(newType);
            }
            if (t == nestedType) {
                return result;
            }
            if (!(t instanceof ITypeContainer)) {
                return null;
            }
            containerType = (ITypeContainer)t;
            t = containerType.getType();
        }
    }

    public static IType mapToAST(IType type, IASTNode node) {
        IASTTranslationUnit tu;
        if (node == null) {
            return type;
        }
        if (type instanceof IFunctionType) {
            ICPPFunctionType ft = (ICPPFunctionType)type;
            IType r = ft.getReturnType();
            IType ret = SemanticUtil.mapToAST(r, node);
            if (ret == r) {
                return type;
            }
            return new CPPFunctionType(ret, ft.getParameterTypes(), ft.isConst(), ft.isVolatile(), ft.takesVarArgs());
        }
        if (type instanceof ITypeContainer) {
            ITypeContainer tc = (ITypeContainer)type;
            IType nestedType = tc.getType();
            if (nestedType == null) {
                return type;
            }
            IType newType = SemanticUtil.mapToAST(nestedType, node);
            if (newType != nestedType) {
                return SemanticUtil.replaceNestedType(tc, newType);
            }
            return type;
        }
        if (type instanceof ICPPClassType && type instanceof IIndexBinding && (tu = node.getTranslationUnit()) instanceof CPPASTTranslationUnit) {
            return ((CPPASTTranslationUnit)tu).mapToAST((ICPPClassType)type, node);
        }
        return type;
    }

    public static IType[] getSimplifiedTypes(IType[] types) {
        IType[] result = types;
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            IType newType = SemanticUtil.getSimplifiedType(type);
            if (result != types) {
                result[i] = newType;
            } else if (type != newType) {
                result = new IType[types.length];
                if (i > 0) {
                    System.arraycopy(types, 0, result, 0, i);
                }
                result[i] = newType;
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument[] getSimplifiedArguments(ICPPTemplateArgument[] args) {
        ICPPTemplateArgument[] result = args;
        int i = 0;
        while (i < args.length) {
            ICPPTemplateArgument arg;
            ICPPTemplateArgument newArg = arg = args[i];
            if (arg != null) {
                newArg = SemanticUtil.getSimplifiedArgument(arg);
                if (result != args) {
                    result[i] = newArg;
                } else if (arg != newArg) {
                    result = new ICPPTemplateArgument[args.length];
                    if (i > 0) {
                        System.arraycopy(args, 0, result, 0, i);
                    }
                    result[i] = newArg;
                }
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument getSimplifiedArgument(ICPPTemplateArgument arg) {
        IType type;
        IType newType;
        if (arg.isTypeValue() && (newType = SemanticUtil.getSimplifiedType(type = arg.getTypeValue())) != type) {
            return new CPPTemplateTypeArgument(newType, arg.getOriginalTypeValue());
        }
        return arg;
    }

    public static IType constQualify(IType baseType) {
        return SemanticUtil.addQualifiers(baseType, true, false, false);
    }

    public static IType addQualifiers(IType baseType, boolean cnst, boolean vol, boolean restrict) {
        if (cnst || vol || restrict) {
            if (baseType instanceof IQualifierType) {
                IQualifierType qt = (IQualifierType)baseType;
                if (cnst && !qt.isConst() || vol && !qt.isVolatile()) {
                    return new CPPQualifierType(qt.getType(), cnst || qt.isConst(), vol || qt.isVolatile());
                }
                return baseType;
            }
            if (baseType instanceof ICPPPointerToMemberType) {
                ICPPPointerToMemberType pt = (ICPPPointerToMemberType)baseType;
                if (cnst && !pt.isConst() || vol && !pt.isVolatile() || restrict && !pt.isRestrict()) {
                    return new CPPPointerToMemberType(pt.getType(), pt.getMemberOfClass(), cnst || pt.isConst(), vol || pt.isVolatile(), restrict || pt.isRestrict());
                }
                return baseType;
            }
            if (baseType instanceof IPointerType) {
                IPointerType pt = (IPointerType)baseType;
                if (cnst && !pt.isConst() || vol && !pt.isVolatile() || restrict && !pt.isRestrict()) {
                    return new CPPPointerType(pt.getType(), cnst || pt.isConst(), vol || pt.isVolatile(), restrict || pt.isRestrict());
                }
                return baseType;
            }
            if (baseType instanceof IArrayType) {
                IArrayType at = (IArrayType)baseType;
                IType nested = at.getType();
                IType newNested = SemanticUtil.addQualifiers(nested, cnst, vol, restrict);
                if (newNested != nested && at instanceof ITypeContainer) {
                    return SemanticUtil.replaceNestedType((ITypeContainer)((Object)at), newNested);
                }
                return at;
            }
            if (baseType instanceof ICPPReferenceType) {
                return baseType;
            }
            if (baseType == null) {
                return null;
            }
            return new CPPQualifierType(baseType, cnst, vol);
        }
        return baseType;
    }

    public static boolean isSameOwner(IBinding owner1, IBinding owner2) {
        while (owner1 instanceof ICPPNamespace && owner1.getNameCharArray().length == 0) {
            owner1 = owner1.getOwner();
        }
        while (owner2 instanceof ICPPNamespace && owner2.getNameCharArray().length == 0) {
            owner2 = owner2.getOwner();
        }
        if (owner1 == null) {
            return owner2 == null;
        }
        if (owner2 == null) {
            return false;
        }
        if (owner1 instanceof IType) {
            if (owner2 instanceof IType) {
                return ((IType)((Object)owner1)).isSameType((IType)((Object)owner2));
            }
        } else if (owner1 instanceof ICPPNamespace && owner2 instanceof ICPPNamespace) {
            if (!CharArrayUtils.equals(owner1.getNameCharArray(), owner2.getNameCharArray())) {
                return false;
            }
            return SemanticUtil.isSameOwner(owner1.getOwner(), owner2.getOwner());
        }
        return false;
    }

    public static boolean isVoidType(IType ptype) {
        while (ptype instanceof ITypedef) {
            ptype = ((ITypedef)ptype).getType();
        }
        if (ptype instanceof IBasicType) {
            return ((IBasicType)ptype).getKind() == IBasicType.Kind.eVoid;
        }
        return false;
    }

    public static boolean isEmptyParameterList(IType[] parameters) {
        if (parameters.length == 0) {
            return true;
        }
        return parameters.length == 1 && SemanticUtil.isVoidType(parameters[0]);
    }

    public static final int calculateInheritanceDepth(IType type, IType baseClass, IASTNode point) {
        return SemanticUtil.calculateInheritanceDepth(16, new HashSet<Object>(), type, baseClass, point);
    }

    private static final int calculateInheritanceDepth(int maxdepth, Set<Object> hashSet, IType type, IType baseClass, IASTNode point) {
        if (type == baseClass || type.isSameType(baseClass)) {
            return 0;
        }
        if (maxdepth > 0 && type instanceof ICPPClassType && baseClass instanceof ICPPClassType) {
            ICPPClassType clazz = (ICPPClassType)type;
            if (clazz instanceof ICPPDeferredClassInstance) {
                clazz = (ICPPClassType)((ICPPDeferredClassInstance)clazz).getSpecializedBinding();
            }
            ICPPBase[] iCPPBaseArray = ClassTypeHelper.getBases(clazz, point);
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof IType && hashSet.add(base)) {
                    int n3;
                    IType tbase = (IType)((Object)base);
                    if (tbase.isSameType(baseClass) || baseClass instanceof ICPPSpecialization && ((IType)((Object)((ICPPSpecialization)((Object)baseClass)).getSpecializedBinding())).isSameType(tbase)) {
                        return 1;
                    }
                    if (tbase instanceof ICPPClassType && (n3 = SemanticUtil.calculateInheritanceDepth(maxdepth - 1, hashSet, tbase, baseClass, point)) > 0) {
                        return n3 + 1;
                    }
                }
                ++n2;
            }
        }
        return -1;
    }

    public static boolean containsUniqueTypeForParameterPack(IType type) {
        IBinding owner;
        if (type instanceof ICPPFunctionType) {
            ICPPFunctionType ft = (ICPPFunctionType)type;
            if (SemanticUtil.containsUniqueTypeForParameterPack(ft.getReturnType())) {
                return true;
            }
            IType[] iTypeArray = ft.getParameterTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType pt = iTypeArray[n2];
                if (SemanticUtil.containsUniqueTypeForParameterPack(pt)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (type instanceof ICPPPointerToMemberType && SemanticUtil.containsUniqueTypeForParameterPack(((ICPPPointerToMemberType)type).getMemberOfClass())) {
            return true;
        }
        if (type instanceof IBinding && (owner = ((IBinding)((Object)type)).getOwner()) instanceof IType && SemanticUtil.containsUniqueTypeForParameterPack((IType)((Object)owner))) {
            return true;
        }
        if (type instanceof ICPPTemplateInstance) {
            ICPPTemplateArgument[] args;
            ICPPTemplateArgument[] iCPPTemplateArgumentArray = args = ((ICPPTemplateInstance)((Object)type)).getTemplateArguments();
            int n = args.length;
            int n3 = 0;
            while (n3 < n) {
                ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n3];
                if (SemanticUtil.containsUniqueTypeForParameterPack(arg.getTypeValue())) {
                    return true;
                }
                ++n3;
            }
        }
        if (type instanceof ITypeContainer) {
            ITypeContainer tc = (ITypeContainer)type;
            IType nestedType = tc.getType();
            return SemanticUtil.containsUniqueTypeForParameterPack(nestedType);
        }
        if (type instanceof UniqueType) {
            return ((UniqueType)type).isForParameterPack();
        }
        return false;
    }
}

